/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.mapper;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentMapper {
    private static final Logger log = LoggerFactory.getLogger(ContentMapper.class);
    private final PageManager pageManager;

    public ContentMapper(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public AbstractPage buildContent(AbstractPage originalContent, Integer version) {
        ContentEntityObject content = this.pageManager.getOtherVersion((ContentEntityObject)originalContent, version.intValue());
        if (content == null) {
            Page fakeContent = null;
            if (originalContent instanceof Page) {
                fakeContent = new Page();
            } else if (originalContent instanceof BlogPost) {
                fakeContent = new BlogPost();
            }
            fakeContent.setSpace(originalContent.getSpace());
            fakeContent.setVersion(version.intValue());
            fakeContent.setAttachments(originalContent.getAttachments());
            fakeContent.setId(originalContent.getId());
            content = fakeContent;
            log.error("Version with number " + version + " for page with " + originalContent.getId() + " could not be found as it might have probably been deleted. We will proceed to generate and store the entry still pointing to the missing version");
        }
        return (AbstractPage)content;
    }
}

