/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoc.command;

import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessBlocked;
import com.atlassian.confluence.core.service.ServiceCommandValidator;
import com.comalatech.confluence.adhoc.command.AbstractAdhocWorkflowCommand;
import com.comalatech.confluence.states.model.State;
import com.comalatech.confluence.tasks.model.Task;
import com.comalatech.confluence.tasks.model.TaskType;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.WorkflowException;

@ReadOnlyAccessBlocked
public class AddTaskCommand
extends AbstractAdhocWorkflowCommand {
    private String taskTypeName;

    @Override
    public void doWithWorkflow(Workflow workflow) throws WorkflowException {
        State state = workflow.getStatesContainer().getState(this.stateName);
        TaskType type = TaskType.parse(this.taskTypeName);
        Task task = new Task(this.taskName, type, null, null);
        state.addTask(task);
    }

    @Override
    public void validateWorkflow(ServiceCommandValidator validator, Workflow workflow) {
        State state = workflow.getStatesContainer().getState(this.stateName);
        Task task = state.getTask(this.taskName);
        if (task != null) {
            validator.addValidationError("comalatech.awp.designer.error.task.name.duplicate", new Object[]{this.taskName});
        } else if (!Task.isValidTaskName(this.taskName)) {
            validator.addValidationError("comalatech.awp.designer.error.task.name.invalid", new Object[]{this.taskName});
        }
        if (TaskType.parse(this.taskTypeName) == null) {
            validator.addValidationError("comalatech.awp.designer.error.task.type.invalid", new Object[]{this.taskName});
        }
    }

    @Override
    public boolean requiresExistingState() {
        return true;
    }

    @Override
    public boolean requiresExistingTask() {
        return false;
    }

    public void setTaskTypeName(String taskTypeName) {
        this.taskTypeName = taskTypeName;
    }
}

