/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowcontainer.model;

import com.comalatech.confluence.workflowcontainer.model.RemoteWorkflowCategory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class RemoteWorkflow
implements Serializable {
    private String id;
    private String name;
    private String description;
    private int version;
    private String body;
    private String chartUrl;
    private String workflowUrl;
    private List<RemoteWorkflowCategory> categories;

    public RemoteWorkflow(String id, String name, int version, String chartUrl, String workflowUrl) {
        this.id = id;
        this.name = name;
        this.version = version;
        this.chartUrl = chartUrl;
        this.workflowUrl = workflowUrl;
        this.categories = new ArrayList<RemoteWorkflowCategory>();
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public int getVersion() {
        return this.version;
    }

    public String getBody() {
        return this.body;
    }

    public List<RemoteWorkflowCategory> getCategories() {
        return this.categories;
    }

    public String getChartUrl() {
        return this.chartUrl;
    }

    public String getWorkflowUrl() {
        return this.workflowUrl;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void addCategory(String id, String name, String description) {
        this.categories.add(new RemoteWorkflowCategory(id, name, description));
    }

    public void addCategories(Set<RemoteWorkflowCategory> repositoryCategories) {
        for (RemoteWorkflowCategory category : this.categories) {
            if (repositoryCategories.contains(category)) continue;
            repositoryCategories.add(category);
        }
    }

    public boolean hasCategory(String category) {
        for (RemoteWorkflowCategory workflowCategory : this.categories) {
            if (!workflowCategory.getId().equals(category)) continue;
            return true;
        }
        return false;
    }
}

