/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowcontainer.action;

import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.WikiStyleRenderer;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflowcontainer.WorkflowContainerManager;
import com.comalatech.confluence.workflowcontainer.model.RemoteWorkflow;
import com.comalatech.confluence.workflowcontainer.model.RemoteWorkflowsRepository;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryActionHelper {
    private static final Logger log = LoggerFactory.getLogger(RepositoryActionHelper.class);
    private RemoteWorkflowsRepository remoteWorkflows;
    private WorkflowContainerManager workflowContainerManager;
    private WikiStyleRenderer wikiStyleRenderer;
    private WebResourceManager webResourceManager;
    private String category;
    private String workflowId;
    private String errorMessage;
    private boolean reload;
    private String spaceKey;
    private String section;

    public void loadWorkflows() {
        this.webResourceManager.requireResource("confluence.web.resources:jquery");
        this.webResourceManager.requireResource("confluence.web.resources:ajs");
        this.remoteWorkflows = this.workflowContainerManager.getRemoteWorkflows(this.reload);
    }

    public String install() {
        this.loadWorkflows();
        RemoteWorkflow remoteWorkflow = this.remoteWorkflows.get(this.workflowId);
        if (remoteWorkflow == null) {
            this.errorMessage = "Invalid workflow id " + this.workflowId;
            return "error";
        }
        try {
            Workflow workflow = this.workflowContainerManager.renderWorkflow(remoteWorkflow.getBody());
            workflow.setName(remoteWorkflow.getName());
            workflow.setKey(remoteWorkflow.getId());
            if (StringUtils.isBlank((CharSequence)this.spaceKey) || this.section.equalsIgnoreCase("page")) {
                this.workflowContainerManager.saveWorkflowTemplate(this.spaceKey, workflow, false, null);
            } else if (this.section.equalsIgnoreCase("space")) {
                this.workflowContainerManager.saveProductionWorkflow(this.spaceKey, workflow, null);
            }
            return "success";
        }
        catch (Exception e) {
            this.errorMessage = e.getMessage();
            log.error("error " + e.getMessage());
            return "error";
        }
    }

    public boolean templateExists(String name) {
        return this.workflowContainerManager.isWorkflowTemplateExists(this.spaceKey, name);
    }

    public String render(String body) {
        PageContext context = new PageContext(this.spaceKey);
        context.pushRenderMode(RenderMode.ALL);
        return this.wikiStyleRenderer.convertWikiToXHtml((RenderContext)context, body);
    }

    public void setWikiStyleRenderer(WikiStyleRenderer wikiStyleRenderer) {
        this.wikiStyleRenderer = wikiStyleRenderer;
    }

    public RemoteWorkflowsRepository getRemoteWorkflows() {
        return this.remoteWorkflows;
    }

    public void setWebResourceManager(WebResourceManager webResourceManager) {
        this.webResourceManager = webResourceManager;
    }

    public String getCategory() {
        return this.category;
    }

    @HtmlSafe
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setWorkflowContainerManager(WorkflowContainerManager workflowContainerManager) {
        this.workflowContainerManager = workflowContainerManager;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public void setWorkflowId(String workflowId) {
        this.workflowId = workflowId;
    }

    public void setReload(boolean reload) {
        this.reload = reload;
    }

    public void setSpaceKey(String spaceKey) {
        this.spaceKey = spaceKey;
    }

    public String getSpaceKey() {
        return this.spaceKey;
    }

    public void setSection(String section) {
        this.section = section;
    }

    public String getSection() {
        return this.section;
    }
}

