/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.restv2.model.mappers;

import com.atlassian.confluence.labels.Label;
import com.comalatech.confluence.workflow.model.AllowedAssignerGroupCondition;
import com.comalatech.confluence.workflow.model.AllowedAssignerUserCondition;
import com.comalatech.confluence.workflow.model.Approval;
import com.comalatech.confluence.workflow.model.ApproverCondition;
import com.comalatech.confluence.workflow.model.Condition;
import com.comalatech.confluence.workflow.model.ExcludeCondition;
import com.comalatech.confluence.workflow.model.GroupCondition;
import com.comalatech.confluence.workflow.model.Selector;
import com.comalatech.confluence.workflow.model.UserCondition;
import com.comalatech.confluence.workflow.restv2.model.RestApproval;
import com.comalatech.confluence.workflow.restv2.model.RestItemList;
import com.comalatech.confluence.workflow.restv2.model.mappers.Mapper;
import com.comalatech.workflow.model.SignatureType;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;

public class ApprovalMapper
implements Mapper<Approval, RestApproval> {
    public static final String PASSWORD = "password";
    public static final String USER_PASSWORD = "user+password";

    @Override
    public RestApproval toRest(Approval approval) {
        RestApproval restApproval = new RestApproval();
        restApproval.name = approval.getName();
        if (approval.getWeight() != 40) {
            restApproval.weight = approval.getWeight();
        }
        if (approval.getLabel() != null) {
            restApproval.label = approval.getLabel().getName();
        }
        restApproval.approveLabel = approval.getApproveLabel();
        restApproval.rejectLabel = approval.getRejectLabel();
        if (approval.getCredentials() == SignatureType.PASSWORD) {
            restApproval.credentials = PASSWORD;
        } else if (approval.getCredentials() == SignatureType.USERID_AND_PASSWORD) {
            restApproval.credentials = USER_PASSWORD;
        }
        restApproval.isFinal = approval.isFinalApproval() ? Boolean.valueOf(true) : null;
        restApproval.assignable = approval.isAssignable() ? Boolean.valueOf(true) : null;
        restApproval.roles = approval.isRoles() ? Boolean.valueOf(true) : null;
        restApproval.rememberAssignees = approval.isRememberAssignees() ? Boolean.valueOf(true) : null;
        restApproval.description = approval.getDescription();
        restApproval.visibleContentTypes = new ArrayList<RestApproval.ContentType>();
        if (approval.isShowInPages()) {
            restApproval.visibleContentTypes.add(RestApproval.ContentType.PAGE);
        }
        if (approval.isShowInBlogs()) {
            restApproval.visibleContentTypes.add(RestApproval.ContentType.BLOGPOST);
        }
        if (approval.getConditions() != null && approval.getConditions().size() > 0) {
            List<Condition> pendingConditions = this.toRestFlattenConditions(restApproval, approval);
            restApproval.conditions = this.parseConditionsToRest(pendingConditions);
            if (restApproval.conditions.isEmpty()) {
                restApproval.conditions = null;
            }
        }
        if (restApproval.minimum == null && approval.getMinRequiredApprovers() != null) {
            restApproval.minimum = approval.getMinRequiredApprovers();
            if (restApproval.minimum.equals("0")) {
                restApproval.minimum = "1";
            }
        }
        return restApproval;
    }

    private List<Condition> toRestFlattenConditions(RestApproval restApproval, Approval approval) {
        ArrayList<Condition> conditions = new ArrayList<Condition>(approval.getConditions());
        Iterator i = conditions.iterator();
        while (i.hasNext()) {
            Condition condition = (Condition)i.next();
            if (condition instanceof AllowedAssignerUserCondition) {
                AllowedAssignerUserCondition allowedAssignerUserCondition = (AllowedAssignerUserCondition)condition;
                restApproval.allowedAssignUsers = new RestItemList.Negated(allowedAssignerUserCondition.getUserNames(), allowedAssignerUserCondition.isNot() ? Boolean.valueOf(true) : null);
                i.remove();
                continue;
            }
            if (condition instanceof AllowedAssignerGroupCondition) {
                AllowedAssignerGroupCondition allowedAssignerGroupCondition = (AllowedAssignerGroupCondition)condition;
                restApproval.allowedAssignGroups = new RestItemList.Negated(allowedAssignerGroupCondition.getGroupNames(), allowedAssignerGroupCondition.isNot() ? Boolean.valueOf(true) : null);
                i.remove();
                continue;
            }
            if (condition instanceof UserCondition) {
                UserCondition userCondition = (UserCondition)condition;
                restApproval.users = new RestItemList.Negated(userCondition.getUserNames(), userCondition.isNot() ? Boolean.valueOf(true) : null);
                i.remove();
                continue;
            }
            if (condition instanceof GroupCondition) {
                GroupCondition groupCondition = (GroupCondition)condition;
                restApproval.groups = new RestItemList.Negated(groupCondition.getGroupNames(), groupCondition.isNot() ? Boolean.valueOf(true) : null);
                i.remove();
                continue;
            }
            if (condition instanceof ExcludeCondition) {
                ExcludeCondition excludeCondition = (ExcludeCondition)condition;
                restApproval.exclude = new RestItemList(excludeCondition.getUserNames());
                i.remove();
                continue;
            }
            if (!(condition instanceof ApproverCondition)) continue;
            ApproverCondition approverCondition = (ApproverCondition)condition;
            switch (approverCondition.getSelector().getType()) {
                case 3: {
                    approverCondition.generateUsersGroupsList();
                    String userList = approverCondition.getUserList();
                    String groupList = approverCondition.getGroupList();
                    if (TextUtils.stringSet((String)userList)) {
                        restApproval.preassignedUsers = new RestItemList(userList.split(","));
                    }
                    if (!TextUtils.stringSet((String)groupList)) break;
                    restApproval.preassignedGroups = new RestItemList(groupList.split(","));
                    break;
                }
                case 1: {
                    restApproval.selectedApprover = new RestItemList(approverCondition.getSelector().getUsersAsArray());
                    break;
                }
                case 2: {
                    restApproval.selectedApprovers = new RestItemList(approverCondition.getSelector().getUsersAsArray());
                    String minOneManyValue = approverCondition.getSelector().getMinimum();
                    restApproval.minimum = StringUtils.isNumeric((CharSequence)minOneManyValue) ? (Integer.parseInt(minOneManyValue) > 1 ? minOneManyValue : null) : minOneManyValue;
                }
            }
            i.remove();
        }
        return conditions;
    }

    @Override
    public Approval fromRest(RestApproval restApproval) {
        SignatureType credentials = SignatureType.NONE;
        if (restApproval.credentials != null) {
            switch (restApproval.credentials) {
                case "password": {
                    credentials = SignatureType.PASSWORD;
                    break;
                }
                case "user+password": {
                    credentials = SignatureType.USERID_AND_PASSWORD;
                }
            }
        }
        List<Condition> conditions = this.parseConditionsFromRest(restApproval.conditions);
        conditions.addAll(this.fromRestUnflattenConditions(restApproval));
        Approval approval = new Approval(restApproval.name, restApproval.weight != null ? restApproval.weight : 40, conditions, BooleanUtils.isTrue((Boolean)restApproval.isFinal), true, true, credentials.getId());
        approval.setAssignable(BooleanUtils.isTrue((Boolean)restApproval.assignable));
        approval.setRoles(BooleanUtils.isTrue((Boolean)restApproval.roles));
        approval.setRememberAssignees(BooleanUtils.isTrue((Boolean)restApproval.rememberAssignees));
        approval.setDescription(restApproval.description);
        if (restApproval.visibleContentTypes != null && restApproval.visibleContentTypes.contains((Object)RestApproval.ContentType.PAGE)) {
            approval.setShowInPages(true);
        }
        if (restApproval.visibleContentTypes != null && restApproval.visibleContentTypes.contains((Object)RestApproval.ContentType.BLOGPOST)) {
            approval.setShowInBlogs(true);
        }
        if (restApproval.label != null) {
            approval.setLabel(new Label(restApproval.label));
        }
        approval.setApproveLabel(restApproval.approveLabel);
        approval.setRejectLabel(restApproval.rejectLabel);
        if (restApproval.minimum != null && !restApproval.minimum.equals("1") && !restApproval.minimum.equals("0")) {
            approval.setMinRequiredApprovers(restApproval.minimum);
        }
        return approval;
    }

    private List<Condition> fromRestUnflattenConditions(RestApproval restApproval) {
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        if (restApproval.allowedAssignUsers != null && restApproval.allowedAssignUsers.verifyContentValid() != null) {
            conditions.add(new AllowedAssignerUserCondition(BooleanUtils.isTrue((Boolean)restApproval.allowedAssignUsers.negate), StringUtils.join((Object[])restApproval.allowedAssignUsers.items, (String)",")));
        }
        if (restApproval.allowedAssignGroups != null && restApproval.allowedAssignGroups.verifyContentValid() != null) {
            conditions.add(new AllowedAssignerGroupCondition(BooleanUtils.isTrue((Boolean)restApproval.allowedAssignGroups.negate), StringUtils.join((Object[])restApproval.allowedAssignGroups.items, (String)",")));
        }
        if (restApproval.users != null && restApproval.users.verifyContentValid() != null) {
            conditions.add(new UserCondition(BooleanUtils.isTrue((Boolean)restApproval.users.negate), StringUtils.join((Object[])restApproval.users.items, (String)",")));
        }
        if (restApproval.groups != null && restApproval.groups.verifyContentValid() != null) {
            conditions.add(new GroupCondition(BooleanUtils.isTrue((Boolean)restApproval.groups.negate), StringUtils.join((Object[])restApproval.groups.items, (String)",")));
        }
        if (restApproval.exclude != null && restApproval.exclude.verifyContentValid() != null) {
            conditions.add(new ExcludeCondition(StringUtils.join((Object[])restApproval.exclude.items, (String)",")));
        }
        if (restApproval.preassignedUsers != null && restApproval.preassignedUsers.verifyContentValid() != null) {
            conditions.add(new ApproverCondition(new Selector(StringUtils.join((Object[])restApproval.preassignedUsers.items, (String)","), 3), ApproverCondition.ApproverConditionType.USER));
        }
        if (restApproval.preassignedGroups != null && restApproval.preassignedGroups.verifyContentValid() != null) {
            conditions.add(new ApproverCondition(new Selector(StringUtils.join((Object[])restApproval.preassignedGroups.items, (String)","), 3), ApproverCondition.ApproverConditionType.GROUP));
        }
        if (restApproval.selectedApprovers != null && restApproval.selectedApprovers.verifyContentValid() != null) {
            conditions.add(new ApproverCondition(new Selector(StringUtils.join((Object[])restApproval.selectedApprovers.items, (String)","), 2), ApproverCondition.ApproverConditionType.USER));
        }
        if (restApproval.selectedApprover != null) {
            conditions.add(new ApproverCondition(new Selector(StringUtils.join((Object[])restApproval.selectedApprover.items, (String)","), 1), ApproverCondition.ApproverConditionType.USER));
        }
        return conditions;
    }
}

