/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.documentReport;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ApprovalsDataEnum {
    COMALA_WORKFLOWS_PENDING_APPROVALS("comalaworkflowspendingapprovals"),
    COMALA_WORKFLOWS_APPROVED_APPROVALS("comalaworkflowsapprovedapprovals"),
    COMALA_WORKFLOWS_REJECTED_APPROVALS("comalaworkflowsrejectedapprovals");

    private static final Logger log;
    private final String value;

    private ApprovalsDataEnum(String value) {
        this.value = value;
    }

    public static Optional<ApprovalsDataEnum> fromString(String text) {
        return Arrays.stream(ApprovalsDataEnum.values()).filter(userData -> userData.value.equalsIgnoreCase(text)).findFirst();
    }

    public List<String> getApprovalsData(String approvalsContent) {
        LinkedHashMap approvals = null;
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(DeserializationConfig.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
            approvals = (LinkedHashMap)mapper.readValue(approvalsContent, LinkedHashMap.class);
        }
        catch (Exception ex) {
            log.warn("Cannot extract approvals name list {} : {}", new Object[]{approvalsContent, this, ex});
        }
        if (approvals != null && approvals.size() > 0) {
            return (List)approvals.get("approvalNameList");
        }
        return new ArrayList<String>();
    }

    static {
        log = LoggerFactory.getLogger(ApprovalsDataEnum.class);
    }
}

