/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.util;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.comalatech.confluence.util.MiscUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Awp31UpgradeUtils {
    public static final String WORKFLOWS_KEY = "com.comalatech.workflows";
    private BandanaManager bandanaManager;
    private PageManager pageManager;

    public Awp31UpgradeUtils(BandanaManager bandanaManager, PageManager pageManager) {
        this.bandanaManager = bandanaManager;
        this.pageManager = pageManager;
    }

    public List<Page> getLegacyWorkflowPages() {
        String[] ids = MiscUtils.splitAndTrim((String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), WORKFLOWS_KEY));
        if (ids.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Page> pages = new ArrayList<Page>(ids.length);
        for (String id : ids) {
            try {
                Page page = this.pageManager.getPage(Long.parseLong(id));
                if (page == null) continue;
                pages.add(page);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return pages;
    }
}

