/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.upgrade.readConfirmation.migration;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.persistence.EntityManagerProvider;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.confluence.util.longrunning.ConfluenceAbstractLongRunningTask;
import com.atlassian.sal.api.rdbms.TransactionalExecutorFactory;
import com.comalatech.confluence.adhoc.dao.ComalatechBandanaContext;
import com.comalatech.confluence.readack.activeObjects.entity.BaseReadAckRecord;
import com.comalatech.confluence.readack.model.ReadAckRecordImpl;
import com.comalatech.confluence.readack.model.ReadAckStatusType;
import com.comalatech.confluence.upgrade.readConfirmation.migration.ReadConfirmationQueryMigrationStrings;
import com.comalatech.confluence.upgrade.readConfirmation.migration.status.ReadConfirmationMigrationTableCheck;
import com.comalatech.confluence.util.db.DataBaseNameUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadConfirmationDataMigrationLongRunningTask
extends ConfluenceAbstractLongRunningTask {
    private static final Logger log = LoggerFactory.getLogger(ReadConfirmationDataMigrationLongRunningTask.class);
    private final TransactionalExecutorFactory transactionalExecutorFactory;
    private final EntityManagerProvider entityManagerProvider;
    private I18NBeanFactory i18NBeanFactory;
    private BandanaManager bandanaManager;

    public ReadConfirmationDataMigrationLongRunningTask(TransactionalExecutorFactory transactionalExecutorFactory, EntityManagerProvider entityManagerProvider, I18NBeanFactory i18NBeanFactory, BandanaManager bandanaManager) {
        this.transactionalExecutorFactory = transactionalExecutorFactory;
        this.entityManagerProvider = entityManagerProvider;
        this.i18NBeanFactory = i18NBeanFactory;
        this.bandanaManager = bandanaManager;
    }

    public String getName() {
        return this.getText("awp.space.migrateReadConfirmation.title");
    }

    protected void runInternal() {
        ReadConfirmationMigrationTableCheck.MigrationState state = new ReadConfirmationMigrationTableCheck.MigrationState(ReadConfirmationMigrationTableCheck.MigrationState.STATUS.PENDING);
        try {
            state = this.migrateReadConfirmationRecords();
            this.progress.setCompletedSuccessfully(true);
            this.progress.setStatus(this.getText("awp.space.readConfirmationMigration.completed.successful"));
        }
        catch (RuntimeException e) {
            this.progress.setStatus(this.getText("awp.space.readConfirmationMigration.completed.error") + e.getMessage());
            this.progress.setCompletedSuccessfully(false);
            log.error("Read Confirmation Long running task failed: ", e.getCause());
            state.setError(e.getMessage());
        }
        finally {
            this.progress.setPercentage(100);
            this.bandanaManager.setValue((BandanaContext)ComalatechBandanaContext.COMALATECH_CONTEXT, "com.comalatech.workflows.readConfirmation.migration", (Object)state);
        }
    }

    protected ReadConfirmationMigrationTableCheck.MigrationState migrateReadConfirmationRecords() throws RuntimeException {
        ReadConfirmationMigrationTableCheck.MigrationState state = new ReadConfirmationMigrationTableCheck.MigrationState(ReadConfirmationMigrationTableCheck.MigrationState.STATUS.PENDING);
        state.setUpdateTimestamp(System.currentTimeMillis());
        String databaseProductName = DataBaseNameUtil.getDatabaseName(this.entityManagerProvider);
        return (ReadConfirmationMigrationTableCheck.MigrationState)this.transactionalExecutorFactory.create().execute(connection -> {
            try {
                List<BaseReadAckRecord> oldRecords = this.fetchReadConfirmationRecordsFromDeprecatedTable(connection, databaseProductName);
                if (!oldRecords.isEmpty()) {
                    state.setNumRecords(oldRecords.size());
                    this.removeDeprecatedReadConfirmationRecords(connection, databaseProductName);
                    this.insertOldRecordInNewTable(oldRecords, connection, databaseProductName);
                }
                state.setStatus(ReadConfirmationMigrationTableCheck.MigrationState.STATUS.MIGRATED);
            }
            catch (SQLException e) {
                log.warn("Error migrating data deprecated read confirmation record, Rolling back changes,ERROR CODE: {},{}", (Object)e.getMessage(), (Object)e.getCause());
                throw new RuntimeException(e.getMessage(), e.getCause());
            }
            return state;
        });
    }

    protected List<BaseReadAckRecord> fetchReadConfirmationRecordsFromDeprecatedTable(Connection conn, String databaseProductName) throws SQLException {
        ArrayList<BaseReadAckRecord> oldRecords = new ArrayList<BaseReadAckRecord>();
        try (Statement ps = conn.createStatement();){
            String selectQuery = ReadConfirmationQueryMigrationStrings.selectFromOldTable(databaseProductName, s -> !s.contains("mysql"), ReadConfirmationQueryMigrationStrings::addQuotes);
            ResultSet rs = ps.executeQuery(selectQuery);
            while (rs.next()) {
                ReadAckRecordImpl record = new ReadAckRecordImpl(rs.getString("USER_KEY"), rs.getLong("PAGE_ID"), null, rs.getInt("PAGE_STATE_ID"), ReadAckStatusType.UserStatusType.fromString(rs.getString("STATUS").toLowerCase()), this.changeZeroForNull(rs.getLong("DUE_DATE_TIMESTAMP")), this.changeZeroForNull(rs.getLong("CREATION_TIMESTAMP")), BaseReadAckRecord.ReadAckAssignmentType.PARAMETER);
                record.setAcknowledgedTimestamp(this.changeZeroForNull(rs.getLong("ACKNOWLEDGED_TIMESTAMP")));
                record.setClosedTimestamp(this.changeZeroForNull(rs.getLong("CLOSED_TIMESTAMP")));
                oldRecords.add(record);
            }
        }
        catch (SQLException e) {
            log.error("Error reading old Ack Records from AO_26C053_CW_READ_ACK_RECORD. ERROR CODE: {},{}", (Object)e.getErrorCode(), (Object)e.getCause());
            throw e;
        }
        return oldRecords;
    }

    protected void removeDeprecatedReadConfirmationRecords(Connection conn, String databaseProductName) throws SQLException {
        try (Statement ps = conn.createStatement();){
            String deleteQuery = ReadConfirmationQueryMigrationStrings.deleteOldTable(databaseProductName, s -> !s.contains("mysql"), ReadConfirmationQueryMigrationStrings::addQuotes);
            ps.executeUpdate(deleteQuery);
        }
        catch (SQLException e) {
            log.error("Error removing old Ack Records from AO_26C053_CW_READ_ACK_RECORD, ERROR CODE: {},{}", (Object)e.getErrorCode(), (Object)e.getCause());
            throw e;
        }
    }

    protected void insertOldRecordInNewTable(List<BaseReadAckRecord> data, Connection conn, String databaseProductName) throws SQLException {
        String insertNewRecordQuery = ReadConfirmationQueryMigrationStrings.insertNewRecordQuery(databaseProductName, s -> !s.contains("mysql"), ReadConfirmationQueryMigrationStrings::addQuotes);
        try (PreparedStatement ps = conn.prepareStatement(insertNewRecordQuery);){
            int count = 0;
            for (BaseReadAckRecord record : data) {
                this.setOrNull(1, record.getAcknowledgedTimestamp(), Long.class, ps);
                this.setOrNull(2, record.getAssignmentType(), String.class, ps);
                this.setOrNull(3, record.getClosedTimestamp(), Long.class, ps);
                this.setOrNull(4, record.getCreationTimestamp(), Long.class, ps);
                this.setOrNull(5, record.getDueDateTimestamp(), Long.class, ps);
                this.setOrNull(6, record.getPageId(), Long.class, ps);
                this.setOrNull(7, record.getPageStateId(), Integer.class, ps);
                this.setOrNull(8, record.getStatus().toString().toUpperCase(), String.class, ps);
                this.setOrNull(9, record.getUserKey(), String.class, ps);
                ps.addBatch();
                if (++count % 100 != 0 && count != data.size()) continue;
                ps.executeBatch();
            }
        }
        catch (SQLException ex) {
            log.error("Cannot save old records in the new table! {} , {}", (Object)ex.getErrorCode(), (Object)ex.getMessage());
            throw ex;
        }
    }

    private void setOrNull(int position, Object value, Class clazz, PreparedStatement pst) throws IllegalArgumentException, SQLException {
        int type;
        String className = clazz.getSimpleName();
        if (className.equalsIgnoreCase("String")) {
            type = 12;
        } else if (className.equalsIgnoreCase("Long")) {
            type = -5;
        } else if (className.equalsIgnoreCase("Integer")) {
            type = 4;
        } else {
            throw new IllegalArgumentException("Cannot find sql type for " + className);
        }
        if (value == null) {
            pst.setNull(position, type);
        } else {
            pst.setObject(position, value, type);
        }
    }

    private String getText(String key) {
        return this.getText(key, null);
    }

    private String getText(String key, Object[] list) {
        I18NBean i18NBean = this.i18NBeanFactory.getI18NBean();
        if (list != null) {
            return i18NBean.getText(key, list);
        }
        return i18NBean.getText(key);
    }

    private <T extends Number> T changeZeroForNull(T value) {
        if (value.intValue() == 0) {
            return null;
        }
        return value;
    }
}

