/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.states.model;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.user.User;
import com.comalatech.confluence.readack.model.ReadAck;
import com.comalatech.confluence.readack.model.ReadAckPage;
import com.comalatech.confluence.states.model.AssignableActivity;
import com.comalatech.confluence.states.model.Assignment;
import com.comalatech.confluence.states.model.DueDateRecord;
import com.comalatech.confluence.states.model.PageStateTimer;
import com.comalatech.confluence.states.model.State;
import com.comalatech.confluence.states.model.StateChangeReason;
import com.comalatech.confluence.states.model.Timer;
import com.comalatech.confluence.tasks.model.PageTask;
import com.comalatech.confluence.tasks.model.PageTasks;
import com.comalatech.confluence.tasks.model.Task;
import com.comalatech.confluence.workflow.ParameterResolver;
import com.comalatech.confluence.workflow.model.DueDateRecordAware;
import com.comalatech.workflow.model.Approval;
import com.comalatech.workflow.model.Rejection;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.codehaus.jackson.annotate.JsonIgnore;

public class PageState
extends AssignableActivity
implements com.comalatech.workflow.model.State,
DueDateRecordAware {
    private int id;
    private String state;
    private int version;
    private boolean approved;
    private List<AttachmentVersion> attachmentVersions;
    private List<PageStateTimer> timers = new ArrayList<PageStateTimer>();
    private PageStateTimer activeTimer;
    @JsonProperty(value="pageTasks")
    private PageTasks tasks = new PageTasks();
    private ReadAckPage readAckPage;
    private List<DueDateRecord> dueDateHistory;
    private StateChangeReason stateChangeReason;
    private String colour;
    private transient List<Approval> approvals;
    private transient List<Rejection> rejections;
    private transient AbstractPage page;
    private transient boolean published;
    private transient boolean taskable;
    private transient boolean assignable;
    private transient boolean changeDueDate;
    private transient String stateDescription;
    private transient StateMode stateMode;
    private transient boolean versionsCompleted;

    public PageState() {
        this.attachmentVersions = new ArrayList<AttachmentVersion>();
        this.dueDateHistory = new ArrayList<DueDateRecord>();
    }

    private PageState(String state, String user) {
        super(user, new Date());
        this.state = state;
        this.attachmentVersions = new ArrayList<AttachmentVersion>();
        this.dueDateHistory = new ArrayList<DueDateRecord>();
    }

    public PageState(String state) {
        this(state, (String)null);
    }

    public PageState(String state, Date date, int version, String user, boolean approved) {
        this(state, user);
        this.setDate(date);
        this.version = version;
        this.approved = approved;
    }

    public PageState(ParameterResolver parameterResolver, UserAccessor userAccessor, AbstractPage page, State state, ReadAck readAck, ConfluenceUser user, boolean approved, AttachmentManager attachmentManager) {
        this(state.getName(), user != null ? user.getName() : null);
        if (!page.isLatestVersion()) {
            throw new RuntimeException("can only create a state on the latest version of " + page);
        }
        this.state = state.getName();
        this.colour = state.getColour();
        this.version = page.getVersion();
        this.approved = approved;
        List attachments = attachmentManager.getLatestVersionsOfAttachments((ContentEntityObject)page);
        this.attachmentVersions = new ArrayList<AttachmentVersion>(attachments.size());
        for (Attachment attachment : attachments) {
            if (attachment == null) continue;
            this.attachmentVersions.add(new AttachmentVersion(attachment));
        }
        this.published = state.isFinalState();
        this.versionsCompleted = state.isVersionsCompleted();
        this.createTasks(userAccessor, page, parameterResolver, state);
        this.createTimers(parameterResolver, page, state);
        this.createReadAck(page, state, readAck);
        this.resolveStateDescription(parameterResolver, page, state);
    }

    private void resolveStateDescription(ParameterResolver parameterResolver, AbstractPage page, State state) {
        this.stateDescription = state.getDescription() != null && state.getDescription().contains("@") ? parameterResolver.getParameterValue(page, state.getDescription().replaceAll("@", "")) : state.getDescription();
    }

    private void createTimers(ParameterResolver parameterResolver, AbstractPage page, State state) {
        for (Timer timer : state.getTimers()) {
            PageStateTimer pageStateTimer = new PageStateTimer(timer.getName(), timer.getDueDate(parameterResolver, page));
            this.addTimer(pageStateTimer);
        }
    }

    private void createTasks(UserAccessor userAccessor, AbstractPage page, ParameterResolver parameterResolver, State state) {
        for (Task task : state.getTasks()) {
            if (task.getAssignee() != null) {
                List<ConfluenceUser> assignees = parameterResolver.getValueAsUsers(page, task.getAssignee());
                for (ConfluenceUser assignee : assignees) {
                    PageTask pageTask = new PageTask(this.getPerformer(), task, this.getDate());
                    if (!userAccessor.isDeactivated((User)assignee)) {
                        pageTask.assign(new Assignment(this.getPerformer(), this.getDate(), assignee.getName(), null, null, null));
                    }
                    this.tasks.add(pageTask);
                }
                continue;
            }
            this.tasks.add(new PageTask(this.getPerformer(), task, this.getDate()));
        }
    }

    private void createReadAck(AbstractPage page, State state, ReadAck readAck) {
        if (state.isFinalState() && readAck != null) {
            this.readAckPage = new ReadAckPage(page, this, readAck);
        }
    }

    public void addAttachment(long id, int version) {
        this.attachmentVersions.add(new AttachmentVersion(id, version));
    }

    public void addTimer(String name, Date dueDate) {
        this.addTimer(new PageStateTimer(name, dueDate));
    }

    private void removeTimer(String name) {
        this.timers = this.timers.stream().filter(timer -> !timer.getName().equals(name)).collect(Collectors.toList());
        if (this.activeTimer != null && this.activeTimer.getName().equals(name)) {
            this.activeTimer = null;
        }
    }

    @Override
    public String getName() {
        return this.state;
    }

    public void addTimer(PageStateTimer timer) {
        if (timer != null) {
            this.timers.add(timer);
            if (timer.isActive()) {
                this.activeTimer = timer;
            }
        }
    }

    public void replaceTimer(PageStateTimer timer) {
        boolean found = false;
        for (int i = 0; i < this.timers.size(); ++i) {
            if (!this.timers.get(i).getName().equals(timer.getName())) continue;
            this.timers.set(i, timer);
            found = true;
            break;
        }
        if (!found) {
            this.addTimer(timer);
        } else if (this.activeTimer != null && this.activeTimer.getName().equals(timer.getName())) {
            this.activeTimer = timer.isActive() ? timer : null;
        }
    }

    public List<PageStateTimer> getTimers() {
        return this.timers;
    }

    public PageStateTimer getTimer(String name) {
        if (this.activeTimer != null) {
            if (!this.activeTimer.isActive()) {
                this.activeTimer = null;
            } else if (this.activeTimer.getName().equals(name)) {
                return this.activeTimer;
            }
        }
        for (PageStateTimer timer : this.timers) {
            if (!timer.getName().equals(name)) continue;
            return timer;
        }
        return null;
    }

    public void fireTimer(Date date, String note) {
        if (this.activeTimer != null) {
            this.activeTimer.setFired(date);
            if (note != null) {
                this.activeTimer.setNote(note);
            }
        }
        this.activeTimer = null;
    }

    public boolean matchesState(AbstractPage page, PageState pageState) {
        if (!this.state.equals(pageState.getState())) {
            return false;
        }
        if (this.getLastAssignment() == null) {
            return pageState.getLastAssignment() == null;
        }
        return ((Assignment)this.getLastAssignment()).isSimilar((Assignment)pageState.getLastAssignment());
    }

    public List<String> getAllAssignees() {
        HashSet<String> all = new HashSet<String>();
        this.addAssignee(all, (Assignment)this.getLastAssignment());
        for (PageTask task : this.tasks.get()) {
            if (task.isCompleted()) continue;
            this.addAssignee(all, (Assignment)task.getLastAssignment());
        }
        return new ArrayList<String>(all);
    }

    private void addAssignee(Set<String> all, Assignment assignment) {
        if (assignment != null && assignment.getAssignee() != null) {
            all.add(assignment.getAssignee());
        }
    }

    public int getId() {
        return this.id;
    }

    @Override
    public String getActivityId() {
        return Long.toString(this.id);
    }

    @Override
    public int getContentVersion() {
        return this.getVersion();
    }

    @JsonIgnore
    public List<PageTask> getTasks() {
        return this.tasks.getActiveTasks();
    }

    public ReadAckPage getReadAckPage() {
        return this.readAckPage;
    }

    public List<PageTask> getAllTasks() {
        return this.tasks.get();
    }

    @JsonIgnore
    public String getAssignee() {
        com.comalatech.workflow.model.Assignment assignment = this.getLastAssignment();
        if (assignment != null) {
            return ((Assignment)assignment).getAssignee();
        }
        return null;
    }

    public void setId(int id) {
        this.id = id;
    }

    @Override
    @JsonIgnore
    public DueDateRecord getCurrentDueDate() {
        if (this.dueDateHistory != null && this.dueDateHistory.size() > 0) {
            return this.dueDateHistory.get(this.dueDateHistory.size() - 1);
        }
        return null;
    }

    @Override
    public void setDueDateHistory(List<DueDateRecord> dueDateHistory) {
        this.dueDateHistory = dueDateHistory;
    }

    @Override
    public List<DueDateRecord> getDueDateHistory() {
        return this.dueDateHistory;
    }

    @Override
    @JsonIgnore
    public void setCurrentDueDate(DueDateRecord dueDateRecord) {
        this.updateExpirationDate(dueDateRecord == null ? null : dueDateRecord.getDueDate(), dueDateRecord.getPerformer());
    }

    public void updateExpirationDate(Date expirationDate, String userName) {
        if (expirationDate != null) {
            PageStateTimer newTimerDate = new PageStateTimer(Timer.DUE_DATE_TIMERNAME, expirationDate);
            this.replaceTimer(newTimerDate);
        } else {
            this.removeTimer(Timer.DUE_DATE_TIMERNAME);
        }
        DueDateRecord dueDateRecord = new DueDateRecord(expirationDate, userName, new Date());
        this.addDueDateHistory(dueDateRecord);
    }

    @Override
    public PageState addDueDateHistory(DueDateRecord dueDateRecord) {
        if (dueDateRecord != null) {
            this.dueDateHistory.add(dueDateRecord);
        }
        return this;
    }

    @Override
    public Date getExpirationDate() {
        PageStateTimer expirationTimer = this.getTimer(Timer.DUE_DATE_TIMERNAME);
        if (expirationTimer != null) {
            return expirationTimer.getDueDate();
        }
        return null;
    }

    @Override
    @Deprecated
    public List<Approval> getApprovals() {
        return this.approvals;
    }

    @Override
    @Deprecated
    public List<Rejection> getRejections() {
        return this.rejections;
    }

    public boolean isSame(PageState state) {
        return state != null && state.getId() == this.id;
    }

    @JsonGetter(value="pageTasks")
    public PageTasks getPageTasks() {
        return this.tasks;
    }

    public void setPageTasks(PageTasks tasks) {
        this.tasks = tasks;
    }

    @Deprecated
    public void setApprovals(List<Approval> approvals) {
        this.approvals = approvals;
    }

    @Deprecated
    public void setRejections(List<Rejection> rejections) {
        this.rejections = rejections;
    }

    public boolean isApproved() {
        return this.approved;
    }

    public void setApproved(boolean approved) {
        this.approved = approved;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getFinalStatus() {
        if (this.isPublished()) {
            return "final";
        }
        return "notfinal";
    }

    public int getVersion() {
        return this.version;
    }

    public List<AttachmentVersion> getAttachmentVersions() {
        return this.attachmentVersions;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    @Override
    public boolean isPublished() {
        return this.published;
    }

    public void setPublished(boolean published) {
        this.published = published;
    }

    @Override
    public boolean isVersionsCompleted() {
        return this.versionsCompleted;
    }

    public void setVersionsCompleted(boolean versionsCompleted) {
        this.versionsCompleted = versionsCompleted;
    }

    @Override
    public boolean equals(Object o) {
        if (!this.equalsIgnoreChangeReason(o)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PageState pageState = (PageState)o;
        if (this.id != pageState.id) {
            return false;
        }
        return !(this.stateChangeReason != null ? !this.stateChangeReason.equals((Object)pageState.stateChangeReason) : pageState.stateChangeReason != null);
    }

    public boolean equalsIgnoreChangeReason(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equalsIgnoreDateAndComment(o)) {
            return false;
        }
        PageState pageState = (PageState)o;
        if (this.approved != pageState.approved) {
            return false;
        }
        if (this.version != pageState.version) {
            return false;
        }
        if (this.getAssignments() != null ? !this.getAssignments().equals(pageState.getAssignments()) : pageState.getAssignments() != null) {
            return false;
        }
        if (this.attachmentVersions != null ? !this.attachmentVersions.equals(pageState.attachmentVersions) : pageState.attachmentVersions != null) {
            return false;
        }
        if (this.state != null ? !this.state.equals(pageState.state) : pageState.state != null) {
            return false;
        }
        if (this.tasks != null ? !this.tasks.equals(pageState.tasks) : pageState.tasks != null) {
            return false;
        }
        if (this.activeTimer != null ? !this.activeTimer.equals(pageState.activeTimer) : pageState.activeTimer != null) {
            return false;
        }
        if (this.timers != null ? !this.timers.equals(pageState.timers) : pageState.timers != null) {
            return false;
        }
        return !(this.dueDateHistory != null ? !this.dueDateHistory.equals(pageState.dueDateHistory) : pageState.dueDateHistory != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.id;
        result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
        result = 31 * result + this.version;
        result = 31 * result + (this.approved ? 1 : 0);
        result = 31 * result + (this.attachmentVersions != null ? this.attachmentVersions.hashCode() : 0);
        result = 31 * result + (this.getAssignments() != null ? this.getAssignments().hashCode() : 0);
        result = 31 * result + (this.timers != null ? this.timers.hashCode() : 0);
        result = 31 * result + (this.tasks != null ? this.tasks.hashCode() : 0);
        result = 31 * result + (this.dueDateHistory != null ? this.dueDateHistory.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "PageState{id=" + this.id + ", state='" + this.state + '\'' + ", date=" + this.getDate() + ", version=" + this.version + ", user='" + this.getPerformer() + '\'' + ", attachmentVersions=" + this.attachmentVersions + ", assignment=" + this.getAssignments() + ", tasks=" + this.tasks + ", dueDateHistories= " + this.dueDateHistory + '}';
    }

    @Override
    public Map<String, String> getAttributes() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", this.state);
        map.put("id", Integer.toString(this.id));
        map.put("version", Integer.toString(this.version));
        map.put("approved", Boolean.toString(this.approved));
        return map;
    }

    @Override
    public String getActivityKey() {
        return "state";
    }

    public AbstractPage getPage() {
        return this.page;
    }

    public void setPage(AbstractPage page) {
        this.page = page;
    }

    @Override
    public boolean isTaskable() {
        return this.taskable;
    }

    public void setTaskable(boolean taskable) {
        this.taskable = taskable;
    }

    @Override
    public boolean isAssignable() {
        return this.assignable;
    }

    public void setAssignable(boolean assignable) {
        this.assignable = assignable;
    }

    @Override
    public String getDescription() {
        return this.stateDescription;
    }

    public void setDescription(String stateDescription) {
        this.stateDescription = stateDescription;
    }

    public StateMode getStateMode() {
        return this.stateMode;
    }

    public void setStateMode(StateMode stateMode) {
        this.stateMode = stateMode;
    }

    public boolean isChangeDueDate() {
        return this.changeDueDate;
    }

    public void setChangeDueDate(boolean changeDueDate) {
        this.changeDueDate = changeDueDate;
    }

    public StateChangeReason getStateChangeReason() {
        return this.stateChangeReason;
    }

    public void setStateChangeReason(StateChangeReason stateChangeReason) {
        this.stateChangeReason = stateChangeReason;
    }

    @Override
    public String getColour() {
        return this.colour;
    }

    public void setColour(String colour) {
        this.colour = colour;
    }

    public PageStateTimer getActiveTimer() {
        if (this.activeTimer != null && !this.activeTimer.isActive()) {
            this.activeTimer = null;
        }
        return this.activeTimer;
    }

    public void setReadAckPage(ReadAckPage readAckPage) {
        this.readAckPage = readAckPage;
    }

    public static enum StateMode {
        DEFAULT(""),
        NOT_FINAL("notfinal"),
        FINAL("final");

        private String name;

        private StateMode(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class AttachmentVersion
    implements com.comalatech.workflow.model.AttachmentVersion {
        long id;
        int version;

        public AttachmentVersion() {
        }

        public AttachmentVersion(long id, int version) {
            this.id = id;
            this.version = version;
        }

        public AttachmentVersion(Attachment attachment) {
            this.id = attachment.getId();
            this.version = attachment.getVersion();
        }

        public long getId() {
            return this.id;
        }

        @Override
        public String getAttachmentId() {
            return Long.toString(this.id);
        }

        @Override
        public int getVersion() {
            return this.version;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AttachmentVersion that = (AttachmentVersion)o;
            if (this.id != that.id) {
                return false;
            }
            return this.version == that.version;
        }

        public int hashCode() {
            int result = (int)(this.id ^ this.id >>> 32);
            result = 31 * result + this.version;
            return result;
        }

        public String toString() {
            return "AttachmentVersion{id=" + this.id + ", version=" + this.version + '}';
        }
    }
}

