/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.states;

import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.search.ConfluenceIndexer;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.ConfluenceUserImpl;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.comalatech.confluence.ipc.ValueAccessor;
import com.comalatech.confluence.readack.model.ReadAck;
import com.comalatech.confluence.readack.service.ReadAckConfigManager;
import com.comalatech.confluence.states.StateAccessor;
import com.comalatech.confluence.states.StateManager;
import com.comalatech.confluence.states.event.BlogPostAssignEvent;
import com.comalatech.confluence.states.event.BlogPostStateInitEvent;
import com.comalatech.confluence.states.event.BlogPostStateSelectEvent;
import com.comalatech.confluence.states.event.BlogPostStateTransitionEvent;
import com.comalatech.confluence.states.event.BlogPostStateTransitionOverrideEvent;
import com.comalatech.confluence.states.event.BlogPostTaskAssignEvent;
import com.comalatech.confluence.states.event.BlogPostTaskCreateEvent;
import com.comalatech.confluence.states.event.BlogPostTaskDeletedEvent;
import com.comalatech.confluence.states.event.BlogPostTaskDueDateCreatedEvent;
import com.comalatech.confluence.states.event.BlogPostUnassignEvent;
import com.comalatech.confluence.states.event.PageAssignEvent;
import com.comalatech.confluence.states.event.PageStateInitEvent;
import com.comalatech.confluence.states.event.PageStateSelectEvent;
import com.comalatech.confluence.states.event.PageStateTransitionEvent;
import com.comalatech.confluence.states.event.PageStateTransitionOverrideEvent;
import com.comalatech.confluence.states.event.PageTaskAssignEvent;
import com.comalatech.confluence.states.event.PageTaskCreateEvent;
import com.comalatech.confluence.states.event.PageTaskDeletedEvent;
import com.comalatech.confluence.states.event.PageTaskDueDateCreatedEvent;
import com.comalatech.confluence.states.event.PageUnassignEvent;
import com.comalatech.confluence.states.event.StateExpiryUpdatedEvent;
import com.comalatech.confluence.states.event.TasksClearedEvent;
import com.comalatech.confluence.states.model.Assignment;
import com.comalatech.confluence.states.model.DueDateRecord;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.states.model.PageStateTimer;
import com.comalatech.confluence.states.model.State;
import com.comalatech.confluence.states.model.StateChangeReason;
import com.comalatech.confluence.states.model.TaskCompletion;
import com.comalatech.confluence.states.model.Timer;
import com.comalatech.confluence.tasks.PageTaskManager;
import com.comalatech.confluence.tasks.model.PageTask;
import com.comalatech.confluence.tasks.model.StateTasksMode;
import com.comalatech.confluence.workflow.InternalWorkflowParameterManager;
import com.comalatech.confluence.workflow.PageWorkflows;
import com.comalatech.confluence.workflow.ParameterResolver;
import com.comalatech.confluence.workflow.ValueStore;
import com.comalatech.confluence.workflow.WorkflowAccessor;
import com.comalatech.confluence.workflow.WorkflowConfigurationManager;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.model.Approval;
import com.comalatech.confluence.workflow.user.WorkflowAuthenticatedUserThreadLocal;
import com.comalatech.confluence.workflow.user.WorkflowUserAccessor;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class DefaultStateManager
implements StateManager,
ApplicationContextAware,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(DefaultStateManager.class);
    private ApplicationContext applicationContext;
    private final EventPublisher eventPublisher;
    private final ConfluenceIndexer indexer;
    private final ValueAccessor workflowValueAccessor;
    private final WorkflowConfigurationManager workflowConfigurationManager;
    private final ParameterResolver parameterResolver;
    private final UserAccessor userAccessor;
    private final DarkFeatureManager darkFeatureManager;
    private PageTaskManager pageTaskManager;
    private StateAccessor stateAccessor;
    private InternalWorkflowParameterManager workflowParameterManager;
    private ReadAckConfigManager readAckConfigManager;
    private AttachmentManager attachmentManager;
    private WorkflowUserAccessor workflowUserAccessor;
    private WorkflowAccessor workflowAccessor;
    private static final String METADATA_STATE_NAME = "awpState";

    public DefaultStateManager(EventPublisher eventPublisher, ConfluenceIndexer indexer, ValueAccessor workflowValueAccessor, WorkflowConfigurationManager workflowConfigurationManager, ParameterResolver parameterResolver, UserAccessor userAccessor, AttachmentManager attachmentManager, DarkFeatureManager darkFeatureManager, WorkflowUserAccessor workflowUserAccessor, WorkflowAccessor workflowAccessor) {
        this.eventPublisher = eventPublisher;
        this.indexer = indexer;
        this.workflowValueAccessor = workflowValueAccessor;
        this.workflowConfigurationManager = workflowConfigurationManager;
        this.parameterResolver = parameterResolver;
        this.userAccessor = userAccessor;
        this.attachmentManager = attachmentManager;
        this.darkFeatureManager = darkFeatureManager;
        this.workflowUserAccessor = workflowUserAccessor;
        this.workflowAccessor = workflowAccessor;
    }

    public void afterPropertiesSet() throws Exception {
        this.stateAccessor = (StateAccessor)this.applicationContext.getBean("stateAccessor", StateAccessor.class);
        this.pageTaskManager = (PageTaskManager)this.applicationContext.getBean("pageTaskManager", PageTaskManager.class);
        this.workflowParameterManager = (InternalWorkflowParameterManager)this.applicationContext.getBean("workflowParameterManager", InternalWorkflowParameterManager.class);
        this.readAckConfigManager = (ReadAckConfigManager)this.applicationContext.getBean("readAckConfigManager", ReadAckConfigManager.class);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public PageState setState(ValueStore valueStore, State state, boolean approved, ConfluenceUser user, String comment, Assignment assignment, ReadAck readAck) {
        return this.setState(valueStore, state, approved, user, comment, assignment, readAck, null);
    }

    @Override
    public PageState setState(ValueStore valueStore, State state, boolean approved, ConfluenceUser user, String comment, Assignment assignment, ReadAck readAck, StateChangeReason reason) {
        Timer stateTimerDueDate;
        AbstractPage page = valueStore.getPage();
        PageState newState = new PageState(this.workflowParameterManager, this.userAccessor, page, state, readAck, user, approved, this.attachmentManager);
        newState.setStateChangeReason(reason);
        newState.setComment(comment);
        if (assignment != null) {
            assignment.setUserName(newState.getPerformer());
            assignment.setDate(newState.getDate());
            assignment.setComment(comment);
            newState.assign(assignment);
        }
        if ((stateTimerDueDate = state.getDueDateTimer()) != null) {
            Date expiryDate = stateTimerDueDate.getDueDate(this.parameterResolver, page);
            Date newDatePlusOneSecond = new Date(new Date().getTime() + 1000L);
            DueDateRecord dueDateRecord = new DueDateRecord(expiryDate, WorkflowAuthenticatedUserThreadLocal.getUsername(), newDatePlusOneSecond);
            newState.addDueDateHistory(dueDateRecord);
        }
        this.workflowValueAccessor.setValue(page, METADATA_STATE_NAME, newState.getName());
        boolean rollOverTasks = this.workflowConfigurationManager.getStateTasksMode(page.getSpaceKey(), true) == StateTasksMode.MOVE;
        PageState oldState = this.stateAccessor.changeState(page, newState, rollOverTasks);
        valueStore.setPageState(newState);
        if (this.readAckConfigManager != null && newState != null && newState.getReadAckPage() != null) {
            this.readAckConfigManager.setupReadAckConfig(newState.getReadAckPage());
        }
        this.indexer.reIndex((Searchable)page);
        this.publishEvents(page, assignment, newState, oldState, rollOverTasks);
        return newState;
    }

    @Override
    public PageState setExpiryDate(AbstractPage page, Date expiryDate) {
        PageState newPageState = this.stateAccessor.changeExpiryDate(page, expiryDate);
        this.indexer.reIndex((Searchable)page);
        this.eventPublisher.publish((Object)new StateExpiryUpdatedEvent(this, page, newPageState));
        return newPageState;
    }

    protected void publishPageStateChangeReasonEvents(Page page, PageState oldState, PageState newState) {
        if (newState.getStateChangeReason().name().equalsIgnoreCase("ADMIN_OVERRIDE")) {
            this.eventPublisher.publish((Object)new PageStateTransitionOverrideEvent(this, page, oldState, newState, StateChangeReason.ADMIN_OVERRIDE));
        } else {
            this.eventPublisher.publish((Object)new PageStateInitEvent(this, page, oldState, newState, StateChangeReason.SPACE_INITIALISE));
        }
    }

    protected void publishBlogPostStateChangeReasonEvents(BlogPost page, PageState oldState, PageState newState) {
        if (newState.getStateChangeReason().name().equalsIgnoreCase("ADMIN_OVERRIDE")) {
            this.eventPublisher.publish((Object)new BlogPostStateTransitionOverrideEvent(this, page, oldState, newState, StateChangeReason.ADMIN_OVERRIDE));
        } else {
            this.eventPublisher.publish((Object)new BlogPostStateInitEvent(this, page, oldState, newState, StateChangeReason.SPACE_INITIALISE));
        }
    }

    private void publishStateChangeReasonEvents(AbstractPage page, PageState oldState, PageState newState) {
        if (page instanceof Page) {
            this.publishPageStateChangeReasonEvents((Page)page, oldState, newState);
        } else {
            this.publishBlogPostStateChangeReasonEvents((BlogPost)page, oldState, newState);
        }
    }

    private void publishTransitionEvent(AbstractPage page, PageState oldState, PageState newState) {
        if (page instanceof Page) {
            this.eventPublisher.publish((Object)new PageStateTransitionEvent(this, (Page)page, oldState, newState));
        } else {
            this.eventPublisher.publish((Object)new BlogPostStateTransitionEvent(this, (BlogPost)page, oldState, newState));
        }
        if (newState.getDueDateHistory().size() > 0) {
            this.eventPublisher.publish((Object)new StateExpiryUpdatedEvent(this, page, newState));
        }
    }

    private void publishAssignEvent(AbstractPage page, Assignment assignment, PageState newState, PageState oldState) {
        com.comalatech.workflow.model.Assignment previousAssignment;
        if (assignment != null) {
            if (page instanceof Page) {
                this.eventPublisher.publish((Object)new PageAssignEvent(this, (Page)page, newState, assignment));
            } else {
                this.eventPublisher.publish((Object)new BlogPostAssignEvent(this, (BlogPost)page, newState, assignment));
            }
        } else if (assignment == null && this.sameStateName(newState, oldState) && oldState.getAssignments() != null && (previousAssignment = oldState.getLastAssignment()) != null) {
            if (page instanceof Page) {
                this.eventPublisher.publish((Object)new PageUnassignEvent(this, (Page)page, newState, previousAssignment));
            } else {
                this.eventPublisher.publish((Object)new BlogPostUnassignEvent(this, (BlogPost)page, newState, previousAssignment));
            }
        }
    }

    private void publishEvents(AbstractPage page, Assignment assignment, PageState newState, PageState oldState, boolean eventsRolledOver) {
        if (oldState == null || !oldState.equals(newState)) {
            if (newState.getStateChangeReason() != null && (newState.getStateChangeReason().name().equalsIgnoreCase("ADMIN_OVERRIDE") || newState.getStateChangeReason().name().equalsIgnoreCase("SPACE_INITIALISE"))) {
                this.publishStateChangeReasonEvents(page, oldState, newState);
            } else if (!this.sameStateName(newState, oldState)) {
                this.publishTransitionEvent(page, oldState, newState);
            }
            this.publishAssignEvent(page, assignment, newState, oldState);
            if (this.tasksHasBeenClearedOnStateChange(newState, oldState)) {
                this.eventPublisher.publish((Object)new TasksClearedEvent(page));
            }
            if (!eventsRolledOver && oldState != null && this.darkFeatureManager.isFeatureEnabledForAllUsers("comalatech.workflows.newactivity.listener.enabled")) {
                for (PageTask oldTask : oldState.getTasks()) {
                    try {
                        this.pageTaskManager.completeTask(page, (ConfluenceUser)new ConfluenceUserImpl(this.workflowUserAccessor.getAddonUser().getName(), this.workflowUserAccessor.getAddonUser().getFullName(), "support@comalatech.com"), oldState, oldTask, new TaskCompletion(this.workflowUserAccessor.getAddonUser().getName(), new Date(), null, ConfluenceActionSupport.getTextStatic((String)"com.comalatech.activity.report.task.completed.default")));
                    }
                    catch (WorkflowException e) {
                        log.error("Error completing the task when task is closed in transition: " + e.getMessage());
                    }
                }
            }
            for (PageTask newTask : newState.getTasks()) {
                if (eventsRolledOver && oldState != null && this.taskIsInList(oldState.getTasks(), newTask)) continue;
                this.publishTaskCreatedEvent(page, newTask, newState);
            }
        }
    }

    private boolean tasksHasBeenClearedOnStateChange(PageState newState, PageState oldState) {
        return oldState != null && !oldState.getPageTasks().getActiveTasks().isEmpty() && newState.getPageTasks().getActiveTasks().isEmpty();
    }

    private boolean taskIsInList(List<PageTask> taskList, PageTask taskToCheck) {
        for (PageTask listTask : taskList) {
            if (!this.taskNameAndAssignmentMatch(listTask, taskToCheck)) continue;
            return true;
        }
        return false;
    }

    private boolean taskNameAndAssignmentMatch(PageTask pageTask1, PageTask pageTask2) {
        String assignee1 = pageTask1.getAssignee() != null ? pageTask1.getAssignee() : "";
        String assignee2 = pageTask2.getAssignee() != null ? pageTask2.getAssignee() : "";
        return assignee1.equals(assignee2) && pageTask1.getName().equals(pageTask2.getName());
    }

    private void publishTaskCreatedEvent(AbstractPage page, PageTask task, PageState state) {
        if (page instanceof Page) {
            this.eventPublisher.publish((Object)new PageTaskCreateEvent(this, (Page)page, state, task));
            if (task.getDueDate() != null) {
                this.eventPublisher.publish((Object)new PageTaskDueDateCreatedEvent(this, (Page)page, state, task, null));
            }
        } else {
            this.eventPublisher.publish((Object)new BlogPostTaskCreateEvent(this, (BlogPost)page, state, task));
            if (task.getDueDate() != null) {
                this.eventPublisher.publish((Object)new BlogPostTaskDueDateCreatedEvent(this, (BlogPost)page, state, task, null));
            }
        }
        if (task.getCurrentAssignment() != null) {
            this.publishTaskAssignment(page, state, task, task.getCurrentAssignment());
        }
    }

    private void publishTaskAssignment(AbstractPage page, PageState state, PageTask task, Assignment assignment) {
        if (page instanceof Page) {
            this.eventPublisher.publish((Object)new PageTaskAssignEvent((Object)this, (Page)page, state, task, assignment, true));
        } else {
            this.eventPublisher.publish((Object)new BlogPostTaskAssignEvent((Object)this, (BlogPost)page, state, task, assignment, true));
        }
    }

    private boolean sameStateName(PageState newState, PageState oldState) {
        return oldState != null && newState.getState().equals(oldState.getName());
    }

    @Override
    public void selectState(AbstractPage page, State state, String comment, Assignment assignment) {
        if (page instanceof Page) {
            this.eventPublisher.publish((Object)new PageStateSelectEvent(this, (Page)page, state, comment, assignment));
        } else {
            this.eventPublisher.publish((Object)new BlogPostStateSelectEvent(this, (BlogPost)page, state, comment, assignment));
        }
    }

    @Override
    public Approval getOrCreatePreceedingApproval(State state) {
        for (State preceedingState : state.getPreceedingStates()) {
            if (!state.equals(preceedingState.getApprovedState()) || preceedingState.getApprovals().size() != 1) continue;
            return preceedingState.getApprovals().get(0);
        }
        return new Approval(ConfluenceActionSupport.getTextStatic((String)"com.comalatech.workflow.state.init.dummyapprovalname", (Object[])new String[]{state.getName()}), true, Collections.emptyList());
    }

    @Override
    public void updateTask(AbstractPage page, PageTask task) {
        this.stateAccessor.updateTask(page, task);
        this.indexer.reIndex((Searchable)page);
    }

    @Override
    public void removeTask(AbstractPage page, PageTask task, String deletionComment) {
        PageTask updatedTask = this.stateAccessor.removeTask(page, task, deletionComment);
        if (updatedTask != null) {
            this.indexer.reIndex((Searchable)page);
            PageState stateForTask = this.stateAccessor.getLatestState(page);
            PageWorkflows pageWorkflows = this.workflowAccessor.getPageWorkflows(page);
            if (pageWorkflows != null) {
                stateForTask = pageWorkflows.getEnrichedPageState(stateForTask);
            }
            this.publishTaskDeletion(page, stateForTask, updatedTask);
        }
    }

    private void publishTaskDeletion(AbstractPage page, PageState state, PageTask task) {
        if (page instanceof Page) {
            this.eventPublisher.publish((Object)new PageTaskDeletedEvent(this, (Page)page, state, task));
        } else {
            this.eventPublisher.publish((Object)new BlogPostTaskDeletedEvent(this, (BlogPost)page, state, task));
        }
    }

    @Override
    public void updateTimer(AbstractPage page, PageStateTimer timer) {
        this.stateAccessor.updateTimer(page, timer);
    }

    @Override
    public void addTask(AbstractPage page, PageTask task) {
        this.stateAccessor.addTask(page, task);
        this.indexer.reIndex((Searchable)page);
        PageState stateForTask = this.stateAccessor.getLatestState(page);
        PageWorkflows pageWorkflows = this.workflowAccessor.getPageWorkflows(page);
        if (pageWorkflows != null) {
            stateForTask = pageWorkflows.getEnrichedPageState(stateForTask);
        }
        this.publishTaskCreatedEvent(page, task, stateForTask);
    }
}

