/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.rest.model;

import com.comalatech.confluence.documentActivity.service.model.DocumentActivityQuery;
import com.comalatech.confluence.documentActivity.service.model.DocumentActivityQueryFilter;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;

@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class DocumentActivityRequest {
    private Long nextActivityTimestamp;
    private DocumentActivityQuery.SortingOrder sorting;
    private DocumentActivityQueryFilter filters;

    public DocumentActivityQuery toQuery() {
        DocumentActivityQuery query = new DocumentActivityQuery();
        query.setLimit(100);
        query.setFilters(this.filters);
        query.setSorting(this.sorting != null ? this.sorting : DocumentActivityQuery.SortingOrder.desc);
        query.setNextActivityTimestamp(this.nextActivityTimestamp);
        return query;
    }

    public static DocumentActivityRequestBuilder builder() {
        return new DocumentActivityRequestBuilder();
    }

    public Long getNextActivityTimestamp() {
        return this.nextActivityTimestamp;
    }

    public DocumentActivityQuery.SortingOrder getSorting() {
        return this.sorting;
    }

    public DocumentActivityQueryFilter getFilters() {
        return this.filters;
    }

    public void setNextActivityTimestamp(Long nextActivityTimestamp) {
        this.nextActivityTimestamp = nextActivityTimestamp;
    }

    public void setSorting(DocumentActivityQuery.SortingOrder sorting) {
        this.sorting = sorting;
    }

    public void setFilters(DocumentActivityQueryFilter filters) {
        this.filters = filters;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DocumentActivityRequest)) {
            return false;
        }
        DocumentActivityRequest other = (DocumentActivityRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$nextActivityTimestamp = this.getNextActivityTimestamp();
        Long other$nextActivityTimestamp = other.getNextActivityTimestamp();
        if (this$nextActivityTimestamp == null ? other$nextActivityTimestamp != null : !((Object)this$nextActivityTimestamp).equals(other$nextActivityTimestamp)) {
            return false;
        }
        DocumentActivityQuery.SortingOrder this$sorting = this.getSorting();
        DocumentActivityQuery.SortingOrder other$sorting = other.getSorting();
        if (this$sorting == null ? other$sorting != null : !((Object)((Object)this$sorting)).equals((Object)other$sorting)) {
            return false;
        }
        DocumentActivityQueryFilter this$filters = this.getFilters();
        DocumentActivityQueryFilter other$filters = other.getFilters();
        return !(this$filters == null ? other$filters != null : !((Object)this$filters).equals(other$filters));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DocumentActivityRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $nextActivityTimestamp = this.getNextActivityTimestamp();
        result = result * 59 + ($nextActivityTimestamp == null ? 43 : ((Object)$nextActivityTimestamp).hashCode());
        DocumentActivityQuery.SortingOrder $sorting = this.getSorting();
        result = result * 59 + ($sorting == null ? 43 : ((Object)((Object)$sorting)).hashCode());
        DocumentActivityQueryFilter $filters = this.getFilters();
        result = result * 59 + ($filters == null ? 43 : ((Object)$filters).hashCode());
        return result;
    }

    public String toString() {
        return "DocumentActivityRequest(nextActivityTimestamp=" + this.getNextActivityTimestamp() + ", sorting=" + (Object)((Object)this.getSorting()) + ", filters=" + this.getFilters() + ")";
    }

    public DocumentActivityRequest() {
    }

    public DocumentActivityRequest(Long nextActivityTimestamp, DocumentActivityQuery.SortingOrder sorting, DocumentActivityQueryFilter filters) {
        this.nextActivityTimestamp = nextActivityTimestamp;
        this.sorting = sorting;
        this.filters = filters;
    }

    public static class DocumentActivityRequestBuilder {
        private Long nextActivityTimestamp;
        private DocumentActivityQuery.SortingOrder sorting;
        private DocumentActivityQueryFilter filters;

        DocumentActivityRequestBuilder() {
        }

        public DocumentActivityRequestBuilder nextActivityTimestamp(Long nextActivityTimestamp) {
            this.nextActivityTimestamp = nextActivityTimestamp;
            return this;
        }

        public DocumentActivityRequestBuilder sorting(DocumentActivityQuery.SortingOrder sorting) {
            this.sorting = sorting;
            return this;
        }

        public DocumentActivityRequestBuilder filters(DocumentActivityQueryFilter filters) {
            this.filters = filters;
            return this;
        }

        public DocumentActivityRequest build() {
            return new DocumentActivityRequest(this.nextActivityTimestamp, this.sorting, this.filters);
        }

        public String toString() {
            return "DocumentActivityRequest.DocumentActivityRequestBuilder(nextActivityTimestamp=" + this.nextActivityTimestamp + ", sorting=" + (Object)((Object)this.sorting) + ", filters=" + this.filters + ")";
        }
    }
}

