/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.confluence.filtering.criteria.general;

import java.util.Date;
import org.randombits.confluence.filtering.criteria.general.GeneralCriterion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateCriterion
extends GeneralCriterion<Date> {
    private Date minValue;
    private Date maxValue;
    private Date afterValue;
    private Date beforeValue;
    private Date value;

    public DateCriterion() {
        super(Date.class);
    }

    public DateCriterion(Date minValue, Date maxValue) {
        this();
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    @Override
    protected boolean matchesType(Date date) {
        if (date == null) {
            return true;
        }
        if (this.minValue != null && this.minValue.after(date)) {
            return false;
        }
        if (this.maxValue != null && this.maxValue.before(date)) {
            return false;
        }
        if (this.afterValue != null && this.afterValue.compareTo(date) >= 0) {
            return false;
        }
        if (this.beforeValue != null && this.beforeValue.compareTo(date) <= 0) {
            return false;
        }
        return this.value == null || this.value.equals(date);
    }

    public Date getMinValue() {
        return this.minValue;
    }

    public void setMinValue(Date minValue) {
        this.minValue = minValue;
    }

    public Date getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(Date maxValue) {
        this.maxValue = maxValue;
    }

    public Date getAfterValue() {
        return this.afterValue;
    }

    public void setAfterValue(Date afterValue) {
        this.afterValue = afterValue;
    }

    public Date getBeforeValue() {
        return this.beforeValue;
    }

    public void setBeforeValue(Date beforeValue) {
        this.beforeValue = beforeValue;
    }

    public Date getValue() {
        return this.value;
    }

    public void setValue(Date value) {
        this.value = value;
    }

    public String toString() {
        return "{date" + (this.minValue != null ? "; min: " + this.minValue : "") + (this.maxValue != null ? "; max: " + this.maxValue : "") + (this.afterValue != null ? "; after: " + this.afterValue : "") + (this.beforeValue != null ? "; before: " + this.beforeValue : "") + (this.value != null ? "; value: " + this.value : "") + "}";
    }
}

