/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.confluence.filtering.criteria.content;

import com.atlassian.confluence.links.linktypes.AbstractContentEntityLink;
import com.atlassian.confluence.links.linktypes.AttachmentLink;
import com.atlassian.confluence.links.linktypes.PageCreateLink;
import com.atlassian.confluence.links.linktypes.ShortcutLink;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.renderer.links.Link;
import com.atlassian.renderer.links.UnpermittedLink;
import com.atlassian.renderer.links.UnresolvedLink;
import com.atlassian.renderer.links.UrlLink;
import com.atlassian.user.User;
import org.randombits.confluence.filtering.criteria.AutowiredCriterion;

public class ContentPermissionCriterion
extends AutowiredCriterion {
    private User user;
    private boolean hasPermission;
    private PermissionManager permissionManager;
    private Permission permission;
    private SpaceManager spaceManager;

    public ContentPermissionCriterion(User user, Permission permission, boolean hasPermission) {
        this.user = user;
        this.permission = permission;
        this.hasPermission = hasPermission;
    }

    public ContentPermissionCriterion(User user, Permission permission) {
        this(user, permission, true);
    }

    public boolean matches(Object object) {
        if (object instanceof Link) {
            if (object instanceof AbstractContentEntityLink) {
                if (object instanceof PageCreateLink) {
                    String spaceKey = ((PageCreateLink)object).getSpaceKey();
                    if (spaceKey != null) {
                        object = this.spaceManager.getSpace(spaceKey);
                    }
                } else {
                    object = ((AbstractContentEntityLink)object).getDestinationContent();
                }
            } else if (object instanceof AttachmentLink) {
                object = ((AttachmentLink)object).getAttachment();
            } else {
                if (object instanceof UnpermittedLink) {
                    return false;
                }
                return object instanceof UnresolvedLink || object instanceof ShortcutLink || object instanceof UrlLink;
            }
        }
        if (object != null) {
            return this.permissionManager.hasPermission(this.user, this.permission, object) == this.hasPermission;
        }
        return false;
    }

    public User getUser() {
        return this.user;
    }

    public boolean isHasPermission() {
        return this.hasPermission;
    }

    public Permission getPermission() {
        return this.permission;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    public String toString() {
        return "{content permission: " + this.permission + "; user: " + this.user + "; must have permission: " + this.hasPermission + "}";
    }
}

