/*
 * Decompiled with CFR 0.152.
 */
package net.customware.confluence.reporting.macro;

import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.SubRenderer;
import com.atlassian.renderer.v2.macro.MacroException;
import com.atlassian.spring.container.ContainerManager;
import net.customware.confluence.reporting.Executor;
import net.customware.confluence.reporting.ReportBuilder;
import net.customware.confluence.reporting.ReportException;
import net.customware.confluence.reporting.macro.AbstractReportingMacro;
import net.customware.confluence.reporting.query.Query;
import net.customware.confluence.reporting.query.QueryException;
import net.customware.confluence.reporting.query.Queryable;
import org.randombits.confluence.support.MacroInfo;

public abstract class AbstractReporterMacro<T>
extends AbstractReportingMacro {
    protected static final String MATCH_ALL_PARAM = "matchAll";
    private SubRenderer subRenderer;
    private Class<T> valueType;

    public AbstractReporterMacro(Class<T> valueType) {
        this.valueType = valueType;
    }

    @Override
    protected String report(final MacroInfo info) throws MacroException, ReportException {
        Query<T> query;
        Queryable<T> queryable = ReportBuilder.getQueryable(this.valueType);
        if (queryable == null) {
            throw new MacroException("This reporter cannot be used in this context.");
        }
        if (!queryable.canAddQuery()) {
            throw new MacroException("No further reporters can be specified in this context.");
        }
        try {
            query = this.createQuery(info);
        }
        catch (QueryException e) {
            throw new MacroException((Throwable)e);
        }
        ContainerManager.autowireComponent(query);
        String result = ReportBuilder.executeContext(query, new Executor<String>(){

            @Override
            public String execute() {
                String result = AbstractReporterMacro.this.subRenderer.render(info.getMacroBody(), (RenderContext)info.getPageContext(), RenderMode.ALL);
                if (result != null && result.trim().length() > 0) {
                    return result;
                }
                return null;
            }
        });
        if (result == null) {
            queryable.addQuery(query);
        }
        return result == null ? "" : result;
    }

    protected abstract Query<T> createQuery(MacroInfo var1) throws QueryException, ReportException;

    public final boolean isInline() {
        return false;
    }

    public boolean hasBody() {
        return true;
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.NO_RENDER;
    }

    public void setSubRenderer(SubRenderer subRenderer) {
        this.subRenderer = subRenderer;
    }
}

