/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.tasks.manager;

import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.comalatech.confluence.pdfexport.k15t.scrollpdfexporter.handler.PdfExportActionHandlerImpl;
import com.comalatech.confluence.pdfexport.k15t.scrollpdfexporter.model.PdfExportActionModel;
import com.comalatech.confluence.workflow.activeobjects.accessor.QueuedJobEntityAccessor;
import com.comalatech.confluence.workflow.activeobjects.entity.QueuedJobEntity;
import com.comalatech.confluence.workflow.tasks.handler.WorkflowActionHandlerImpl;
import com.comalatech.confluence.workflow.tasks.handler.WorkflowLabelledActionHandlerImpl;
import com.comalatech.confluence.workflow.tasks.manager.QueuedJobManager;
import com.comalatech.confluence.workflow.tasks.model.QueuedJobModel;
import com.comalatech.confluence.workflow.tasks.model.WorkflowActionModel;
import com.comalatech.confluence.workflow.tasks.model.WorkflowLabelledActionModel;
import java.io.IOException;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueuedJobManagerImpl
implements QueuedJobManager {
    private static final Logger log = LoggerFactory.getLogger(QueuedJobManagerImpl.class);
    private QueuedJobEntityAccessor queuedJobEntityAccessor;
    private TransactionTemplate transactionTemplate;
    private WorkflowActionHandlerImpl workflowActionHandler;
    private WorkflowLabelledActionHandlerImpl workflowLabelledActionHandler;
    private PdfExportActionHandlerImpl pdfExportActionHandler;

    public QueuedJobManagerImpl(QueuedJobEntityAccessor queuedJobEntityAccessor, TransactionTemplate transactionTemplate, WorkflowActionHandlerImpl workflowActionHandler, WorkflowLabelledActionHandlerImpl workflowLabelledActionHandler, PdfExportActionHandlerImpl pdfExportActionHandler) {
        this.queuedJobEntityAccessor = queuedJobEntityAccessor;
        this.transactionTemplate = transactionTemplate;
        this.workflowActionHandler = workflowActionHandler;
        this.workflowLabelledActionHandler = workflowLabelledActionHandler;
        this.pdfExportActionHandler = pdfExportActionHandler;
    }

    public QueuedJobEntity addToQueue(QueuedJobEntityAccessor.JobType jobType, QueuedJobModel model) {
        return (QueuedJobEntity)this.transactionTemplate.execute(() -> this.queuedJobEntityAccessor.add(jobType, model));
    }

    @Override
    public void executeQueuedJob(QueuedJobEntity entity) {
        try {
            switch (QueuedJobEntityAccessor.JobType.getJobType(entity.getJobType())) {
                case WORKFLOW_ACTION: {
                    QueuedJobModel model = this.jsonToModel(entity.getJobData(), WorkflowActionModel.class);
                    this.workflowActionHandler.execute((WorkflowActionModel)model);
                    break;
                }
                case WORKFLOW_LABELLED_ACTION: {
                    QueuedJobModel model = this.jsonToModel(entity.getJobData(), WorkflowLabelledActionModel.class);
                    this.workflowLabelledActionHandler.execute((WorkflowLabelledActionModel)model);
                    break;
                }
                case PDF_EXPORT_ACTION: {
                    QueuedJobModel model = this.jsonToModel(entity.getJobData(), PdfExportActionModel.class);
                    this.pdfExportActionHandler.execute((PdfExportActionModel)model);
                }
            }
        }
        catch (Throwable t) {
            log.error(t.getMessage(), t);
        }
    }

    private QueuedJobModel jsonToModel(String json, Class className) throws IOException {
        return (QueuedJobModel)new ObjectMapper().readValue(json, className);
    }
}

