/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.macros.actions.slack;

import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.macro.MacroException;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.RequestFactory;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import com.comalatech.confluence.workflow.macros.actions.AbstractMessageMacro;
import com.comalatech.confluence.workflow.macros.actions.slack.SlackUtils;
import com.comalatech.confluence.workflow.macros.actions.slack.model.SlackBlock;
import com.comalatech.confluence.workflow.macros.actions.slack.model.SlackContent;
import com.comalatech.confluence.workflow.macros.actions.slack.model.SlackPayload;
import java.io.IOException;
import java.util.Map;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

public class SlackChannelMessageMacro
extends AbstractMessageMacro {
    private static final Logger log = LoggerFactory.getLogger(SlackChannelMessageMacro.class);
    private final RequestFactory<?> requestFactory;
    private final DarkFeatureManager darkFeatureManager;
    public static final String MACRO_NAME = "slack-channel-message";
    public static final String PARAM_WEBHOOK = "webhook";

    public SlackChannelMessageMacro(@Qualifier(value="requestFactory") RequestFactory<?> requestFactory, DarkFeatureManager darkFeatureManager) {
        this.requestFactory = requestFactory;
        this.darkFeatureManager = darkFeatureManager;
    }

    @Override
    protected String getName() {
        return MACRO_NAME;
    }

    public String execute(Map parameters, String body, RenderContext renderContext) throws MacroException {
        if (!this.darkFeatureManager.isFeatureEnabledForAllUsers("comalatech.workflows.slack.macro.enabled")) {
            return "";
        }
        String webHook = (String)parameters.get(PARAM_WEBHOOK);
        if (!SlackUtils.validateWebHookUrl(webHook)) {
            throw new MacroException("WebHook url is not properly defined or formatted");
        }
        if (!this.inExecuteMode(renderContext)) {
            return "";
        }
        String wikiMessage = this.replaceReferences(renderContext, body);
        ObjectMapper objectMapper = new ObjectMapper();
        SlackContent content = new SlackContent(SlackContent.Types.MRKDWN, wikiMessage);
        SlackBlock block = new SlackBlock(SlackBlock.Types.SECTION, content);
        SlackPayload payload = new SlackPayload();
        payload.addBlock(block);
        String jsonPayload = "";
        try {
            jsonPayload = objectMapper.writeValueAsString((Object)payload);
        }
        catch (IOException e) {
            log.error("Error serializing object int json", (Throwable)e);
        }
        if (!this.doPost(jsonPayload, webHook)) {
            throw new MacroException("Failed to send the slack channel message");
        }
        return null;
    }

    private boolean doPost(String payload, String url) {
        try {
            Request request = this.requestFactory.createRequest(Request.MethodType.POST, url);
            request.setRequestBody(payload);
            return (Boolean)request.executeAndReturn(this::checkStatusCode);
        }
        catch (ResponseException e) {
            log.error("Error doing Post request to {}", (Object)url, (Object)e);
        }
        catch (Exception e) {
            log.error("error", (Throwable)e);
        }
        return false;
    }

    private boolean checkStatusCode(Response response) {
        if (response.getStatusCode() != 200) {
            log.error("Response of post to slack was {}", (Object)response.getStatusCode());
            return false;
        }
        return true;
    }
}

