/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.upgrade.readConfirmation.migration.status;

import com.atlassian.confluence.persistence.EntityManagerProvider;
import com.atlassian.fugue.Either;
import com.atlassian.sal.api.rdbms.TransactionalExecutorFactory;
import com.comalatech.confluence.upgrade.readConfirmation.migration.ReadConfirmationQueryMigrationStrings;
import com.comalatech.confluence.upgrade.readConfirmation.migration.status.ReadConfirmationMigrationStatusManager;
import com.comalatech.confluence.upgrade.readConfirmation.migration.status.ReadConfirmationMigrationTableCheck;
import com.comalatech.confluence.util.db.DataBaseNameUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.function.UnaryOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultReadConfirmationMigrationStatusManager
implements ReadConfirmationMigrationStatusManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultReadConfirmationMigrationStatusManager.class);
    private final TransactionalExecutorFactory transactionalExecutorFactory;
    private final EntityManagerProvider entityManagerProvider;

    public DefaultReadConfirmationMigrationStatusManager(TransactionalExecutorFactory transactionalExecutorFactory, EntityManagerProvider entityManagerProvider) {
        this.transactionalExecutorFactory = transactionalExecutorFactory;
        this.entityManagerProvider = entityManagerProvider;
    }

    @Override
    public Either<Integer, Exception> getNumberOfRecordToMigrate() {
        try {
            return Either.left((Object)this.countRecords());
        }
        catch (Exception e) {
            log.error("Could not count number of records to migrate, {}", (Object)e.getMessage());
            return Either.right((Object)e);
        }
    }

    @Override
    public Either<Boolean, Exception> isPreviousTableAvailable() {
        try {
            return Either.left((Object)this.searchTable());
        }
        catch (Exception e) {
            log.warn("Could not get table, {}", (Object)e.getMessage());
            return Either.right((Object)e);
        }
    }

    protected Integer countRecords() throws RuntimeException {
        String databaseProductName = DataBaseNameUtil.getDatabaseName(this.entityManagerProvider);
        Integer result = (Integer)this.transactionalExecutorFactory.create().execute(connection -> {
            try {
                return this.makeCount(connection, databaseProductName);
            }
            catch (Exception e) {
                log.warn("Error getting record for {} table,ERROR CODE: {},{}", new Object[]{"AO_26C053_CW_READ_ACK_RECORD", e.getMessage(), e.getCause()});
                throw new RuntimeException(e.getMessage(), e.getCause());
            }
        });
        return result;
    }

    protected Boolean searchTable() throws RuntimeException {
        String databaseProductName = DataBaseNameUtil.getDatabaseName(this.entityManagerProvider);
        String result = (String)this.transactionalExecutorFactory.create().execute(connection -> {
            try {
                return this.makeSearch(connection, databaseProductName);
            }
            catch (Exception e) {
                log.warn("Error getting record for {} table,ERROR CODE: {},{}", new Object[]{"AO_26C053_CW_READ_ACK_RECORD", e.getMessage(), e.getCause()});
                throw new RuntimeException(e.getMessage(), e.getCause());
            }
        });
        return result != null && result.contains("AO_26C053_CW_READ_ACK_RECORD");
    }

    private Integer makeCount(Connection conn, String databaseProductName) throws SQLException {
        Integer result = null;
        try (Statement ps = conn.createStatement();){
            String selectQuery = ReadConfirmationMigrationTableCheck.countNumberOfRecordsFromOldTable(databaseProductName, s -> !s.contains("mysql"), ReadConfirmationQueryMigrationStrings::addQuotes);
            ResultSet rs = ps.executeQuery(selectQuery);
            while (rs.next()) {
                result = rs.getInt("COUNT");
            }
        }
        catch (SQLException e) {
            log.error("Error reading old Ack Records from AO_26C053_CW_READ_ACK_RECORD. ERROR CODE: {},{}", (Object)e.getErrorCode(), (Object)e.getCause());
            throw e;
        }
        return result;
    }

    private String makeSearch(Connection conn, String databaseProductName) throws SQLException {
        String result = null;
        try (Statement ps = conn.createStatement();){
            String selectQuery = ReadConfirmationMigrationTableCheck.searchPreviousTableInInformationSchema(databaseProductName, s -> !s.isEmpty(), UnaryOperator.identity());
            ResultSet rs = ps.executeQuery(selectQuery);
            while (rs.next()) {
                result = rs.getString("TABLE_NAME");
            }
        }
        catch (SQLException e) {
            log.error("Error reading old Ack Records from AO_26C053_CW_READ_ACK_RECORD. ERROR CODE: {},{}", (Object)e.getErrorCode(), (Object)e.getCause());
            throw e;
        }
        return result;
    }
}

