/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.states.model;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.comalatech.confluence.states.StateException;
import com.comalatech.confluence.states.model.Assignment;
import com.comalatech.confluence.states.model.State;
import com.comalatech.confluence.states.model.StatesContainer;
import com.comalatech.confluence.states.model.Timer;
import com.comalatech.confluence.util.MiscUtils;
import com.comalatech.confluence.workflow.ValueStore;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.model.Condition;
import com.comalatech.confluence.workflow.model.GroupCondition;
import com.comalatech.confluence.workflow.model.UserCondition;
import com.comalatech.confluence.workflow.model.WorkflowElement;
import com.comalatech.confluence.workflowcontainer.model.Macroable;
import com.comalatech.confluence.workflowcontainer.model.SerializableMacro;
import com.comalatech.workflow.model.SelectionAction;
import com.opensymphony.util.TextUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.joda.time.DateTime;

public class StateSelection
extends WorkflowElement
implements Serializable,
Macroable,
SelectionAction {
    private static final long serialVersionUID = 8920908984369092743L;
    private List<State> allowedStates;
    private String[] allowedStatesNames;
    public boolean adhoc;
    public boolean selectDueDate;
    private boolean pageAssignable;

    public StateSelection(List conditions, String[] allowedStatesNames) {
        super(conditions);
        this.allowedStatesNames = allowedStatesNames;
    }

    public StateSelection(List<State> allowedStates, boolean adhoc) {
        super(null);
        this.allowedStates = allowedStates;
        this.adhoc = adhoc;
    }

    public String getSelectionInformation() {
        StringBuffer options = new StringBuffer();
        int count = 1;
        for (State allowedState : this.allowedStates) {
            if (count == this.allowedStates.size()) {
                if (this.allowedStates.size() > 1) {
                    options.append(' ').append(ConfluenceActionSupport.getTextStatic((String)"approvalsworkflow.spaceapprovals.condition.or")).append(' ');
                }
            } else if (count > 1) {
                options.append(", ");
            }
            options.append(allowedState.getName());
            ++count;
        }
        return ConfluenceActionSupport.getTextStatic((String)"approvalsworkflow.selection.hover.options", (Object[])new String[]{options.toString()});
    }

    public boolean isValidSelection(String stateName) {
        for (State allowedState : this.allowedStates) {
            if (!allowedState.getName().equals(stateName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean evaluate(ValueStore valueStore) throws WorkflowException {
        boolean ok = false;
        if (valueStore.getPageState() != null && valueStore.getPageState().getLastAssignment() != null) {
            com.comalatech.workflow.model.Assignment assigment = valueStore.getPageState().getLastAssignment();
            if (this.adhoc) {
                ok = valueStore.getPage().getCreatorName() != null && valueStore.getPage().getCreatorName().equals(AuthenticatedUserThreadLocal.getUsername());
            }
            ok = ok || this.checkUsers(valueStore, (Assignment)assigment) || this.checkGroups(valueStore, (Assignment)assigment);
        } else {
            ok = true;
        }
        return ok && super.evaluate(valueStore);
    }

    private boolean checkGroups(ValueStore valueStore, Assignment assigment) throws WorkflowException {
        if (TextUtils.stringSet((String)assigment.getGroups())) {
            GroupCondition condition = new GroupCondition(false, assigment.getAssignerAndAssignees());
            return condition.evaluate(valueStore);
        }
        return false;
    }

    private boolean checkUsers(ValueStore valueStore, Assignment assigment) throws WorkflowException {
        if (TextUtils.stringSet((String)assigment.getAssignee())) {
            UserCondition condition = new UserCondition(false, assigment.getAssignerAndAssignees());
            return condition.evaluate(valueStore);
        }
        return false;
    }

    public void validateAllowedStateNames(StatesContainer statesContainer) throws StateException {
        this.allowedStates = new ArrayList<State>(this.allowedStatesNames.length);
        for (String stateName : this.allowedStatesNames) {
            State state = statesContainer.getState(stateName);
            if (state == null) {
                throw new StateException("Invalid state name '" + stateName + "'");
            }
            this.allowedStates.add(state);
        }
    }

    public boolean isAutoSelect() {
        return false;
    }

    @Override
    public boolean isAdhoc() {
        return this.adhoc;
    }

    public boolean isAllowAssignment() {
        return true;
    }

    public boolean isSelectDueDate() {
        return this.selectDueDate;
    }

    public void setSelectDueDate(boolean selectDueDate) {
        this.selectDueDate = selectDueDate;
    }

    public String getNewStateDueDate() {
        return Timer.FORMATTER.print(new DateTime().plusDays(1));
    }

    public void setAdhoc(boolean adhoc) {
        this.adhoc = adhoc;
    }

    public boolean isExplicit() {
        return true;
    }

    public void removeAllowedState(State state) {
        ArrayList<String> names = new ArrayList<String>();
        Iterator<State> stateIterator = this.allowedStates.iterator();
        while (stateIterator.hasNext()) {
            State allowedState = stateIterator.next();
            if (allowedState.equals(state)) {
                stateIterator.remove();
                continue;
            }
            names.add(allowedState.getName());
        }
        this.allowedStatesNames = names.toArray(new String[names.size()]);
    }

    public List<State> getAllowedStates() {
        return this.allowedStates;
    }

    @Override
    public List<String> getStates() {
        ArrayList<String> states = new ArrayList<String>();
        for (State allowedState : this.allowedStates) {
            states.add(allowedState.getName());
        }
        return states;
    }

    @Override
    public String getName() {
        return "";
    }

    public List<? extends com.comalatech.workflow.model.Assignment> getAssignments() {
        return Collections.emptyList();
    }

    @Override
    public boolean canExecute() {
        return true;
    }

    public String toString() {
        return "StateSelection{allowedStates=" + this.allowedStates + '}';
    }

    @Override
    public SerializableMacro toMacro() {
        if (!this.isExplicit()) {
            throw new IllegalStateException("this selection should not generate macro");
        }
        SerializableMacro macro = new SerializableMacro("state-selection", false);
        macro.addParameter("states", (Object)MiscUtils.stringListToCommaSeparatedList(this.allowedStatesNames, ","));
        for (Condition condition : this.conditions) {
            condition.addMacroParameters(macro);
        }
        return macro;
    }

    protected static String[] getNames(List<State> allowedStates) {
        String[] names = new String[allowedStates.size()];
        int i = 0;
        for (State allowedState : allowedStates) {
            names[i++] = allowedState.getName();
        }
        return names;
    }

    public boolean isPageAssignable() {
        return this.pageAssignable;
    }

    public void setPageAssignable(boolean pageAssignable) {
        this.pageAssignable = pageAssignable;
    }
}

