/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.states.macro;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.macro.MacroException;
import com.comalatech.confluence.readack.model.ReadAck;
import com.comalatech.confluence.states.model.State;
import com.comalatech.confluence.states.model.StateSelection;
import com.comalatech.confluence.states.model.StateSubmission;
import com.comalatech.confluence.states.model.Timer;
import com.comalatech.confluence.tasks.model.Task;
import com.comalatech.confluence.util.MiscUtils;
import com.comalatech.confluence.workflow.macros.AbstractWorkflowElementMacro;
import com.comalatech.confluence.workflow.macros.templates.MacroParameters;
import com.comalatech.confluence.workflow.model.Approval;
import com.comalatech.confluence.workflow.model.WorkflowElement;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateMacro
extends AbstractWorkflowElementMacro {
    private static final Logger log = LoggerFactory.getLogger(StateMacro.class);
    public static final String PARAM_CHANGE_DUE_DATE = "changeduedate";

    @Override
    public boolean hasBody() {
        return true;
    }

    @Override
    public RenderMode getBodyRenderMode() {
        return RenderMode.NO_RENDER;
    }

    public String execute(Map parameters, String body, RenderContext renderContext) throws MacroException {
        Parameters params = new Parameters(parameters, renderContext);
        State state = new State(params.name, params.finalState, params.approvedState, params.rejectedState, params.updatedState, params.expiredState, params.completedState);
        state.setVersionsCompleted(params.versionsCompleted);
        state.setEndState(params.endState);
        state.setDescription(params.description);
        state.setAssignable(params.assignable);
        state.setHideSelection(params.hideSelection);
        state.setHideFromPath(params.hideFromPath);
        state.setColour(params.colour);
        state.setDueDate(params.dueDate);
        RenderContext dummyContext = this.createDummyRenderContext(this.getAbstractPage(renderContext));
        String output = this.render(body, dummyContext, RenderMode.ALL);
        if (output.trim().length() > 0) {
            log.error("error in state " + state.getName());
            throw new MacroException("error in state " + state.getName());
        }
        List<WorkflowElement> stateElements = this.getElementsList(dummyContext);
        ArrayList<Approval> approvals = new ArrayList<Approval>();
        ArrayList<StateSelection> transitions = new ArrayList<StateSelection>();
        for (WorkflowElement stateElement : stateElements) {
            if (stateElement instanceof Approval) {
                approvals.add((Approval)stateElement);
                continue;
            }
            if (stateElement instanceof StateSelection) {
                transitions.add((StateSelection)stateElement);
                continue;
            }
            if (stateElement instanceof Timer) {
                state.getTimers().add((Timer)stateElement);
                continue;
            }
            if (stateElement instanceof Task) {
                state.getTasks().add((Task)stateElement);
                continue;
            }
            if (stateElement instanceof ReadAck) {
                if (state.isFinalState()) {
                    state.setReadAck((ReadAck)stateElement);
                    continue;
                }
                throw new MacroException("A Read Acknowledgment can only be set in a final state");
            }
            throw new MacroException("only approvals or transitions can be defined within a state");
        }
        state.setApprovals(approvals);
        this.addStateDefinedTransitions(transitions, params);
        state.setStateSelections(transitions);
        state.setTaskable(params.taskable);
        state.setChangeDueDate(params.changeDueDate);
        List<WorkflowElement> elements = this.getElementsList(renderContext);
        elements.add(state);
        state.setRequiredParams(StringUtils.isNotBlank((CharSequence)params.requiredParams) ? params.requiredParams.replaceAll("\\s*,\\s*", ",") : null);
        return "";
    }

    private void addStateDefinedTransitions(List<StateSelection> transitions, Parameters parameters) {
        if (TextUtils.stringSet((String)parameters.submitState)) {
            transitions.add(new StateSubmission(null, parameters.submitState));
        } else if (TextUtils.stringSet((String)parameters.selectableStates)) {
            transitions.add(new StateSelection(null, MiscUtils.splitAndTrim(parameters.selectableStates)));
        }
    }

    private RenderContext createDummyRenderContext(AbstractPage page) throws MacroException {
        AbstractPage dummy;
        try {
            dummy = (AbstractPage)page.clone();
        }
        catch (Exception e) {
            throw new MacroException("Error cloning page");
        }
        return dummy.toPageContext();
    }

    @Override
    public boolean allowsAnonymousUser() {
        return false;
    }

    private class Parameters
    extends MacroParameters {
        String name;
        String approvedState;
        String rejectedState;
        String updatedState;
        String expiredState;
        String completedState;
        boolean finalState;
        boolean endState;
        String description;
        String style;
        String className;
        String selectableStates;
        String submitState;
        boolean hideSelection;
        String dueDate;
        boolean assignable;
        boolean taskable;
        boolean hideFromPath;
        boolean changeDueDate;
        boolean versionsCompleted;
        String colour;
        String requiredParams;

        private Parameters(Map parameters, RenderContext renderContext) throws MacroException {
            super(parameters, renderContext);
            this.name = this.get(new String[]{"name", "0"});
            if (!State.isValidStateName(this.name)) {
                throw new MacroException("Invalid characters in state name " + this.name);
            }
            this.endState = this.getFlagWithDefault(new String[]{"end", "terminal", "close"}, false);
            this.approvedState = this.get(new String[]{"approved"});
            this.rejectedState = this.get(new String[]{"rejected"});
            this.updatedState = this.get(new String[]{"updated"});
            this.expiredState = this.get(new String[]{"expired"});
            this.completedState = this.get(new String[]{"completed"});
            this.selectableStates = this.get(new String[]{"select", "states"});
            this.hideSelection = this.getFlag(new String[]{"hideselection", "selection"});
            this.submitState = this.get(new String[]{"submit", "submitted", "submitstate"});
            this.description = this.get(new String[]{"description", "caption"});
            this.style = this.get(new String[]{"style", "cssstyle"});
            this.className = this.get(new String[]{"class", "classname", "cssclass"});
            this.finalState = this.getFlagWithDefault("final", false);
            this.versionsCompleted = this.getFlagWithDefault("versionscompleted", false);
            if (this.finalState && this.className == null) {
                this.className = "aprv-final";
            }
            this.dueDate = this.get(new String[]{"duedate", "dueDate"});
            this.changeDueDate = this.getFlagWithDefault(StateMacro.PARAM_CHANGE_DUE_DATE, false);
            this.assignable = this.getFlagWithDefault(new String[]{"assignable", "assign"}, false);
            this.taskable = this.getFlagWithDefault(new String[]{"taskable", "tasks"}, false);
            this.hideFromPath = this.getFlagWithDefault("hidefrompath", false);
            this.colour = this.get(new String[]{"colour", "color"});
            this.requiredParams = this.get(new String[]{"requiredparams"});
        }
    }
}

