/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.readack.extractors;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.plugins.index.api.Extractor2;
import com.atlassian.confluence.plugins.index.api.FieldDescriptor;
import com.comalatech.confluence.readack.ReadAckException;
import com.comalatech.confluence.readack.model.ReadAckConfig;
import com.comalatech.confluence.readack.service.ReadAckConfigManager;
import com.comalatech.confluence.workflow.PageWorkflows;
import com.comalatech.confluence.workflow.WorkflowAccessor;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadAckExtractor
implements Extractor2 {
    private static final Logger log = LoggerFactory.getLogger(ReadAckExtractor.class);
    private final ReadAckConfigManager readAckConfigManager;
    private final WorkflowAccessor workflowAccessor;

    public ReadAckExtractor(ReadAckConfigManager readAckConfigManager, WorkflowAccessor workflowAccessor) {
        this.readAckConfigManager = readAckConfigManager;
        this.workflowAccessor = workflowAccessor;
    }

    public StringBuilder extractText(Object searchable) {
        return new StringBuilder();
    }

    public Collection<FieldDescriptor> extractFields(Object searchable) {
        ArrayList<FieldDescriptor> fieldList;
        block9: {
            if (!(searchable instanceof AbstractPage)) {
                return null;
            }
            AbstractPage abstractPage = (AbstractPage)searchable;
            fieldList = new ArrayList<FieldDescriptor>();
            PageWorkflows pageWorkflows = this.workflowAccessor.getPageWorkflows(abstractPage);
            try {
                if (pageWorkflows == null || pageWorkflows.getWorkflows().size() <= 0 || pageWorkflows.getReadAck() == null) break block9;
                fieldList.add(new FieldDescriptor("pageworkflowhasreadack", abstractPage.getIdAsString(), FieldDescriptor.Store.YES, FieldDescriptor.Index.NOT_ANALYZED));
                ReadAckConfig readAckConfig = null;
                try {
                    readAckConfig = this.readAckConfigManager.loadReadAckConfig(abstractPage);
                }
                catch (ReadAckException e) {
                    log.error(e.getMessage());
                }
                if (readAckConfig != null) {
                    fieldList.add(new FieldDescriptor("readAckStatus", readAckConfig.status.toString(), FieldDescriptor.Store.YES, FieldDescriptor.Index.NOT_ANALYZED));
                    fieldList.add(new FieldDescriptor("hasreadack", "true", FieldDescriptor.Store.YES, FieldDescriptor.Index.NOT_ANALYZED));
                    fieldList.add(new FieldDescriptor("pagehasreadack", abstractPage.getIdAsString(), FieldDescriptor.Store.YES, FieldDescriptor.Index.NOT_ANALYZED));
                    if (pageWorkflows.isPageReadConfirmation()) {
                        fieldList.add(new FieldDescriptor("pageHasStandaloneReadAck", abstractPage.getIdAsString(), FieldDescriptor.Store.YES, FieldDescriptor.Index.NOT_ANALYZED));
                    } else if (pageWorkflows.isStandAloneReadAck()) {
                        fieldList.add(new FieldDescriptor("spaceHasStandaloneReadAck", abstractPage.getSpaceKey(), FieldDescriptor.Store.YES, FieldDescriptor.Index.NOT_ANALYZED));
                    }
                }
            }
            catch (Exception ex) {
                log.error("Error extracting fields: " + ExceptionUtils.getStackTrace((Throwable)ex));
            }
        }
        return fieldList;
    }
}

