/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.mapper.task;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.ConfluenceEvent;
import com.atlassian.confluence.pages.AbstractPage;
import com.comalatech.confluence.documentActivity.domain.entities.Action;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetail;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetails;
import com.comalatech.confluence.documentActivity.domain.entities.ActionType;
import com.comalatech.confluence.documentActivity.domain.entities.Activity;
import com.comalatech.confluence.documentActivity.domain.entities.Actor;
import com.comalatech.confluence.documentActivity.mapper.EventActivityMapper;
import com.comalatech.confluence.documentActivity.mapper.GenericEventActivityMapper;
import com.comalatech.confluence.documentActivity.util.ActorUtils;
import com.comalatech.confluence.states.event.BlogPostTaskCreateEvent;
import com.comalatech.confluence.states.event.PageTaskCreateEvent;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.tasks.model.PageTask;
import com.comalatech.confluence.workflow.WorkflowUserException;

public class TaskCreationMapper
extends GenericEventActivityMapper
implements EventActivityMapper {
    public TaskCreationMapper(ActorUtils actorUtils) {
        super(actorUtils);
    }

    @Override
    public Activity map(ConfluenceEvent event) throws WorkflowUserException {
        if (event instanceof PageTaskCreateEvent) {
            PageTaskCreateEvent pageTaskCreateEvent = (PageTaskCreateEvent)event;
            return this.buildActivity((AbstractPage)pageTaskCreateEvent.getPage(), (PageState)pageTaskCreateEvent.getState(), (PageTask)pageTaskCreateEvent.getTask());
        }
        if (event instanceof BlogPostTaskCreateEvent) {
            BlogPostTaskCreateEvent blogPostTaskCreateEvent = (BlogPostTaskCreateEvent)event;
            return this.buildActivity((AbstractPage)blogPostTaskCreateEvent.getBlogPost(), (PageState)blogPostTaskCreateEvent.getState(), (PageTask)blogPostTaskCreateEvent.getTask());
        }
        return null;
    }

    protected Activity buildActivity(AbstractPage abstractPage, PageState state, PageTask pageTask) throws WorkflowUserException {
        Actor actor = this.actorUtils.buildActor(pageTask.getPerformer());
        ActionDetails details = new ActionDetails();
        details.addDetail(ActionDetail.Type.TASK_NAME, pageTask.getName());
        details.addAll(this.buildStateActionDetails(state));
        if (pageTask.getComment() != null && pageTask.getComment().length() > 0) {
            details.addDetail(ActionDetail.Type.TASK_DESCRIPTION, pageTask.getComment());
        }
        Action action = new Action(new ActionType(ActionType.Type.TASK, ActionType.Subtype.TASK_CREATION), actor, details);
        return new Activity(TaskCreationMapper.buildTarget((ContentEntityObject)abstractPage), pageTask.getDate().getTime(), action);
    }
}

