/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.ao.accesor;

import com.comalatech.confluence.documentActivity.ao.ActivityDeleteCriteria;
import com.comalatech.confluence.documentActivity.ao.ActivitySearchCriteria;
import com.comalatech.confluence.documentActivity.ao.accesor.ActivityRecordAccessor;
import com.comalatech.confluence.documentActivity.ao.accesor.FiltersProcessor;
import com.comalatech.confluence.documentActivity.ao.entity.ActivityDetailsRecordEntity;
import com.comalatech.confluence.documentActivity.ao.entity.ActivityRecordEntity;
import com.comalatech.confluence.documentActivity.ao.entity.BaseActivityDetailsRecord;
import com.comalatech.confluence.documentActivity.ao.entity.BaseActivityRecord;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetail;
import com.comalatech.confluence.documentActivity.service.model.DocumentActivityQuery;
import com.comalatech.confluence.util.ActiveObjectsAccessor;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.java.ao.DBParam;
import net.java.ao.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivityRecordAccessorImpl
extends ActiveObjectsAccessor
implements ActivityRecordAccessor {
    private static final Logger log = LoggerFactory.getLogger(ActivityRecordAccessorImpl.class);
    private final FiltersProcessor filterProcessor = new FiltersProcessor();

    @Override
    public ActivityRecordEntity create(BaseActivityRecord record) {
        ActivityRecordEntity entity = (ActivityRecordEntity)this.getAo().create(ActivityRecordEntity.class, new DBParam[]{new DBParam("ACTION_SUBTYPE", (Object)record.getActionSubtype()), new DBParam("ACTION_TYPE", (Object)record.getActionType()), new DBParam("ACTOR_ID", (Object)record.getActorId()), new DBParam("SPACE_KEY", (Object)record.getSpaceKey()), new DBParam("FINAL_VERSION", (Object)record.isFinalVersion()), new DBParam("MOMENT", (Object)record.getMoment()), new DBParam("PAGE_ID", (Object)record.getPageId()), new DBParam("PAGE_VERSION", (Object)record.getPageVersion()), new DBParam("STATE_ID", (Object)record.getStateId()), new DBParam("STATE_NAME", (Object)record.getStateName()), new DBParam("TARGET_ATTACHMENTS", (Object)record.getTargetAttachments()), new DBParam("APP_VERSION", (Object)record.getAppVersion()), new DBParam("ORIGIN", (Object)record.getOrigin())});
        entity.save();
        if (log.isDebugEnabled()) {
            log.debug("Activity record has been created: \n" + record);
        }
        return entity;
    }

    @Override
    public List<BaseActivityRecord> search(DocumentActivityQuery criteria) {
        return (List)this.getAo().executeInTransaction(() -> {
            if (this.filterProcessor.needsDetailQuery(criteria)) {
                this.addSearchDetails(criteria);
            }
            Query query = this.buildQuery(criteria);
            if (log.isDebugEnabled()) {
                log.debug(MessageFormat.format("Executing AO sql query with this where: {0} with this params: {1} with this join: {2}", query.getWhereClause(), query.getWhereParams(), query.getJoins()));
            }
            return query != null ? Arrays.asList((BaseActivityRecord[])this.getAo().find(ActivityRecordEntity.class, query)) : new ArrayList();
        });
    }

    @Override
    @Deprecated
    public List<BaseActivityRecord> search(ActivitySearchCriteria criteria) {
        return (List)this.getAo().executeInTransaction(() -> {
            Query query = this.buildQuery(criteria);
            return query != null ? Arrays.asList((BaseActivityRecord[])this.getAo().find(ActivityRecordEntity.class, query)) : new ArrayList();
        });
    }

    @Override
    public void delete(ActivityDeleteCriteria criteria) {
        this.getAo().deleteWithSQL(ActivityRecordEntity.class, this.buildDeleteQuery(criteria), new Object[0]);
    }

    private Query buildQuery(DocumentActivityQuery criteria) {
        Query query = Query.select().limit(criteria.getLimit() + 5).order("MOMENT " + (Object)((Object)criteria.getSorting())).distinct();
        this.filterProcessor.addFiltersToQuery(query, criteria);
        return query;
    }

    private Query buildQuery(ActivitySearchCriteria searchCriteria) {
        ArrayList<Long> values = new ArrayList<Long>();
        String queryClause = "";
        if (searchCriteria.getContentId() != null) {
            queryClause = "PAGE_ID = ?";
            values.add(searchCriteria.getContentId());
        }
        if (!queryClause.isEmpty()) {
            return Query.select().where(queryClause, values.toArray());
        }
        return null;
    }

    private String buildDeleteQuery(ActivityDeleteCriteria deleteCriteria) {
        String queryClause = "";
        if (deleteCriteria.getContentId() != null) {
            queryClause = "PAGE_ID = " + deleteCriteria.getContentId();
        }
        return queryClause;
    }

    private void addSearchDetails(DocumentActivityQuery criteria) {
        List<BaseActivityDetailsRecord> userRecords;
        List<BaseActivityDetailsRecord> participantRecords = this.searchUserDetails(criteria.getFilters().getParticipant());
        if (participantRecords != null) {
            criteria.getFilters().setRecordIdsFromParticipants(participantRecords.stream().map(r -> r.getActivity().getId()).collect(Collectors.toList()));
        }
        if ((userRecords = this.searchUserDetails(criteria.getFilters().getUser())) != null) {
            criteria.getFilters().setRecordIdsFromUsers(userRecords.stream().map(r -> r.getActivity().getId()).collect(Collectors.toList()));
        }
    }

    private List<BaseActivityDetailsRecord> searchUserDetails(List<String> users) {
        if (users != null && !users.isEmpty()) {
            Query usersQuery = this.buildDetailsQuery(users);
            return Arrays.asList((BaseActivityDetailsRecord[])this.getAo().find(ActivityDetailsRecordEntity.class, usersQuery));
        }
        return null;
    }

    private Query buildDetailsQuery(List<String> users) {
        Query query = Query.select().distinct();
        StringBuilder clause = new StringBuilder();
        String placeHolder = users.stream().map(s -> "?").collect(Collectors.joining(","));
        clause.append("VALUE IN (").append(placeHolder).append(") ");
        clause.append("AND ");
        clause.append("TYPE IN ('").append(ActionDetail.Type.APPROVAL_USER_ASSIGNED.getValue()).append("','").append(ActionDetail.Type.APPROVAL_USER_UNASSIGNED.getValue()).append("','").append(ActionDetail.Type.TASK_USER_ASSIGNED.getValue()).append("')");
        query.where(clause.toString(), users.toArray());
        return query;
    }
}

