/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

/**
 * #StateInfo
 */
var AWP = AWP || {};
AWP.View = AWP.View || {};

AWP.View.StateInfo = Backbone.View.extend({
    className: 'awp-stateinfo',
    template: AWP.Templates.stateInfo,

    events: {
        'click .awp-duedate-open': 'toggleDueDateOptions'
    },

    initialize: function () {
        this.model.on("change", this.render, this);
    },

    render: function () {
        if(!_.isEmpty(this.model.toJSON())) {
            this.$el.html(this.template(this.model.toJSON()));

            // can change it (use date picker)
            if(this.model.get('changeExpirationDate') && this.$('.awp-changeStateDueDate').length > 0) {

                var self = this;
                this.dueDate = new AWP.View.DueDate({
                    model: this.model,
                    el: this.$('.awp-changeStateDueDate'),
                    onSelect: _.bind(this._onChangeDueDate, this),
                    onClose: _.bind(function() {
                        setTimeout(_.bind(this.closeDueDateOptions, this), 100);
                    }, this)
                });
                this.dueDate.render();
                this.dueDate.setRemoveLabel(false);
                this.dueDate.$remove.hide();
            }
        }

        return this.el;
    },

    toggleDueDateOptions: function (e) {
        e.preventDefault();

        if(this.$el.hasClass('awp-duedate-edit')) {
            this.closeDueDateOptions();
        }
        else {
            this.openDueDateOptions();
            this.dueDate.editMode();
        }
    },

    openDueDateOptions: function () {
        this.$el.addClass('awp-duedate-edit');
    },

    closeDueDateOptions: function () {
        this.$el.removeClass('awp-duedate-edit');
        this._hasDueDate();
    },

    _onChangeDueDate: function (date) {
        // update due date
        this.model.save({
            expiryDate : date
        }, {
            silent: true,
            action: 'expirydate',
            success: _.bind(this._dueDateIsSet, this)
        });
    },

    _dueDateIsSet: function (model) {
        this.render();
        AWP.View.WorkflowApp.refreshState(model);
        // track event
        if(model.get('expirationDate')) {
            AWP.Analytics.trackEvent('duedate-state', 'set', 'duedate');
        }
        else {
            AWP.Analytics.trackEvent('duedate-state', 'unset', 'duedate');
        }
    },

    _hasDueDate: function () {
        if(this.model.get('expirationDate')) {
            this.$('.awp-duedate-button').addClass('awp-duedate-isset');
        }
        else {
            this.$('.awp-duedate-button').removeClass('awp-duedate-isset');
        }
    }
});
