/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

"user strict";
var AWP = AWP || {};
var CW = CW || {};
AWP.Blueprints = AWP.Blueprints || {};
AWP.Blueprints.View = AWP.Blueprints.View || {};

var requirejs = require || requirejs;
requirejs(['cw', 'backbone', 'jquery'], function (CW, Backbone, $) {
    AWP.Blueprints.View.AttachWorkflow = Backbone.View.extend({

        className: "dialog-components",
        dialogWidth: '840',
        dialogHeight: '449',
        fancy: false,

        events : {
            "click .awp-attach" : "doAttach",
            "click .awp-cancel" : "cancel",
            "change select" : "selectWorkflow"
        },

        doAttach: function() {
            var popup = this.popup;
            var template = this.template;
            var idMessage =  this.options.idMessage;
            var data = {
                workflow: this.blueprintWorkflowKey || this.$("select option:selected").html(),
                templateKey: this.template.blueprint.templateKey,
                blueprintKey: this.template.blueprint.blueprintKey,
                label: this.template.blueprint.label
            };
            CW.request({ type: 'POST', url : CW.contextPath + "/rest/adhocworkflows/latest/blueprints/" + AWP.Blueprints.spaceKey + "/attach",
                    data : JSON.stringify(data),
                    success : function(blueprint) {
                    template.blueprint = blueprint;
                    template.render();
                    popup.hide();

                    CW.message('success', 'body', {
                        id: idMessage,
                        title: CW.I18n.getText("awp.blueprints.workflow.attached.title"),
                        fadeout: true,
                        delay: 2000,
                        body: "<p>" + CW.I18n.getText("awp.blueprints.workflow.attached.description") + "</p>"
                    });
                },
                    contentType : 'application/json'
                }
            );
        },

        cancel: function() {
            this.popup.hide();
        },

        selectWorkflow: function() {
            var workflowName = this.$("select option:selected").html();
            var workflow = _.find(this.template.blueprint.workflows,function(workflow) {return workflow.name == workflowName});
            if (workflow) {
                this.$description.html(workflow.descriptionHtml);
                
                this.$(".awp-blueprint-select-default").remove();
                this.$(".awp-workflow-tracker").html(AWP.Blueprints.Templates.workflowPath({path: workflow.path}));
            } else {
                this.$description.html("");
                this.$(".awp-workflow-tracker").html("");
            }

        },

        initialize: function() {
            this.template = this.options.template;
            if (this.template.blueprint.blueprintWorkflow) {
                this.blueprintWorkflowKey = this.template.blueprint.blueprintWorkflow.key;
            }
            var _self = this;
            var popup = new CW.Dialog({
                width: 840,
                height: 449,
                id: "attach-blueprint",
                closeable: true,
                title: CW.I18n.getText('awp.blueprints.workflow.attach'),
                hint: '<a href="https://apps.appf.re/cdmdc/doc/blueprints/npewwh" target="_blank">' + CW.I18n.getText('awp.blueprints.workflow.help') + '</a>',
                actions: [{
                    id: 'attach',
                    label: CW.I18n.getText('awp.blueprints.workflow.attach.action'),
                    style: 'primary',
                    onClick: function() {
                        _self.doAttach();
                    }
                }, {
                    id: 'cancel',
                    label: CW.I18n.getText('approvalsworkflow.cancel'),
                    style: 'link',
                    onClick: function() {
                        popup.hide();
                    }
                }],
                content: this.$el
            });
            this.popup = popup;
        },

        render: function() {
            if (this.template.blueprint.blueprintWorkflow) {
                this.$el.html(AWP.Blueprints.Templates.attachBlueprintWorkflow({
                    name: this.template.blueprint.blueprintWorkflow.name.toLowerCase().split(' ').join('-'),
                    blueprintWorkflowKey: this.template.blueprint.blueprintWorkflow.key,
                    description: this.template.blueprint.blueprintWorkflow.descriptionHtml
                }));

                this.$(".awp-workflow-tracker").html(AWP.Blueprints.Templates.workflowPath({
                    path: this.template.blueprint.blueprintWorkflow.path
                }));
            } else {
                this.$el.html(AWP.Blueprints.Templates.attachWorkflow({
                    workflows: this.template.blueprint.workflows,
                    label: this.template.blueprint.label,
                    fancy: this.fancy
                }));
            }
            this.$description = this.$(".awp-workflow-description");

            //  external links has to be opened in a new window
            $('a.external-link').attr('target', '_blank');

            $('#blueprint-dialog').css({
                'width' : this.dialogWidth + 'px',
                'height' : this.dialogHeight + 'px'
            });
            this.popup.show();
        }

    });

    AWP.Blueprints.View.DetachWorkflow = Backbone.View.extend({

        className: "dialog-components",
        dialogWidth: '840',
        dialogHeight: '326',

        events : {
            "click .awp-detach" : "doDetach",
            "click .awp-cancel" : "cancel"
        },

        doDetach: function() {
            var popup = this.popup;
            var template = this.template;
            var data = {
                workflow: this.template.blueprint.workflowName,
                templateKey: this.template.blueprint.templateKey,
                label: this.template.blueprint.label
            };
            CW.request({
                type: 'POST', url : CW.contextPath + "/rest/adhocworkflows/latest/blueprints/" + AWP.Blueprints.spaceKey + "/detach",
                data: JSON.stringify(data),
                success: function(blueprint) {
                    template.blueprint = blueprint;
                    template.render();
                    popup.hide();
                },
                contentType: 'application/json'
            });
        },

        cancel: function() {
            this.popup.hide();
        },

        initialize: function() {
            this.template = this.options.template;
            var _self = this;
            var popup = new CW.Dialog({
                size: 'small',
                height: 300,
                id: "detach-blueprint",
                closeable: true,
                title: CW.I18n.getText('awp.blueprints.workflow.detach'),
                actions: [{
                    id: 'detach',
                    label: CW.I18n.getText('awp.blueprints.workflow.detach.action'),
                    style: 'primary',
                    onClick: function () {
                        _self.doDetach();
                    }
                }, {
                    id: 'cancel',
                    label: CW.I18n.getText('approvalsworkflow.cancel'),
                    style: 'link',
                    onClick: function () {
                        popup.hide();
                    }
                }],
                content: this.$el
            });
            this.popup = popup;
        },

        render: function() {
            this.$el.html(AWP.Blueprints.Templates.detachWorkflow({
                workflowName: this.template.blueprint.workflowName,
                label: this.template.blueprint.label
            }));

            $('#blueprint-dialog').css({
                'width' : this.dialogWidth + 'px',
                'height' : this.dialogHeight + 'px'
            });
            this.popup.show();
        }

    });
});