/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.storage.confluence;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.joda.time.DateTime;
import org.randombits.storage.BasedStorage;
import org.randombits.storage.IndexedStorage;
import org.randombits.storage.StringBasedStorage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MacroParameterStorage
extends StringBasedStorage
implements IndexedStorage {
    private Map<String, String> originalParams;
    private Map<String, String> params;

    public MacroParameterStorage(Map<String, String> params) {
        super(BasedStorage.BoxType.Virtual);
        this.cleanIndexedParams(params);
        this.originalParams = params;
        this.params = this.toLowerCase(params);
    }

    private Map<String, String> toLowerCase(Map<String, String> params) {
        HashMap<String, String> lcParams = new HashMap<String, String>();
        for (Map.Entry<String, String> e : params.entrySet()) {
            lcParams.put(e.getKey().toLowerCase(), e.getValue());
        }
        return lcParams;
    }

    private void cleanIndexedParams(Map<String, String> params) {
        String value;
        int i = 0;
        do {
            String index;
            if ((value = params.get(index = String.valueOf(i++))) == null || value.indexOf(61) < 0) continue;
            params.remove(index);
        } while (value != null);
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public String getString(int index, String def) {
        return this.getString(String.valueOf(index), def);
    }

    @Override
    protected Set<String> baseNameSet() {
        return this.originalParams.keySet();
    }

    @Override
    protected String[] getBaseStringArray(String name) {
        String value = this.getBaseString(name);
        if (value != null) {
            return value.split("[,;]");
        }
        return null;
    }

    @Override
    protected String getBaseString(String name) {
        if (name != null) {
            return this.params.get(name.toLowerCase());
        }
        return null;
    }

    @Override
    protected void setBaseString(String name, String value) {
        this.checkReadOnly();
    }

    @Override
    public boolean getBoolean(int index, boolean def) {
        return this.getBoolean(String.valueOf(index), def);
    }

    @Override
    public Boolean getBoolean(int index, Boolean def) {
        return this.getBoolean(String.valueOf(index), def);
    }

    @Override
    public Date getDate(int index, Date def) {
        return this.getDate(String.valueOf(index), def);
    }

    @Override
    public DateTime getDateTime(int index, DateTime def) {
        return this.getDateTime(String.valueOf(index), def);
    }

    @Override
    public double getDouble(int index, double def) {
        return this.getDouble(String.valueOf(index), def);
    }

    @Override
    public Double getDouble(int index, Double def) {
        return this.getDouble(String.valueOf(index), def);
    }

    @Override
    public int getInteger(int index, int def) {
        return this.getInteger(String.valueOf(index), def);
    }

    @Override
    public Integer getInteger(int index, Integer def) {
        return this.getInteger(String.valueOf(index), def);
    }

    @Override
    public long getLong(int index, long def) {
        return this.getLong(String.valueOf(index), def);
    }

    @Override
    public Long getLong(int index, Long def) {
        return this.getLong(String.valueOf(index), def);
    }

    @Override
    public Object getObject(int index, Object def) {
        return this.getObject(String.valueOf(index), def);
    }

    @Override
    public List<?> getObjectList(int index, List<?> def) {
        return this.getObjectList(String.valueOf(index), def);
    }

    @Override
    public String[] getStringArray(int index, String[] def) {
        return this.getStringArray(String.valueOf(index), def);
    }

    @Override
    public Set<String> getStringSet(int index, Set<String> def) {
        return this.getStringSet(String.valueOf(index), def);
    }
}

