/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.pageactivity;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.comalatech.confluence.workflowreports.ReportDateFormatter;
import com.comalatech.confluence.workflowreports.model.ActivityReportEntry;
import com.comalatech.confluence.workflowreports.pageactivity.PageActivityCsvEntryProcessorLegacy;
import com.comalatech.confluence.workflowreports.pageactivity.PageActivityCsvService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageActivityCsvServiceImpl
implements PageActivityCsvService<ActivityReportEntry> {
    private static final Logger log = LoggerFactory.getLogger(PageActivityCsvServiceImpl.class);
    protected static final String LINE_SEPARATOR = System.getProperty("line.separator");
    protected static final String COMMA = ",";
    private final PageActivityCsvEntryProcessorLegacy legacyProcessor;

    public PageActivityCsvServiceImpl(LocaleManager localeManager, PageManager pageManager) {
        ReportDateFormatter dateFormatter = new ReportDateFormatter(localeManager);
        this.legacyProcessor = new PageActivityCsvEntryProcessorLegacy(pageManager, dateFormatter);
    }

    @Override
    public String getPageActivityFileContent(List<ActivityReportEntry> entries, AbstractPage page) {
        if (entries.size() == 0) {
            return "";
        }
        return this.generateCsvFileContent(entries, page);
    }

    public String generateCsvFileContent(List<ActivityReportEntry> entries, AbstractPage page) {
        StringBuilder builder = new StringBuilder();
        this.generateHeaders(builder);
        this.processEntries(entries, builder, page);
        return builder.toString();
    }

    private void processEntries(List<ActivityReportEntry> entries, StringBuilder builder, AbstractPage page) {
        for (ActivityReportEntry entry : entries) {
            this.legacyProcessor.processEntry(builder, page, entry);
        }
    }

    private void generateHeaders(StringBuilder builder) {
        builder.append(ConfluenceActionSupport.getTextStatic((String)"com.comalatech.activity.report.csvexport.date.header")).append(COMMA).append(ConfluenceActionSupport.getTextStatic((String)"com.comalatech.activity.report.csvexport.username.header")).append(COMMA);
        builder.append(ConfluenceActionSupport.getTextStatic((String)"com.comalatech.activity.report.csvexport.contributors.header")).append(COMMA);
        builder.append(ConfluenceActionSupport.getTextStatic((String)"com.comalatech.activity.report.csvexport.activity.header")).append(COMMA).append(ConfluenceActionSupport.getTextStatic((String)"com.comalatech.activity.report.csvexport.description.header")).append(COMMA).append(ConfluenceActionSupport.getTextStatic((String)"com.comalatech.activity.report.csvexport.pageversion.header")).append(COMMA).append(ConfluenceActionSupport.getTextStatic((String)"com.comalatech.activity.report.csvexport.pageId.header")).append(COMMA).append(ConfluenceActionSupport.getTextStatic((String)"com.comalatech.activity.report.csvexport.usercomment.header")).append(LINE_SEPARATOR);
    }
}

