/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports;

import com.atlassian.confluence.core.TimeZone;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.User;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class ReportDateFormatter {
    public static final String DEFAULT_DATE_TIME_PATTERN = "MMM dd yyyy HH:mm XXX";
    public static final String PRECISE_DATE_TIME_PATTERN = "yyyy-MM-dd HH:mm:ss XXX";
    public static final String EXPIRY_DATE_TIME_PATTERN = "dd MMM, yyyy hh:mm aa";
    private LocaleManager localeManager;

    public ReportDateFormatter(LocaleManager localeManager) {
        this.localeManager = localeManager;
    }

    public String formatServerTime(Date date) {
        DateFormat format = this.createServerFormat("h:mm a");
        return this.formatWith(format, date);
    }

    public String formatServerDateTime(Date date) {
        DateFormat format = this.createServerFormat(DEFAULT_DATE_TIME_PATTERN);
        return this.formatWith(format, date);
    }

    public String formatServerDateTimePrecise(Date date) {
        DateFormat format = this.createServerFormat(PRECISE_DATE_TIME_PATTERN);
        return this.formatWith(format, date);
    }

    public String formatExpiryDateTime(Date date) {
        DateFormat format = this.createServerFormat(EXPIRY_DATE_TIME_PATTERN);
        return this.formatWith(format, date);
    }

    private DateFormat createServerFormat(String pattern) {
        SimpleDateFormat format = new SimpleDateFormat(pattern, this.getCurrentUserLocale());
        format.setLenient(false);
        format.setTimeZone(TimeZone.getDefault().getWrappedTimeZone());
        return format;
    }

    private String formatWith(DateFormat format, Date date) {
        try {
            return format.format(date);
        }
        catch (Exception e) {
            return "";
        }
    }

    private Locale getCurrentUserLocale() {
        Locale locale;
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (this.localeManager == null) {
            this.localeManager = (LocaleManager)ContainerManager.getComponent((String)"localeManager");
        }
        if ((locale = this.localeManager.getLocale((User)user)) != null) {
            return locale;
        }
        return Locale.getDefault();
    }
}

