/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowcontainer.action;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.WikiStyleRenderer;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.user.User;
import com.comalatech.confluence.license.AdhocWorkflowsLicenseManager;
import com.comalatech.confluence.util.Awp31UpgradeUtils;
import com.comalatech.confluence.workflow.InvalidWorkflow;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.analytics.web.WebAnalyticsManager;
import com.comalatech.confluence.workflow.service.ApprovalsSearchService;
import com.comalatech.confluence.workflow.stats.WorkflowStatisticsManager;
import com.comalatech.confluence.workflowcontainer.WorkflowContainerManager;
import com.comalatech.confluence.workflowcontainer.model.WorkflowActionEnum;
import com.comalatech.workflow.template.LinkedTemplateManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

public class GlobalWorkflowsAction
extends ConfluenceActionSupport {
    private static final Logger log = LoggerFactory.getLogger(GlobalWorkflowsAction.class);
    private List<InvalidWorkflow> invalidWorkflows;
    private String workflowName;
    private String pagesWithWorkflow;
    private String spacesWithWithWorkflow;
    private AdhocWorkflowsLicenseManager licenseManager;
    private WorkflowContainerManager workflowContainerManager;
    private WikiStyleRenderer wikiStyleRenderer;
    private WebResourceManager webResourceManager;
    private Awp31UpgradeUtils awp31UpgradeUtils;
    private LinkedTemplateManager linkedTemplateManager;
    private SpaceManager spaceManager;
    private ApprovalsSearchService approvalsSearchService;
    private WorkflowStatisticsManager workflowStatisticsManager;
    private WebAnalyticsManager webAnalyticsManager;
    private final String docoUrl = "https://apps.appf.re/cdmdc/doc/globalworkflows/vqKsn3";

    public String execute() throws Exception {
        this.webResourceManager.requireResource("confluence.web.resources:jquery");
        this.webResourceManager.requireResource("confluence.web.resources:ajs");
        this.calculateUsageStats();
        this.invalidWorkflows = this.workflowContainerManager.getInvalidWorkflowTemplates(null);
        return "success";
    }

    public String enable() throws Exception {
        return this.toggleWorkflowState(true);
    }

    public String disable() throws Exception {
        return this.toggleWorkflowState(false);
    }

    public String delete() {
        return this.doWithWorkflow(workflow -> this.workflowContainerManager.removeWorkflowTemplate(null, workflow.getName()));
    }

    public String copy() throws Exception {
        return this.doWithWorkflow(workflow -> this.workflowContainerManager.copyWorkflowTemplate(null, workflow));
    }

    public String toggleWorkflowState(boolean enable) {
        return this.doWithWorkflow(workflow -> {
            workflow.setActive(enable);
            this.workflowContainerManager.saveWorkflowTemplate(null, workflow, false, null);
        });
    }

    private String doWithWorkflow(WorkflowCommand command) {
        Workflow workflow = null;
        try {
            workflow = this.workflowContainerManager.getWorkflowTemplate(null, this.workflowName);
        }
        catch (WorkflowException e) {
            log.error(e.getMessage());
        }
        if (workflow == null) {
            log.error("invalid workflow name " + this.workflowName);
            return "success";
        }
        command.command(workflow);
        return "success";
    }

    private void calculateUsageStats() {
        int pagesCount = this.approvalsSearchService.getNumberOfPagesWithWorkflow();
        if (pagesCount > 0) {
            this.pagesWithWorkflow = pagesCount >= 1000 ? pagesCount + "+" : pagesCount + "";
            int spacesCount = this.approvalsSearchService.getNumberOfSpacesWithWorkflow();
            this.spacesWithWithWorkflow = spacesCount >= 20 ? spacesCount + "+" : spacesCount + "";
        }
    }

    public String render(String body) {
        PageContext context = new PageContext();
        context.pushRenderMode(RenderMode.suppress((long)1L));
        return this.wikiStyleRenderer.convertWikiToXHtml((RenderContext)context, body);
    }

    public void setWorkflowName(String workflowName) {
        this.workflowName = workflowName;
    }

    public void setWikiStyleRenderer(WikiStyleRenderer wikiStyleRenderer) {
        this.wikiStyleRenderer = wikiStyleRenderer;
    }

    public void setWorkflowContainerManager(WorkflowContainerManager workflowContainerManager) {
        this.workflowContainerManager = workflowContainerManager;
    }

    public void setWebResourceManager(WebResourceManager webResourceManager) {
        this.webResourceManager = webResourceManager;
    }

    public List<Page> getLegacyWorkflows() {
        return this.awp31UpgradeUtils.getLegacyWorkflowPages();
    }

    public void setAwp31UpgradeUtils(Awp31UpgradeUtils awp31UpgradeUtils) {
        this.awp31UpgradeUtils = awp31UpgradeUtils;
    }

    public List<Workflow> getGlobalWorkflows() {
        return this.workflowContainerManager.getWorkflowTemplates(null);
    }

    public List<String> getLinkedSpaces(String workflowName) {
        return this.linkedTemplateManager.getLinkedSpaces(workflowName);
    }

    public List<String> getLinkedSpaceLabels(String workflowName) {
        return this.linkedTemplateManager.getLinkedSpaceLabels(workflowName);
    }

    public Space getSpace(String spaceKey) {
        return this.spaceManager.getSpace(spaceKey);
    }

    public String getWorkflowLicenseMessageHtml() {
        return this.licenseManager.getLicenseStatus().getMessageHtml();
    }

    public List<WorkflowActionEnum> getWorkflowGlobalActions(Workflow workflow) {
        ArrayList<WorkflowActionEnum> actions = new ArrayList<WorkflowActionEnum>();
        if (workflow.isActive()) {
            actions.add(WorkflowActionEnum.DISABLE_GLOBAL_WORKFLOW);
        } else {
            actions.add(WorkflowActionEnum.ENABLE_GLOBAL_WORKFLOW);
        }
        actions.add(WorkflowActionEnum.COPY_GLOBAL_WORKFLOW);
        actions.add(WorkflowActionEnum.DELETE_GLOBAL_WORKFLOW);
        return actions;
    }

    public List<WorkflowActionEnum> getWorkflowEditActions(Workflow workflow) {
        ArrayList<WorkflowActionEnum> actions = new ArrayList<WorkflowActionEnum>();
        actions.add(WorkflowActionEnum.EDIT_GLOBAL_WORKFLOW);
        return actions;
    }

    public List<WorkflowActionEnum> getLegacyWorkflowsActions(Workflow workflow) {
        return Collections.singletonList(WorkflowActionEnum.EDIT_LEGACY_WORKFLOW);
    }

    public boolean isPermitted() {
        return this.permissionManager.hasPermission((User)this.getAuthenticatedUser(), Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION);
    }

    public void setLinkedTemplateManager(LinkedTemplateManager linkedTemplateManager) {
        this.linkedTemplateManager = linkedTemplateManager;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    public List<InvalidWorkflow> getInvalidWorkflows() {
        return this.invalidWorkflows;
    }

    public String getPagesWithWorkflow() {
        return this.pagesWithWorkflow;
    }

    public String getSpacesWithWithWorkflow() {
        return this.spacesWithWithWorkflow;
    }

    public void setLicenseManager(@Qualifier(value="adhocWorkflowsLicenseManager") AdhocWorkflowsLicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    public void setWorkflowStatisticsManager(WorkflowStatisticsManager workflowStatisticsManager) {
        this.workflowStatisticsManager = workflowStatisticsManager;
    }

    public WorkflowStatisticsManager getWorkflowStatisticsManager() {
        return this.workflowStatisticsManager;
    }

    public void setWebAnalyticsManager(WebAnalyticsManager webAnalyticsManager) {
        this.webAnalyticsManager = webAnalyticsManager;
    }

    public WebAnalyticsManager getWebAnalyticsManager() {
        return this.webAnalyticsManager;
    }

    public String getDocoUrl() {
        return "https://apps.appf.re/cdmdc/doc/globalworkflows/vqKsn3";
    }

    public void setApprovalsSearchService(ApprovalsSearchService approvalsSearchService) {
        this.approvalsSearchService = approvalsSearchService;
    }

    private static interface WorkflowCommand {
        public void command(Workflow var1);
    }
}

