/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.rest.accessor;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.pages.AbstractPage;
import com.comalatech.confluence.adhocworkflows.rest.model.WorkflowAction;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.readack.model.ReadAck;
import com.comalatech.confluence.users.UserSearchManager;
import com.comalatech.confluence.workflow.InternalWorkflowParameterManager;
import com.comalatech.confluence.workflow.PageWorkflows;
import com.comalatech.confluence.workflow.StateSelectionManager;
import com.comalatech.confluence.workflow.WorkflowAccessor;
import com.comalatech.confluence.workflow.rest.accessor.ContentWorkflowAccessor;
import com.comalatech.confluence.workflow.rest.expander.AbstractExpandersHandler;
import com.comalatech.confluence.workflow.rest.expander.content.ActionsExpander;
import com.comalatech.confluence.workflow.rest.expander.content.ApprovalsExpander;
import com.comalatech.confluence.workflow.rest.expander.content.StateExpander;
import com.comalatech.confluence.workflow.rest.expander.content.StatesExpander;
import com.comalatech.confluence.workflow.rest.expander.content.TasksExpander;
import com.comalatech.confluence.workflow.rest.model.ContentApproval;
import com.comalatech.confluence.workflow.rest.model.ContentWorkflowRequest;
import com.comalatech.confluence.workflow.rest.model.ContentWorkflowResponse;
import com.comalatech.confluence.workflow.rest.model.State;
import com.comalatech.workflow.TaskService;
import com.comalatech.workflow.model.PageWorkflowParameter;
import com.opensymphony.util.TextUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultContentWorkflowAccessor
extends AbstractExpandersHandler<ContentWorkflowRequest, ContentWorkflowResponse>
implements ContentWorkflowAccessor {
    private static final Logger log = LoggerFactory.getLogger(DefaultContentWorkflowAccessor.class);
    public static String expanderIds;
    private final WorkflowAccessor workflowAccessor;
    private final InternalWorkflowParameterManager parameterManager;
    private WorkflowsFeatureManager workflowsFeatureManager;

    public DefaultContentWorkflowAccessor(WorkflowAccessor workflowAccessor, InternalWorkflowParameterManager parameterManager, TaskService taskService, UserSearchManager userSearchManager, WorkflowsFeatureManager workflowsFeatureManager, StateSelectionManager stateSelectionManager) {
        this.workflowAccessor = workflowAccessor;
        this.parameterManager = parameterManager;
        this.workflowsFeatureManager = workflowsFeatureManager;
        this.addExpander(new StateExpander(workflowAccessor, stateSelectionManager));
        this.addExpander(new StatesExpander(workflowAccessor));
        this.addExpander(new ApprovalsExpander());
        this.addExpander(new ActionsExpander());
        this.addExpander(new TasksExpander(taskService, userSearchManager));
        expanderIds = this.getIds();
    }

    @Override
    public ContentWorkflowResponse makeContentWorkflowResponse(AbstractPage page, WorkflowAction workflowAction, boolean admin, String expand) {
        List<String> defaultStates = Arrays.asList("Review", "Rejected", "Approved", "Expired", "Draft", "In Approval", "Published", "Obsolete");
        String defaultApproval = "Review this page";
        if (log.isDebugEnabled()) {
            log.debug(String.format("Beginning making contentWorkflowResponse(pageId:%s, isAdmin: %b, expand: %s)", page != null ? page.getIdAsString() : "<null>", admin, expand));
        }
        if (workflowAction.getPageStatus() == null) {
            return null;
        }
        ContentWorkflowResponse response = new ContentWorkflowResponse();
        PageWorkflows pageWorkflows = this.workflowAccessor.getPageWorkflows(page);
        String string = response.workflowName = pageWorkflows.getFirstWorkflowWithStates() != null ? pageWorkflows.getFirstWorkflowWithStates().getName() : "";
        if (workflowAction.getPageStatus().getMessages() != null) {
            response.messages = workflowAction.getPageStatus().getMessages();
        }
        String stateName = workflowAction.getPageStatus().getStateName();
        com.comalatech.confluence.states.model.State currentState = pageWorkflows.getState(stateName);
        response.displayProgressTracker = workflowAction.getPageStatus().isDisplayProgressTracker();
        response.displaySuppressReadConfirmation = this.shouldDisplaySuppressReadConfirmation(currentState, pageWorkflows);
        Map<String, List<PageWorkflowParameter>> params = this.parameterManager.getParametersForAnyTransition(page, currentState, admin);
        workflowAction.params = params;
        if (!TextUtils.stringSet((String)expand)) {
            expand = "";
        }
        ContentWorkflowRequest request = new ContentWorkflowRequest(page, workflowAction, admin);
        HashSet<String> ids = new HashSet<String>(Arrays.asList(StringUtils.split((String)expand, (String)",")));
        ids.add("state");
        this.expand(response, request, ids.toArray(new String[ids.size()]));
        if (!this.workflowsFeatureManager.isWorkflowsApp()) {
            if (response.state != null && defaultStates.contains(response.state.name)) {
                this.addTranslationState(response, defaultStates);
            }
            if (response.states != null) {
                this.addTranslationStates(response, defaultStates);
            }
            if (response.approvals != null) {
                this.addTranslationApprovals(response, defaultApproval);
            }
        }
        response.contributors = workflowAction.getContributors();
        log.debug("Finishing making contentWorkflowResponse");
        return response;
    }

    private void addTranslationState(ContentWorkflowResponse response, List<String> defaultStates) {
        response.state.nameTranslation = this.toTranslate(response.state.name, "workflow.state.name.");
    }

    private void addTranslationStates(ContentWorkflowResponse response, List<String> defaultStates) {
        for (State state : response.states) {
            if (!defaultStates.contains(state.name)) continue;
            state.nameTranslation = this.toTranslate(state.name, "workflow.state.name.");
        }
    }

    private void addTranslationApprovals(ContentWorkflowResponse response, String defaultApproval) {
        for (ContentApproval approval : response.approvals) {
            if (!approval.name.equalsIgnoreCase(defaultApproval)) continue;
            approval.nameTranslation = this.toTranslate(approval.name, "workflow.approval.name.");
        }
    }

    private String toTranslate(String stateName, String propertyKey) {
        String stateToTranslate = StringUtils.deleteWhitespace((String)stateName).toLowerCase();
        String stateTranslation = ConfluenceActionSupport.getTextStatic((String)(propertyKey + stateToTranslate));
        return stateTranslation;
    }

    private boolean shouldDisplaySuppressReadConfirmation(com.comalatech.confluence.states.model.State currentState, PageWorkflows pageWorkflows) {
        ReadAck readAck = pageWorkflows.getReadAck();
        AbstractPage currentPage = pageWorkflows.getPage();
        if (readAck == null) {
            return false;
        }
        if (currentState == null) {
            return false;
        }
        return readAck.getApproverRequestOption() && (this.isNextApprovedStateFinal(currentState) || this.oneOfTheNextStatesCanBeFinal(currentState));
    }

    private boolean isNextApprovedStateFinal(com.comalatech.confluence.states.model.State currentState) {
        return currentState.getApprovedState() != null && currentState.getApprovedState().isFinalState();
    }

    private boolean oneOfTheNextStatesCanBeFinal(com.comalatech.confluence.states.model.State currentState) {
        Optional<Object> potentialFinalState = Optional.empty();
        if (currentState.getStateSelections().size() == 1) {
            potentialFinalState = currentState.getStateSelections().get(0).getAllowedStates().stream().filter(com.comalatech.confluence.states.model.State::isFinalState).findAny();
        }
        return potentialFinalState.isPresent();
    }
}

