/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.comalatech.confluence.adhoc.dao.ComalatechBandanaContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowAdvancedConfigurationManager {
    private static final Logger log = LoggerFactory.getLogger(WorkflowAdvancedConfigurationManager.class);
    private static final String CONFIG_CACHE_PRODUCTION_WORKFLOWS_KEY = "com.comalatech.workflow.cache.production.workflows";
    private static final String CONFIG_CACHE_GLOBAL_WORKFLOWS_KEY = "com.comalatech.workflow.cache.global.workflows";
    private static final String CONFIG_CACHE_GLOBAL_WORKFLOW_NAMES_KEY = "com.comalatech.workflow.cache.global.workflow.names";
    private static final String CONFIG_USER_SEARCH_MIN_CHARACTERS_KEY = "com.comalatech.workflow.user.search.min.characters";
    private static final String CONFIG_DATA_EXTRACTOR_BATCH_KEY = "com.comalatech.workflow.data.extractor.batch";
    private static final String CONFIG_EXPIRATION_JOB_BATCH_KEY = "com.comalatech.workflow.expiry.job.batch";
    private static final String CONFIG_MAX_HANDLED_USERS_KEY = "com.comalatech.workflow.max.handled.users";
    private static final String CONFIG_MAX_ALLOWED_APPROVERS_TO_SHOW_KEY = "com.comalatech.workflow.max.allowed.approvers.showed";
    private static final int DEFAULT_CACHE_PRODUCTION_WORKFLOWS = 500;
    private static final int DEFAULT_CACHE_GLOBAL_WORKFLOWS = 50;
    private static final int DEFAULT_CACHE_GLOBAL_WORKFLOW_NAMES = 50;
    private static final int DEFAULT_USER_SEARCH_MIN_CHARACTERS = 2;
    private static final int DEFAULT_DATA_EXTRACTOR_BATCH_KEY = 100;
    private static final int DEFAULT_EXPIRATION_JOB_BATCH_KEY = 100;
    private static final int DEFAULT_MAX_HANDLED_USERS_KEY = 500;
    private static final int DEFAULT_MAX_ALLOWED_APPROVERS_TO_SHOW_KEY = 15;
    private static boolean userSearchMinQueryPropChecked = false;
    private final String MIN_QUERY_SYS_PROP = "comalatech.workflow.approval.minquery";
    private static final String CONFIG_USER_SEARCH_MIN_CHARACTERS_SYS_PROP_SET = "com.comalatech.workflow.user.search.min.characters.sysprop.set";
    private final BandanaManager bandanaManager;
    private final BandanaContext bandanaContext = ComalatechBandanaContext.COMALATECH_CONTEXT;

    public WorkflowAdvancedConfigurationManager(BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
    }

    public int getCacheProductionWorkflows() {
        Integer cacheProductionWorkflows = (Integer)this.bandanaManager.getValue(this.bandanaContext, CONFIG_CACHE_PRODUCTION_WORKFLOWS_KEY);
        return cacheProductionWorkflows != null ? cacheProductionWorkflows : 500;
    }

    public void setCacheProductionWorkflows(int cacheProductionWorkflows) {
        this.bandanaManager.setValue(this.bandanaContext, CONFIG_CACHE_PRODUCTION_WORKFLOWS_KEY, (Object)cacheProductionWorkflows);
        if (log.isDebugEnabled()) {
            log.debug("Production workflows cache config saved : " + cacheProductionWorkflows);
        }
    }

    public int getCacheGlobalWorkflows() {
        Integer cacheGlobalWorkflows = (Integer)this.bandanaManager.getValue(this.bandanaContext, CONFIG_CACHE_GLOBAL_WORKFLOWS_KEY);
        return cacheGlobalWorkflows != null ? cacheGlobalWorkflows : 50;
    }

    public void setCacheGlobalWorkflows(int cacheGlobalWorkflows) {
        this.bandanaManager.setValue(this.bandanaContext, CONFIG_CACHE_GLOBAL_WORKFLOWS_KEY, (Object)cacheGlobalWorkflows);
        if (log.isDebugEnabled()) {
            log.debug("Global workflows cache config saved : " + cacheGlobalWorkflows);
        }
    }

    public int getCacheGlobalWorkflowNames() {
        Integer cacheGlobalWorkflowNames = (Integer)this.bandanaManager.getValue(this.bandanaContext, CONFIG_CACHE_GLOBAL_WORKFLOW_NAMES_KEY);
        return cacheGlobalWorkflowNames != null ? cacheGlobalWorkflowNames : 50;
    }

    public void setCacheGlobalWorkflowNames(int cacheGlobalWorkflowNames) {
        this.bandanaManager.setValue(this.bandanaContext, CONFIG_CACHE_GLOBAL_WORKFLOW_NAMES_KEY, (Object)cacheGlobalWorkflowNames);
        if (log.isDebugEnabled()) {
            log.debug("Global workflow names cache config saved : " + cacheGlobalWorkflowNames);
        }
    }

    public int getUserSearchMinCharacters() {
        Integer userSearchMinCharacters;
        if (!userSearchMinQueryPropChecked && !this.getMinQuerySysPropChecked()) {
            if (System.getProperty("comalatech.workflow.approval.minquery") != null) {
                try {
                    String queryMinSysPropVal = System.getProperty("comalatech.workflow.approval.minquery");
                    if (log.isDebugEnabled()) {
                        log.debug("Minimum query length system property value is: " + (queryMinSysPropVal != null ? queryMinSysPropVal : "null"));
                    }
                    this.setUserSearchMinCharacters(Integer.parseInt(queryMinSysPropVal));
                }
                catch (NumberFormatException nfe) {
                    log.error("Error parsing comalatech.workflow.approval.minquery property.", (Throwable)nfe);
                }
            }
            this.setMinQuerySysPropChecked();
        }
        return (userSearchMinCharacters = (Integer)this.bandanaManager.getValue(this.bandanaContext, CONFIG_USER_SEARCH_MIN_CHARACTERS_KEY)) != null && userSearchMinCharacters > 2 ? userSearchMinCharacters : 2;
    }

    public void setUserSearchMinCharacters(int userSearchMinCharacters) {
        this.bandanaManager.setValue(this.bandanaContext, CONFIG_USER_SEARCH_MIN_CHARACTERS_KEY, (Object)userSearchMinCharacters);
        if (log.isDebugEnabled()) {
            log.debug("User search minimum character value saved : " + userSearchMinCharacters);
        }
    }

    public int getDataExtractorBatchSize() {
        Integer dataExtractorBatchSize = (Integer)this.bandanaManager.getValue(this.bandanaContext, CONFIG_DATA_EXTRACTOR_BATCH_KEY);
        return dataExtractorBatchSize != null ? dataExtractorBatchSize : 100;
    }

    public int getExpirationJobBatchSize() {
        Integer expirationJobBatchSize = (Integer)this.bandanaManager.getValue(this.bandanaContext, CONFIG_EXPIRATION_JOB_BATCH_KEY);
        return expirationJobBatchSize != null ? expirationJobBatchSize : 100;
    }

    public void setDataExtractorBatchSize(int dataExtractorBatchSize) {
        this.bandanaManager.setValue(this.bandanaContext, CONFIG_DATA_EXTRACTOR_BATCH_KEY, (Object)dataExtractorBatchSize);
        if (log.isDebugEnabled()) {
            log.debug("Data Extractor Batch size config saved : " + dataExtractorBatchSize);
        }
    }

    public void setExpirationJobBatchSize(int expirationJobBatchSize) {
        this.bandanaManager.setValue(this.bandanaContext, CONFIG_EXPIRATION_JOB_BATCH_KEY, (Object)expirationJobBatchSize);
        if (log.isDebugEnabled()) {
            log.debug("Data Extractor Batch size config saved : " + expirationJobBatchSize);
        }
    }

    public int getMaxHandledUsers() {
        Integer maxHandledUsers = (Integer)this.bandanaManager.getValue(this.bandanaContext, CONFIG_MAX_HANDLED_USERS_KEY);
        return maxHandledUsers != null ? maxHandledUsers : 500;
    }

    public void setMaxHandledUsers(int maxHandledUsers) {
        this.bandanaManager.setValue(this.bandanaContext, CONFIG_MAX_HANDLED_USERS_KEY, (Object)maxHandledUsers);
        if (log.isDebugEnabled()) {
            log.debug("Max Handled Users config saved : " + maxHandledUsers);
        }
    }

    public int getMaxAllowedApproversToShow() {
        Integer maxAllowedApprovers = (Integer)this.bandanaManager.getValue(this.bandanaContext, CONFIG_MAX_ALLOWED_APPROVERS_TO_SHOW_KEY);
        return maxAllowedApprovers != null ? maxAllowedApprovers : 15;
    }

    public void setMaxAllowedApproversToShow(int maxAllowedApproversToShow) {
        this.bandanaManager.setValue(this.bandanaContext, CONFIG_MAX_ALLOWED_APPROVERS_TO_SHOW_KEY, (Object)maxAllowedApproversToShow);
        if (log.isDebugEnabled()) {
            log.debug("Max Allowed Approvers to show config saved : " + maxAllowedApproversToShow);
        }
    }

    private boolean getMinQuerySysPropChecked() {
        Object obj = this.bandanaManager.getValue(this.bandanaContext, CONFIG_USER_SEARCH_MIN_CHARACTERS_SYS_PROP_SET);
        if (obj != null) {
            return (Boolean)obj;
        }
        return false;
    }

    private void setMinQuerySysPropChecked() {
        this.bandanaManager.setValue(this.bandanaContext, CONFIG_USER_SEARCH_MIN_CHARACTERS_SYS_PROP_SET, (Object)true);
        userSearchMinQueryPropChecked = true;
    }
}

