/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.timers;

import com.atlassian.confluence.core.FormatSettingsManager;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.User;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang3.StringEscapeUtils;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISOPeriodFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimerUtils {
    private static final Logger log = LoggerFactory.getLogger(TimerUtils.class);
    private static final int PERIOD_DAYS = 0;
    private static final int PERIOD_MINUTES = 1;
    private static final int PERIOD_HOURS = 2;
    private static final int PERIOD_MONTHS = 3;
    private static final int PERIOD_YEARS = 4;
    private static final String[] PERIOD_NAMES = new String[]{"days", "minutes", "hours", "months", "years"};
    private static final String[] PERIOD_KEYS = new String[]{"D", "M", "H", "M", "Y"};
    private static final String[] PERIOD_PREFIXES = new String[]{"", "T", "T", "", ""};
    private static final String DEFAULT_FORMAT_PATTERN = "dd/MM/yyyy";
    private static final String ALT_FORMAT1_PATTERN = "YYYY/MM/dd";
    private static final String ALT_FORMAT2_PATTERN = "dd.MM.YYYY";
    private static final String ALT_FORMAT3_PATTERN = "YYYY-MM-dd HH:mm";
    private static final String ALT_FORMAT4_PATTERN = "YYYY-MM-dd HH:mm:ss";
    private static final String YEAR_MONTH_DAY_FORMAT = "YYYY-MM-dd";
    private static final String MONTH_DAY_YEAR_FORMAT = "MMM dd, YYYY";
    public static final DateTimeFormatter DEFAULT_FORMAT = DateTimeFormat.forPattern("dd/MM/yyyy");
    public static final DateTimeFormatter ALT_FORMAT1 = DateTimeFormat.forPattern("YYYY/MM/dd");
    public static final DateTimeFormatter ALT_FORMAT2 = DateTimeFormat.forPattern("dd.MM.YYYY");
    public static final DateTimeFormatter ALT_FORMAT3 = DateTimeFormat.forPattern("YYYY-MM-dd HH:mm");
    public static final DateTimeFormatter ALT_FORMAT4 = DateTimeFormat.forPattern("YYYY-MM-dd HH:mm:ss");
    public static final DateTimeFormatter MONTH_DAY_YEAR_FORMATTER = DateTimeFormat.forPattern("MMM dd, YYYY");
    public static final DateTimeFormatter YEAR_MONTH_DAY_FORMATTER = DateTimeFormat.forPattern("YYYY-MM-dd");
    private static final DateTimeFormatter LOG_FORMATTER = DateTimeFormat.forPattern("YYYY-MM-dd HH:mm:ss,SSS");

    public static Period parsePeriod(String period) throws IllegalArgumentException {
        return TimerUtils.parsePeriod(period, DateTime.now());
    }

    public static Period parsePeriod(String period, DateTime baseDateTime) throws IllegalArgumentException {
        Date concreteDueDate;
        if (baseDateTime == null) {
            baseDateTime = DateTime.now();
        }
        Period result = (concreteDueDate = TimerUtils.parseDateMultipleFormats(period)) != null ? new Period((ReadableInstant)baseDateTime, (ReadableInstant)new DateTime(concreteDueDate)) : ISOPeriodFormat.standard().parsePeriod(period);
        return result;
    }

    public static Period parsePeriod(int count, String periodName) {
        if (count == 0) {
            return null;
        }
        int ix = 0;
        for (String name : PERIOD_NAMES) {
            if (name.equalsIgnoreCase(periodName)) break;
            ++ix;
        }
        if (ix == PERIOD_NAMES.length) {
            ix = 0;
        }
        StringBuilder sb = new StringBuilder("P");
        sb.append(PERIOD_PREFIXES[ix]).append(count).append(PERIOD_KEYS[ix]);
        try {
            return TimerUtils.parsePeriod(sb.toString());
        }
        catch (Exception e) {
            throw new RuntimeException("error parting period");
        }
    }

    public static String dateToString(Date date) {
        return DEFAULT_FORMAT.print(date.getTime());
    }

    public static Date parseDateMultipleFormats(String date) {
        try {
            return DEFAULT_FORMAT.parseDateTime(date.replaceAll("-", "/")).toDate();
        }
        catch (Exception e) {
            try {
                return MONTH_DAY_YEAR_FORMATTER.withLocale(TimerUtils.getLocale()).parseDateTime(StringEscapeUtils.unescapeHtml4((String)date)).toDate();
            }
            catch (Exception e2) {
                try {
                    return ALT_FORMAT1.parseDateTime(date).toDate();
                }
                catch (Exception e3) {
                    try {
                        return YEAR_MONTH_DAY_FORMATTER.parseDateTime(date).toDate();
                    }
                    catch (Exception e4) {
                        try {
                            return ALT_FORMAT3.parseDateTime(date).toDate();
                        }
                        catch (Exception e5) {
                            try {
                                return ALT_FORMAT4.parseDateTime(date).toDate();
                            }
                            catch (Exception e6) {
                                try {
                                    return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S z").parse(date);
                                }
                                catch (Exception e7) {
                                    try {
                                        return ALT_FORMAT2.parseDateTime(date).toDate();
                                    }
                                    catch (Exception e8) {
                                        return null;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public static String periodToString(Period period) {
        return ISOPeriodFormat.standard().print(period);
    }

    public static SimpleDuration periodToDuration(Period period) {
        return TimerUtils.periodToDuration(period, DateTime.now());
    }

    public static SimpleDuration periodToDuration(Period period, DateTime pivotDate) {
        SimpleDuration result;
        Duration duration = period.toDurationFrom(pivotDate);
        duration = TimerUtils.getDurationWithDaylightSavingsTimeOffset(duration, pivotDate, period);
        if (period.getMinutes() != 0) {
            result = new SimpleDuration((int)duration.getStandardMinutes(), PERIOD_NAMES[1]);
        } else if (period.getHours() != 0) {
            result = new SimpleDuration((int)duration.getStandardHours(), PERIOD_NAMES[2]);
        } else if (period.getDays() != 0) {
            result = duration.getStandardHours() % 24L == 0L ? new SimpleDuration((int)duration.getStandardDays(), PERIOD_NAMES[0]) : new SimpleDuration((int)duration.getStandardHours(), PERIOD_NAMES[2]);
        } else if (period.getMonths() != 0) {
            if (duration.getStandardHours() % 24L == 0L) {
                int months = period.getMonths() + period.getYears() * 12;
                result = new SimpleDuration(months, PERIOD_NAMES[3]);
            } else {
                result = new SimpleDuration((int)duration.getStandardHours(), PERIOD_NAMES[2]);
            }
        } else {
            result = period.getYears() != 0 ? new SimpleDuration(period.getYears(), PERIOD_NAMES[4]) : new SimpleDuration(0, PERIOD_NAMES[0]);
        }
        return result;
    }

    public static Duration getDurationWithDaylightSavingsTimeOffset(Duration duration, DateTime pivotDate, Period period) {
        if (TimerUtils.isPeriodLessThanDays(period)) {
            return duration;
        }
        if (TimerUtils.isDurationBetweenDaylightSavingsTimeStart(duration, pivotDate)) {
            return duration.plus(Duration.standardHours(1L));
        }
        if (TimerUtils.isDurationBetweenDaylightSavingsTimeEnd(duration, pivotDate)) {
            return duration.minus(Duration.standardHours(1L));
        }
        return duration;
    }

    public static boolean isPeriodLessThanDays(Period period) {
        return period.getYears() == 0 && period.getMonths() == 0 && period.getWeeks() == 0 && period.getDays() == 0;
    }

    public static boolean isDurationBetweenDaylightSavingsTimeStart(Duration duration, DateTime pivotDate) {
        DateTime endDateTime = pivotDate.plus(duration);
        return !TimerUtils.isDateTimeOnDaylightSavings(pivotDate) && TimerUtils.isDateTimeOnDaylightSavings(endDateTime);
    }

    public static boolean isPeriodBetweenDaylightSavingsTimeStart(Period period, DateTime pivotDate) {
        Duration duration = period.toDurationFrom(pivotDate);
        return TimerUtils.isDurationBetweenDaylightSavingsTimeStart(duration, pivotDate);
    }

    public static boolean isDurationBetweenDaylightSavingsTimeEnd(Duration duration, DateTime pivotDate) {
        DateTime endDateTime = pivotDate.plus(duration);
        return TimerUtils.isDateTimeOnDaylightSavings(pivotDate) && !TimerUtils.isDateTimeOnDaylightSavings(endDateTime);
    }

    public static boolean isPeriodBetweenDaylightSavingsTimeEnd(Period period, DateTime pivotDate) {
        Duration duration = period.toDurationFrom(pivotDate);
        return TimerUtils.isDurationBetweenDaylightSavingsTimeEnd(duration, pivotDate);
    }

    public static boolean isDateTimeOnDaylightSavings(DateTime dateTime) {
        return TimerUtils.isDateTimeOnDaylightSavings(dateTime, TimeZone.getDefault());
    }

    public static boolean isDateTimeOnDaylightSavings(DateTime dateTime, TimeZone timeZone) {
        return timeZone.inDaylightTime(dateTime.toDate());
    }

    public static SimpleDateFormat getFormatter() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S z");
    }

    public static SimpleDateFormat getFormatterNoTimeZone() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
    }

    public static Date parseDate(String value) throws ParseException {
        try {
            return TimerUtils.getFormatter().parse(value);
        }
        catch (ParseException e) {
            int ix = value.lastIndexOf(" ");
            if (ix > 0 && ix < value.length() - 1) {
                Date date = TimerUtils.getFormatterNoTimeZone().parse(value.substring(0, ix));
                if (log.isDebugEnabled()) {
                    log.debug("ignoring timezone " + value.substring(ix));
                }
                return date;
            }
            throw e;
        }
    }

    public static String logDate(Date date) {
        return LOG_FORMATTER.print(new DateTime(date));
    }

    public static boolean isDateExpired(Long timestamp) {
        DateTime now = DateTime.now();
        return now.getMillis() > timestamp;
    }

    public static String parseDateWithConfluenceDateFormat(Date date) {
        return new DateTime(date).toString(DateTimeFormat.forPattern(TimerUtils.getFormatSettingsManager().getDateFormat()).withLocale(TimerUtils.getLocale()));
    }

    public static String parseDateWithConfluenceDateTimeFormat(Date date) {
        return new DateTime(date).toString(DateTimeFormat.forPattern(TimerUtils.getFormatSettingsManager().getDateTimeFormat()).withLocale(TimerUtils.getLocale()));
    }

    public static String getDuration(Instant startingInstant) {
        String duration = "";
        java.time.Duration period = java.time.Duration.between(startingInstant, Instant.now());
        if (period.toDays() != 0L) {
            duration = duration + period.toDays() + "d ";
            period = period.minusDays(period.toDays());
        }
        if (period.toHours() != 0L) {
            duration = duration + period.toHours() + "h ";
            period = period.minusHours(period.toHours());
        }
        if (period.toMinutes() != 0L) {
            duration = duration + period.toMinutes() + "m ";
            period = period.minusMinutes(period.toMinutes());
        }
        duration = period.getSeconds() != 0L ? duration + period.getSeconds() + "s" : duration + "1s";
        return duration;
    }

    private static Locale getLocale() {
        return TimerUtils.getLocaleManager().getLocale((User)AuthenticatedUserThreadLocal.get());
    }

    private static LocaleManager getLocaleManager() {
        return (LocaleManager)ContainerManager.getComponent((String)"localeManager");
    }

    private static FormatSettingsManager getFormatSettingsManager() {
        return (FormatSettingsManager)ContainerManager.getComponent((String)"formatSettingsManager");
    }

    public static class SimpleDuration {
        final int count;
        final String periodName;

        public SimpleDuration(int count, String periodName) {
            this.count = count;
            this.periodName = periodName;
        }

        public int getCount() {
            return this.count;
        }

        public String getPeriodName() {
            return this.periodName;
        }
    }
}

