/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.upgrade.resources.model;

import com.comalatech.confluence.documentActivity.upgrade.entity.domain.SpaceUpgrade;
import com.comalatech.confluence.documentActivity.upgrade.resources.model.RestPreCheck;
import org.codehaus.jackson.annotate.JsonAutoDetect;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class RestSpaceUpgrade {
    private String name;
    private String key;
    private String home;
    private long numPagesWithHistory;
    private long totalPages;
    private RestPreCheck preCheck;

    public RestSpaceUpgrade() {
    }

    public RestSpaceUpgrade(SpaceUpgrade spaceUpgrade) {
        this.setName(spaceUpgrade.getSpace().getName());
        this.setKey(spaceUpgrade.getSpace().getKey());
        this.setHome(spaceUpgrade.getSpace().getHomePage() != null ? spaceUpgrade.getSpace().getHomePage().getUrlPath() : spaceUpgrade.getSpace().getBrowseUrlPath());
        this.setNumPagesWithHistory(spaceUpgrade.getTotalPagesWithActivity());
        this.setTotalPages(spaceUpgrade.getTotalPages());
        this.setPreCheck(new RestPreCheck(spaceUpgrade.getPreCheck()));
    }

    public String getName() {
        return this.name;
    }

    public String getKey() {
        return this.key;
    }

    public String getHome() {
        return this.home;
    }

    public long getNumPagesWithHistory() {
        return this.numPagesWithHistory;
    }

    public long getTotalPages() {
        return this.totalPages;
    }

    public RestPreCheck getPreCheck() {
        return this.preCheck;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setHome(String home) {
        this.home = home;
    }

    public void setNumPagesWithHistory(long numPagesWithHistory) {
        this.numPagesWithHistory = numPagesWithHistory;
    }

    public void setTotalPages(long totalPages) {
        this.totalPages = totalPages;
    }

    public void setPreCheck(RestPreCheck preCheck) {
        this.preCheck = preCheck;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RestSpaceUpgrade)) {
            return false;
        }
        RestSpaceUpgrade other = (RestSpaceUpgrade)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$home = this.getHome();
        String other$home = other.getHome();
        if (this$home == null ? other$home != null : !this$home.equals(other$home)) {
            return false;
        }
        if (this.getNumPagesWithHistory() != other.getNumPagesWithHistory()) {
            return false;
        }
        if (this.getTotalPages() != other.getTotalPages()) {
            return false;
        }
        RestPreCheck this$preCheck = this.getPreCheck();
        RestPreCheck other$preCheck = other.getPreCheck();
        return !(this$preCheck == null ? other$preCheck != null : !((Object)this$preCheck).equals(other$preCheck));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RestSpaceUpgrade;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $home = this.getHome();
        result = result * 59 + ($home == null ? 43 : $home.hashCode());
        long $numPagesWithHistory = this.getNumPagesWithHistory();
        result = result * 59 + (int)($numPagesWithHistory >>> 32 ^ $numPagesWithHistory);
        long $totalPages = this.getTotalPages();
        result = result * 59 + (int)($totalPages >>> 32 ^ $totalPages);
        RestPreCheck $preCheck = this.getPreCheck();
        result = result * 59 + ($preCheck == null ? 43 : ((Object)$preCheck).hashCode());
        return result;
    }

    public String toString() {
        return "RestSpaceUpgrade(name=" + this.getName() + ", key=" + this.getKey() + ", home=" + this.getHome() + ", numPagesWithHistory=" + this.getNumPagesWithHistory() + ", totalPages=" + this.getTotalPages() + ", preCheck=" + this.getPreCheck() + ")";
    }
}

