/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.upgrade.resources;

import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.comalatech.confluence.documentActivity.upgrade.entity.domain.PreCheck;
import com.comalatech.confluence.documentActivity.upgrade.entity.domain.PreCheckStatus;
import com.comalatech.confluence.documentActivity.upgrade.entity.domain.SpaceUpgrade;
import com.comalatech.confluence.documentActivity.upgrade.entity.domain.Upgrade;
import com.comalatech.confluence.documentActivity.upgrade.entity.domain.UpgradeMetadata;
import com.comalatech.confluence.documentActivity.upgrade.manager.SpaceUpgradeManager;
import com.comalatech.confluence.documentActivity.upgrade.resources.AbstractSpaceUpgradeResource;
import com.comalatech.confluence.documentActivity.upgrade.resources.model.RestPreCheck;
import com.comalatech.confluence.documentActivity.upgrade.resources.model.RestSpacePreCheckRunResponse;
import com.comalatech.confluence.documentActivity.upgrade.resources.model.RestSpaceUpgrade;
import com.comalatech.confluence.documentActivity.upgrade.resources.model.RestUpgradeMetadata;
import com.comalatech.confluence.documentActivity.upgrade.resources.model.RestUpgradeResponse;
import com.comalatech.confluence.documentActivity.upgrade.service.DocumentActivityUpgradeService;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.workflow.rest.model.PermissionRequired;
import com.webcohesion.enunciate.metadata.rs.ResponseCode;
import com.webcohesion.enunciate.metadata.rs.StatusCodes;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/documentactivity/upgrade")
public class SpaceUpgradeResource
extends AbstractSpaceUpgradeResource {
    private static final Logger log = LoggerFactory.getLogger(SpaceUpgradeResource.class);
    private final DocumentActivityUpgradeService documentActivityUpgradeService;
    private final SpaceUpgradeManager spaceUpgradeManager;

    public SpaceUpgradeResource(DocumentActivityUpgradeService documentActivityUpgradeService, WorkflowsFeatureManager workflowsFeatureManager, PermissionManager permissionManager, SpaceManager spaceManager, SpaceUpgradeManager spaceUpgradeManager) {
        super(permissionManager, spaceManager, workflowsFeatureManager);
        this.documentActivityUpgradeService = documentActivityUpgradeService;
        this.spaceUpgradeManager = spaceUpgradeManager;
    }

    @GET
    @Path(value="/report")
    @PermissionRequired(value={"ADMINISTER"})
    @Produces(value={"application/json"})
    public Response getUpgradesReport() {
        return new AbstractSpaceUpgradeResource.RestCommand(){

            @Override
            public Response doExecute() {
                try {
                    return Response.ok().entity((Object)SpaceUpgradeResource.this.buildUpgradeResponse(SpaceUpgradeResource.this.documentActivityUpgradeService.getUpgradeData())).type("application/json").build();
                }
                catch (Exception e) {
                    log.error("Unable to retrieve space upgrade report.", (Throwable)e);
                    JSONObject error = new JSONObject();
                    error.put("status", Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
                    error.put("message", ConfluenceActionSupport.getTextStatic((String)"comalatech.upgrade.checks.reporting.error"));
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error.toString()).type("application/json").build();
                }
            }
        }.execute();
    }

    @GET
    @Path(value="/prechecks/{spaceKey}")
    @PermissionRequired(value={"ADMINISTER"})
    @Produces(value={"application/json"})
    public Response getSpacePreCheckStatus(@PathParam(value="spaceKey") String spaceKey) {
        return new AbstractSpaceUpgradeResource.RestSpaceCommand(spaceKey){

            @Override
            public Response doExecute() {
                try {
                    Space space = (Space)this.getValidationTarget();
                    PreCheck preCheck = SpaceUpgradeResource.this.documentActivityUpgradeService.getSpacePreCheck(space);
                    return Response.ok().entity((Object)SpaceUpgradeResource.this.buildPreCheckResponse(space, preCheck)).type("application/json").build();
                }
                catch (Exception e) {
                    log.error("Unable to retrieve the space pre-check status.", (Throwable)e);
                    JSONObject error = new JSONObject();
                    error.put("status", Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
                    error.put("message", ConfluenceActionSupport.getTextStatic((String)"comalatech.upgrade.checks.reporting.error"));
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error.toString()).type("application/json").build();
                }
            }
        }.execute();
    }

    @POST
    @Path(value="/prechecks")
    @PermissionRequired(value={"ADMINISTER"})
    @ReadOnlyAccessAllowed
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response runSpacePreCheck(final List<String> spaceKeys) {
        return new AbstractSpaceUpgradeResource.RestCommand(){

            @Override
            public Response doExecute() {
                try {
                    if (spaceKeys == null || spaceKeys.isEmpty()) {
                        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                    }
                    ArrayList<Space> spaces = new ArrayList<Space>();
                    for (String key : spaceKeys) {
                        Space space2 = SpaceUpgradeResource.this.spaceManager.getSpace(key);
                        if (space2 == null) {
                            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("The space key " + key + " does not exist")).build();
                        }
                        spaces.add(space2);
                    }
                    ArrayList preChecks = new ArrayList();
                    spaces.forEach(space -> {
                        RestPreCheck restPreCheck = SpaceUpgradeResource.this.buildPreCheckResponse(space, SpaceUpgradeResource.this.spaceUpgradeManager.launchSpacePreCheckTask((Space)space));
                        preChecks.add(restPreCheck);
                    });
                    return Response.ok().entity((Object)SpaceUpgradeResource.this.buildPreChecksRunResponse(preChecks)).type("application/json").build();
                }
                catch (Exception ex) {
                    log.error("Unable to run the space pre-check task.", (Throwable)ex);
                    JSONObject error = new JSONObject();
                    error.put("status", Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
                    error.put("message", ConfluenceActionSupport.getTextStatic((String)"comalatech.upgrade.checks.reporting.error"));
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error.toString()).type("application/json").build();
                }
            }
        }.execute();
    }

    @POST
    @Path(value="/prechecks/cancel/{spaceKey}")
    @PermissionRequired(value={"ADMINISTER"})
    @ReadOnlyAccessAllowed
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response cancelSpacePreCheck(@PathParam(value="spaceKey") String spaceKey) {
        return new AbstractSpaceUpgradeResource.RestSpaceCommand(spaceKey){

            @Override
            public Response doExecute() {
                try {
                    Space space = (Space)this.getValidationTarget();
                    PreCheck preCheck = SpaceUpgradeResource.this.documentActivityUpgradeService.getSpacePreCheck(space);
                    if (PreCheckStatus.IN_PROGRESS.equals((Object)preCheck.getStatus())) {
                        SpaceUpgradeResource.this.spaceUpgradeManager.cancelSpacePreCheckTask(space);
                        return Response.ok().build();
                    }
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
                }
                catch (Exception e) {
                    log.error("Unable to cancel the space pre-check status.", (Throwable)e);
                    JSONObject error = new JSONObject();
                    error.put("status", Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
                    error.put("message", ConfluenceActionSupport.getTextStatic((String)"comalatech.upgrade.checks.reporting.error"));
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error.toString()).type("application/json").build();
                }
            }
        }.execute();
    }

    @GET
    @Path(value="/support/{spaceKey}")
    @PermissionRequired(value={"ADMINISTER"})
    @Produces(value={"application/octet-stream"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Support file is generated and returned"), @ResponseCode(code=400, condition="Space key is null or does not exist"), @ResponseCode(code=403, condition="User is not administrator"), @ResponseCode(code=404, condition="No support package content"), @ResponseCode(code=500, condition="Cannot generate support data")})
    public Response getSupportFile(final @PathParam(value="spaceKey") String spaceKey) {
        return new AbstractSpaceUpgradeResource.RestCommand(){

            @Override
            public Response doExecute() {
                try {
                    if (spaceKey == null) {
                        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                    }
                    Space space = SpaceUpgradeResource.this.spaceManager.getSpace(spaceKey);
                    if (space == null) {
                        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("The space key " + spaceKey + " does not exist")).build();
                    }
                    java.nio.file.Path supportFile = SpaceUpgradeResource.this.documentActivityUpgradeService.getSupportFile(space);
                    StreamingOutput stream = outputStream -> Files.copy(supportFile, outputStream);
                    return Response.ok((Object)stream, (String)"application/octet-stream").header("Content-Length", (Object)String.valueOf(Files.size(supportFile))).header("Content-Disposition", (Object)("attachment; filename=" + supportFile.getFileName().toString())).build();
                }
                catch (NoSuchFileException e) {
                    log.error(e.getMessage(), (Throwable)e);
                    JSONObject error = new JSONObject();
                    error.put("status", Response.Status.NOT_FOUND.getStatusCode());
                    error.put("message", ConfluenceActionSupport.getTextStatic((String)"comalatech.awp.global.workflows.upgrade.checks.reporting.support.error"));
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)error.toString()).type("application/json").build();
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    JSONObject error = new JSONObject();
                    error.put("status", Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
                    error.put("message", e.getMessage() != null ? e.getMessage() : "Internal server error");
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error.toString()).type("application/json").build();
                }
            }
        }.execute();
    }

    private RestSpacePreCheckRunResponse buildPreChecksRunResponse(List<RestPreCheck> preChecks) {
        RestSpacePreCheckRunResponse restSpacePreCheckRunResponse = new RestSpacePreCheckRunResponse();
        restSpacePreCheckRunResponse.setPreChecks(preChecks);
        return restSpacePreCheckRunResponse;
    }

    private RestPreCheck buildPreCheckResponse(Space space, PreCheck preCheck) {
        RestPreCheck restPreCheck = new RestPreCheck(preCheck);
        restPreCheck.setSpaceKey(space.getKey());
        return restPreCheck;
    }

    private RestUpgradeResponse buildUpgradeResponse(Upgrade upgradeData) {
        RestUpgradeResponse response = new RestUpgradeResponse();
        ArrayList<RestSpaceUpgrade> restSpaceUpgrades = new ArrayList<RestSpaceUpgrade>();
        if (upgradeData != null) {
            List<SpaceUpgrade> spaceUpgrades = upgradeData.getSpaceUpgrades();
            for (SpaceUpgrade spaceUpgrade : spaceUpgrades) {
                RestSpaceUpgrade restSpaceUpgrade = new RestSpaceUpgrade(spaceUpgrade);
                restSpaceUpgrades.add(restSpaceUpgrade);
            }
            response.setRestUpgradeMetadata(this.buildUpgradeMetadata(upgradeData.getUpgradeMetadata()));
        }
        response.setRestSpaceUpgradeList(restSpaceUpgrades);
        return response;
    }

    private RestUpgradeMetadata buildUpgradeMetadata(UpgradeMetadata upgradeMetadata) {
        RestUpgradeMetadata restUpgradeMetadata = new RestUpgradeMetadata();
        if (upgradeMetadata != null) {
            restUpgradeMetadata.setHighestNumPagesWithWorkflowPerSpace(upgradeMetadata.getHighestNumPagesWithWorkflowPerSpace());
            restUpgradeMetadata.setMedianPagesWithWorkflowPerSpace(upgradeMetadata.getMedianPagesWithWorkflowPerSpace());
            restUpgradeMetadata.setTotalSpaces(upgradeMetadata.getTotalSpaces());
            restUpgradeMetadata.setTotalUpgradeSpacesChecked(upgradeMetadata.getTotalUpgradeSpacesChecked());
            restUpgradeMetadata.setTotalSpacesWithHistory(upgradeMetadata.getTotalSpacesWithHistory());
            restUpgradeMetadata.setTotalPagesWithHistory(upgradeMetadata.getTotalPagesWithHistory());
            restUpgradeMetadata.setTotalDocActivityEntries(upgradeMetadata.getTotalDocActivityEntries());
        }
        return restUpgradeMetadata;
    }
}

