/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.usecases;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPermissionManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.comalatech.confluence.cloud.migration.entity.domain.migration.Migration;
import com.comalatech.confluence.cloud.migration.entity.domain.migration.MigrationEntity;
import com.comalatech.confluence.cloud.migration.entity.domain.migration.MigrationRestrictedEntity;
import com.comalatech.confluence.cloud.migration.support.commands.RestrictedContentCSV;
import com.comalatech.confluence.cloud.migration.support.commands.RestrictedContentJSON;
import com.comalatech.confluence.cloud.migration.support.model.RestrictedContentCSVData;
import com.comalatech.confluence.cloud.migration.support.model.RestrictedContentJSONData;
import com.comalatech.confluence.cloud.migration.usecases.contracts.CloudMappingsData;
import com.comalatech.confluence.cloud.migration.usecases.contracts.CloudPopulationData;
import com.comalatech.confluence.cloud.migration.usecases.contracts.GenerateCloudMappings;
import com.comalatech.confluence.cloud.migration.usecases.contracts.Presenter;
import com.comalatech.confluence.cloud.migration.usecases.infrastructure.MigrationNamesSpaces;
import com.comalatech.confluence.cloud.migration.usecases.mappers.ActivityMapper;
import com.comalatech.confluence.cloud.migration.utils.MigrationPackageFile;
import com.comalatech.confluence.documentActivity.domain.entities.Activity;
import com.comalatech.confluence.documentActivity.domain.entities.Actor;
import com.comalatech.confluence.workflow.supportconsole.infrastructure.contract.SupportPresenter;
import com.comalatech.confluence.workflowreports.pageactivity.PageActivityEntryProcessor;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

public class GenerateCloudMappingsUseCase
implements GenerateCloudMappings {
    private static final Logger log = LoggerFactory.getLogger(GenerateCloudMappingsUseCase.class);
    private final PageManager pageManager;
    private final CloudPopulationData userPopulationData;
    private final CloudPopulationData contentPopulationData;
    private final CloudMappingsData cloudMappingsData;
    private final Presenter<String> jsonPresenter;
    private final ContentPermissionManager contentPermissionManager;
    private ActivityMapper activityMapper;
    private static final String BLOGS = "blog";
    private static final String PAGES = "pages";
    private static final String USERS = "users";
    private final RestrictedContentCSV restrictedContentCSV;
    private final RestrictedContentJSON restrictedContentJSON;

    public GenerateCloudMappingsUseCase(@Qualifier(value="userCloudPopulationData") CloudPopulationData userPopulationData, @Qualifier(value="contentCloudPopulationData") CloudPopulationData contentPopulationData, CloudMappingsData cloudMappingsData, PageManager pageManager, SupportPresenter templateFileLayoutHelper, @Qualifier(value="jsonPresenter") Presenter<String> jsonPresenter, ContentPermissionManager contentPermissionManager) {
        this.userPopulationData = userPopulationData;
        this.contentPopulationData = contentPopulationData;
        this.cloudMappingsData = cloudMappingsData;
        this.pageManager = pageManager;
        this.jsonPresenter = jsonPresenter;
        this.contentPermissionManager = contentPermissionManager;
        this.activityMapper = new ActivityMapper();
        this.restrictedContentCSV = new RestrictedContentCSV(templateFileLayoutHelper);
        this.restrictedContentJSON = new RestrictedContentJSON(templateFileLayoutHelper);
    }

    @Override
    public Migration generateMigrationData(Map<AbstractPage, List<Activity>> pageActivities, String transferId) {
        Map<String, Set<String>> localIds = this.idExtractor(pageActivities);
        Map<String, String> userMapping = this.cloudMappingsData.getCloudMappings(transferId, MigrationNamesSpaces.USERS_KEY.toString(), localIds.get(USERS));
        Map<String, String> contentMapping = this.cloudMappingsData.getCloudMappings(transferId, MigrationNamesSpaces.CONFLUENCE_PAGES.toString(), localIds.get(PAGES));
        Map<String, String> blogPostMapping = this.cloudMappingsData.getCloudMappings(transferId, MigrationNamesSpaces.CONFLUENCE_BLOGPOST.toString(), localIds.get(BLOGS));
        contentMapping.putAll(blogPostMapping);
        Migration cloudMigration = new Migration();
        ArrayList<MigrationRestrictedEntity> restrictedEntities = new ArrayList<MigrationRestrictedEntity>();
        pageActivities.entrySet().parallelStream().forEach(longListEntry -> {
            Set migrationActivities = ((List)longListEntry.getValue()).parallelStream().map(activity -> this.activityMapper.map((Activity)activity)).map(migrationActivity -> this.contentPopulationData.populateCloudData((com.comalatech.confluence.cloud.migration.entity.domain.activity.Activity)migrationActivity, contentMapping)).map(migrationActivity -> this.userPopulationData.populateCloudData((com.comalatech.confluence.cloud.migration.entity.domain.activity.Activity)migrationActivity, userMapping)).collect(Collectors.toCollection(() -> new TreeSet<com.comalatech.confluence.cloud.migration.entity.domain.activity.Activity>(Comparator.comparing(com.comalatech.confluence.cloud.migration.entity.domain.activity.Activity::getMoment))));
            String cloudContentKey = (String)contentMapping.get(String.valueOf(((AbstractPage)longListEntry.getKey()).getId()));
            MigrationEntity migrationEntity = new MigrationEntity();
            migrationEntity.setActivities(migrationActivities);
            migrationEntity.setSpaceKey(((AbstractPage)longListEntry.getKey()).getSpaceKey());
            migrationEntity.setContentId(cloudContentKey);
            boolean isRestricted = this.checkContentRestrictions(((AbstractPage)longListEntry.getKey()).getId());
            migrationEntity.setRestricted(isRestricted);
            if (isRestricted) {
                restrictedEntities.add(new MigrationRestrictedEntity(((AbstractPage)longListEntry.getKey()).getId(), Long.valueOf(cloudContentKey), ((AbstractPage)longListEntry.getKey()).getSpaceKey()));
            }
            cloudMigration.migrationEntities.add(migrationEntity);
        });
        cloudMigration.totalNumberOfMigrationItems = cloudMigration.migrationEntities.size();
        if (!restrictedEntities.isEmpty()) {
            this.generateContentRestrictionsFiles(restrictedEntities, cloudMigration.migrationEntities);
        }
        return cloudMigration;
    }

    private Map<String, Set<String>> idExtractor(Map<AbstractPage, List<Activity>> pageActivities) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        HashSet<String> pagesID = new HashSet<String>();
        HashSet<String> blogPostID = new HashSet<String>();
        HashSet usersID = new HashSet();
        for (AbstractPage currentContent : pageActivities.keySet()) {
            if (currentContent instanceof Page) {
                pagesID.add(String.valueOf(currentContent.getId()));
            } else {
                blogPostID.add(String.valueOf(currentContent.getId()));
            }
            pageActivities.get(currentContent).forEach(act -> {
                for (Actor actor : act.getAction().getActors()) {
                    usersID.add((Object)((Object)MigrationNamesSpaces.USERS_KEY_PREFIX) + actor.getId());
                }
            });
        }
        result.put(PAGES, pagesID);
        result.put(BLOGS, blogPostID);
        result.put(USERS, usersID);
        return result;
    }

    private void generateContentRestrictionsFiles(List<MigrationRestrictedEntity> restrictedEntities, List<MigrationEntity> migrationEntities) {
        try {
            MigrationPackageFile.deleteDataBasePath();
        }
        catch (IOException ex) {
            log.error("Error deleting migration support package path", (Throwable)ex);
        }
        StringBuilder builder = new StringBuilder();
        builder.append("serverPageId,cloudPageId,spaceKey");
        builder.append(PageActivityEntryProcessor.LINE_SEPARATOR);
        restrictedEntities.forEach(elem -> {
            builder.append(elem.getContentServerId()).append(",").append(elem.getContentCloudId()).append(",").append(elem.getSpaceKey());
            builder.append(PageActivityEntryProcessor.LINE_SEPARATOR);
        });
        String csv = builder.substring(0, builder.length() - 1);
        List migrationRestrictedEntities = migrationEntities.stream().filter(elem -> elem.isRestricted()).collect(Collectors.toList());
        String migrationRestrictedEntitiesStr = this.jsonPresenter.present(migrationRestrictedEntities);
        try {
            Path path = MigrationPackageFile.generateMigrationFolder();
            this.restrictedContentCSV.generateSupportFile(RestrictedContentCSVData.builder().csv(csv).build(), path);
            this.restrictedContentJSON.generateSupportFile(RestrictedContentJSONData.builder().json(migrationRestrictedEntitiesStr).build(), path);
        }
        catch (Exception ex) {
            log.error("Error generating migration support package", (Throwable)ex);
        }
    }

    private boolean checkContentRestrictions(Long contentServerId) {
        boolean isRestricted = false;
        AbstractPage content = this.pageManager.getAbstractPage(Long.valueOf(contentServerId).longValue());
        if (content != null) {
            if (content.getContentPermissionSet("View") != null || content.getContentPermissionSet("Edit") != null) {
                isRestricted = true;
            } else {
                List inheritedPermissions = this.contentPermissionManager.getInheritedContentPermissionSets((ContentEntityObject)content);
                if (inheritedPermissions != null && inheritedPermissions.size() > 0) {
                    isRestricted = true;
                }
            }
        }
        return isRestricted;
    }
}

