/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.usecases;

import com.atlassian.migration.app.tracker.CloudMigrationAccessor;
import com.atlassian.migration.app.tracker.PaginatedMapping;
import com.comalatech.confluence.cloud.migration.usecases.accessor.LocalCloudMigrationAccessor;
import com.comalatech.confluence.cloud.migration.usecases.contracts.CloudMappingsData;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CloudMappingsDataRetrievalUseCase
implements CloudMappingsData {
    private final CloudMigrationAccessor accessor;

    public CloudMappingsDataRetrievalUseCase(LocalCloudMigrationAccessor accessor) {
        this.accessor = accessor.getCloudMigrationAccessor();
    }

    @Override
    public Map<String, String> getCloudMappings(String transferId, String namespace) {
        PaginatedMapping userMapping = this.accessor.getCloudMigrationGateway().getPaginatedMapping(transferId, namespace, 5000);
        userMapping.next();
        return userMapping.getMapping();
    }

    @Override
    public Map<String, String> getCloudMappings(String transferId, String namespace, Set<String> mappingIds) {
        int MAX_SIZE = 99;
        HashSet<String> batch = new HashSet<String>(99);
        HashMap<String, String> mappings = new HashMap<String, String>();
        for (String id : mappingIds) {
            batch.add(id);
            if (batch.size() != 99) continue;
            mappings.putAll(this.accessor.getCloudMigrationGateway().getMappingById(transferId, namespace, batch));
            batch = new HashSet(99);
        }
        if (!batch.isEmpty()) {
            mappings.putAll(this.accessor.getCloudMigrationGateway().getMappingById(transferId, namespace, batch));
        }
        return mappings;
    }
}

