/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhocworkflows.rest;

import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.labels.LabelParser;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.plugins.createcontent.extensions.BlueprintModuleDescriptor;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.plugin.ModuleCompleteKey;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.WikiStyleRenderer;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.user.User;
import com.comalatech.confluence.adhoc.AdhocWorkflowManager;
import com.comalatech.confluence.adhocworkflows.rest.AbstractContentWorkflowResources;
import com.comalatech.confluence.adhocworkflows.rest.model.BlueprintTemplateItem;
import com.comalatech.confluence.adhocworkflows.rest.model.BlueprintWorkflowCommand;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.users.UserSearchManager;
import com.comalatech.confluence.workflow.InternalWorkflowParameterManager;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.WorkflowAccessor;
import com.comalatech.confluence.workflow.WorkflowConfigurationManager;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.Workflows;
import com.comalatech.confluence.workflow.esignatures.configuration.ESignaturesConfigurationManager;
import com.comalatech.confluence.workflow.esignatures.service.ESignaturesService;
import com.comalatech.confluence.workflow.permissions.WorkflowPermissionManager;
import com.comalatech.confluence.workflowcontainer.WorkflowContainerManager;
import com.comalatech.workflow.WorkflowHandler;
import com.comalatech.workflow.template.LinkedTemplateManager;
import com.comalatech.workflow.template.WorkflowTemplateManager;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/blueprints")
public class BlueprintsResources
extends AbstractContentWorkflowResources {
    private static final Logger log = LoggerFactory.getLogger(BlueprintsResources.class);
    protected final LinkedTemplateManager linkedTemplateManager;
    protected final PluginAccessor pluginAccessor;

    public BlueprintsResources(PageManager pageManager, PermissionManager permissionManager, WorkflowPermissionManager workflowPermissionManager, SpaceManager spaceManager, SpacePermissionManager spacePermissionManager, AccessModeService accessModeService, WorkflowsFeatureManager workflowsFeatureManager, WorkflowConfigurationManager workflowConfigurationManager, WorkflowHandler workflowHandler, UserSearchManager userSearchManager, BootstrapManager bootstrapManager, WikiStyleRenderer wikiStyleRenderer, InternalWorkflowParameterManager workflowParameterManager, AdhocWorkflowManager adhocWorkflowManager, WorkflowTemplateManager workflowTemplateManager, WorkflowAccessor workflowAccessor, WorkflowContainerManager workflowContainerManager, LinkedTemplateManager linkedTemplateManager, PluginAccessor pluginAccessor, ESignaturesConfigurationManager eSignaturesConfigurationManager, ESignaturesService eSignaturesService) {
        super(pageManager, permissionManager, workflowPermissionManager, spaceManager, spacePermissionManager, accessModeService, workflowsFeatureManager, workflowConfigurationManager, workflowHandler, userSearchManager, bootstrapManager, wikiStyleRenderer, workflowParameterManager, adhocWorkflowManager, workflowTemplateManager, workflowAccessor, workflowContainerManager, eSignaturesConfigurationManager, eSignaturesService);
        this.linkedTemplateManager = linkedTemplateManager;
        this.pluginAccessor = pluginAccessor;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{spaceKey}")
    public Response getBlueprints(@PathParam(value="spaceKey") String spaceKey) {
        Space space = this.spaceManager.getSpace(spaceKey);
        if (space == null) {
            return Response.status((int)400).build();
        }
        if (!this.permissionManager.hasPermission((User)AuthenticatedUserThreadLocal.get(), Permission.ADMINISTER, (Object)space)) {
            return Response.status((int)403).build();
        }
        List<BlueprintTemplateItem> templates = this.getSpaceBlueprints(spaceKey);
        return Response.ok(templates).build();
    }

    private List<BlueprintTemplateItem> getSpaceBlueprints(String spaceKey) {
        List blueprints = this.pluginAccessor.getEnabledModuleDescriptorsByClass(BlueprintModuleDescriptor.class);
        ArrayList<BlueprintTemplateItem> blueprintTemplateses = new ArrayList<BlueprintTemplateItem>();
        List<Object> spaceWorkflows = !TextUtils.stringSet((String)spaceKey) ? new ArrayList() : this.workflowContainerManager.getAllProductionWorkflows(spaceKey);
        Workflows blueprintWorkflows = this.workflowAccessor.getBlueprintWorkflows();
        List<Workflow> availableWorkflows = this.getAvailableWorkflows(spaceKey);
        if (availableWorkflows.size() > 0) {
            for (BlueprintModuleDescriptor blueprint : blueprints) {
                ModuleCompleteKey templateModuleKey = blueprint.getFirstContentTemplateKey();
                if (templateModuleKey == null) continue;
                String templateKey = templateModuleKey.toString();
                String label = blueprint.getIndexKey();
                Workflow workflow = this.getWorkflow(spaceWorkflows, label);
                BlueprintTemplateItem blueprintTemplateItem = new BlueprintTemplateItem(templateKey, blueprint.getCompleteKey(), blueprint.getName(), label, workflow != null && workflow.isActive() ? workflow.getName() : null, availableWorkflows);
                blueprintTemplateItem.setWorkflowBlueprint(blueprintWorkflows.getByBlueprintKey(blueprint.getCompleteKey()));
                blueprintTemplateses.add(blueprintTemplateItem);
            }
        }
        return blueprintTemplateses;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/{spaceKey}/attach")
    public Response attach(@PathParam(value="spaceKey") String spaceKey, BlueprintWorkflowCommand data) {
        Space space = this.spaceManager.getSpace(spaceKey);
        String workflowName = data.getWorkflow();
        String blueprintKey = data.getBlueprintKey();
        String templateKey = data.getTemplateKey();
        String label = data.getLabel();
        if (space == null || LabelParser.parse((String)label) == null) {
            return Response.status((int)400).build();
        }
        if (!this.permissionManager.hasPermission((User)AuthenticatedUserThreadLocal.get(), Permission.ADMINISTER, (Object)space)) {
            return Response.status((int)403).build();
        }
        try {
            Workflow workflow = this.workflowAccessor.getBlueprintWorkflows().getByBlueprintKey(blueprintKey);
            if (workflow == null) {
                workflow = this.workflowContainerManager.getWorkflowTemplate(spaceKey, workflowName);
                if (workflow == null) {
                    workflow = this.workflowContainerManager.getWorkflowTemplate(null, workflowName);
                }
                if (workflow == null) {
                    return Response.status((int)404).build();
                }
            }
            List<BlueprintTemplateItem> spaceBlueprintTemplates = this.getSpaceBlueprints(spaceKey);
            for (BlueprintTemplateItem blueprintTemplateItem : spaceBlueprintTemplates) {
                if (!blueprintTemplateItem.getTemplateKey().equals(templateKey)) continue;
                String safeWorkflowName = this.getSafeWikiBlueprintName(blueprintTemplateItem.getBlueprintName());
                if (!TextUtils.stringSet((String)safeWorkflowName)) {
                    safeWorkflowName = workflow.getName();
                }
                workflow.setLabels(Arrays.asList(LabelParser.parse((String)label).toLabel()));
                workflow.setName(safeWorkflowName);
                this.workflowContainerManager.setActiveProductionWorkflow(spaceKey, workflow, true);
                blueprintTemplateItem.setWorkflowName(safeWorkflowName.toString());
                return Response.ok((Object)blueprintTemplateItem).build();
            }
            return Response.status((int)400).build();
        }
        catch (WorkflowException e) {
            log.error("", (Throwable)e);
            return Response.status((int)500).build();
        }
    }

    protected String getSafeWikiBlueprintName(String original) {
        if (TextUtils.stringSet((String)original)) {
            return original.replaceAll("[{:=]", "");
        }
        return "";
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/{spaceKey}/detach")
    public Response detach(@PathParam(value="spaceKey") String spaceKey, BlueprintWorkflowCommand data) {
        Space space = this.spaceManager.getSpace(spaceKey);
        String workflowName = data.getWorkflow();
        String templateKey = data.getTemplateKey();
        String label = data.getLabel();
        if (space == null || LabelParser.parse((String)label) == null) {
            return Response.status((int)400).build();
        }
        if (!this.permissionManager.hasPermission((User)AuthenticatedUserThreadLocal.get(), Permission.ADMINISTER, (Object)space)) {
            return Response.status((int)403).build();
        }
        try {
            Workflow workflow = this.workflowContainerManager.getProductionWorkflow(spaceKey, workflowName);
            if (workflow == null) {
                return Response.status((int)400).build();
            }
            this.workflowContainerManager.setActiveProductionWorkflow(spaceKey, workflow, false);
            List<BlueprintTemplateItem> workflows = this.getSpaceBlueprints(spaceKey);
            for (BlueprintTemplateItem blueprintTemplateItem : workflows) {
                if (!blueprintTemplateItem.getTemplateKey().equals(templateKey)) continue;
                return Response.ok((Object)blueprintTemplateItem).build();
            }
            return Response.status((int)400).build();
        }
        catch (WorkflowException e) {
            log.error("", (Throwable)e);
            return Response.status((int)500).build();
        }
    }

    private List<Workflow> getAvailableWorkflows(String spaceKey) {
        List<Workflow> workflows = this.workflowContainerManager.getAvailableWorkflowTemplates(this.spaceManager.getSpace(spaceKey));
        PageContext context = new PageContext();
        context.pushRenderMode(RenderMode.suppress((long)256L));
        for (Workflow workflow : workflows) {
            workflow.setRenderedDescription(this.wikiStyleRenderer.convertWikiToXHtml((RenderContext)context, workflow.getDescription()));
        }
        return workflows;
    }
}

