/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoc.command;

import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessBlocked;
import com.atlassian.confluence.core.service.ServiceCommandValidator;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.user.User;
import com.comalatech.confluence.adhoc.command.AbstractAdhocWorkflowCommand;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.WorkflowException;

@ReadOnlyAccessBlocked
public class SaveWorkflowTemplateCommand
extends AbstractAdhocWorkflowCommand {
    private String spaceKey;
    private String templateName;
    private String templateDescription;
    private SpaceManager spaceManager;

    @Override
    public void doWithWorkflow(Workflow workflow) throws WorkflowException {
        workflow.setName(this.templateName);
        workflow.setDescription(this.templateDescription);
        workflow.setAdhoc(false);
        this.workflowContainerManager.saveWorkflowTemplate(this.spaceKey, workflow, false, null);
    }

    @Override
    public void validateWorkflow(ServiceCommandValidator validator, Workflow workflow) {
        if (this.spaceKey == null) {
            if (!this.permissionManager.hasPermission((User)this.getAuthenticatedUser(), Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION)) {
                validator.addValidationError("Only Confluence administrators can save global workflow templates", new Object[0]);
            }
        } else {
            Space space = this.spaceManager.getSpace(this.spaceKey);
            if (space == null || !this.permissionManager.hasPermission((User)this.getAuthenticatedUser(), Permission.ADMINISTER, (Object)space)) {
                validator.addValidationError("You need space administration permission to save as template", new Object[0]);
            }
        }
    }

    @Override
    public boolean requiresExistingState() {
        return false;
    }

    @Override
    public boolean requiresExistingTask() {
        return false;
    }

    @Override
    public String getSpaceKey() {
        return this.spaceKey;
    }

    public void setSpaceKey(String spaceKey) {
        this.spaceKey = spaceKey;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    @Override
    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    public void setTemplateDescription(String templateDescription) {
        this.templateDescription = templateDescription;
    }
}

