/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoc.command;

import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessBlocked;
import com.atlassian.confluence.core.service.ServiceCommandValidator;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelParser;
import com.atlassian.confluence.labels.ParsedLabelName;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.WikiStyleRenderer;
import com.atlassian.renderer.v2.RenderMode;
import com.comalatech.confluence.adhoc.command.AbstractAdhocWorkflowCommand;
import com.comalatech.confluence.util.MiscUtils;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.WorkflowUserException;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collections;

@ReadOnlyAccessBlocked
public class SavePropertiesCommand
extends AbstractAdhocWorkflowCommand {
    private String newWorkflowName;
    private String newWorkflowDescription;
    private String newLabelName;
    AbstractAdhocWorkflowCommand.WorkflowResponse propertiesResponse;
    private WikiStyleRenderer wikiStyleRenderer;

    @Override
    public void doWithWorkflow(Workflow workflow) throws WorkflowException {
        workflow.setName(this.newWorkflowName);
        workflow.setDescription(this.newWorkflowDescription);
        if (TextUtils.stringSet((String)this.newLabelName)) {
            ArrayList<Label> newLabels = new ArrayList<Label>();
            for (String labelName : MiscUtils.splitAndTrim(this.newLabelName)) {
                ParsedLabelName parsedLabelName = LabelParser.parse((String)labelName);
                if (parsedLabelName == null) {
                    throw new WorkflowUserException("label.invalid.name", labelName);
                }
                newLabels.add(parsedLabelName.toLabel());
            }
            workflow.setLabels(newLabels);
        } else {
            workflow.setLabels(Collections.emptyList());
        }
        PageContext pageContext = new PageContext();
        pageContext.pushRenderMode(RenderMode.INLINE);
        String renderedBody = this.wikiStyleRenderer.convertWikiToXHtml((RenderContext)pageContext, workflow.getDescription());
        this.propertiesResponse = new PropertiesWorkflowResponse(renderedBody);
    }

    @Override
    public void validateWorkflow(ServiceCommandValidator validator, Workflow workflow) {
        if (!Page.isValidPageTitle((String)this.newWorkflowName)) {
            validator.addValidationError("comalatech.awp.designer.error.workflow.name", new Object[]{this.newWorkflowName});
        }
    }

    @Override
    public Object getBean() {
        if (this.propertiesResponse != null) {
            return this.propertiesResponse;
        }
        return super.getBean();
    }

    public void setWikiStyleRenderer(WikiStyleRenderer wikiStyleRenderer) {
        this.wikiStyleRenderer = wikiStyleRenderer;
    }

    public void setNewWorkflowDescription(String newWorkflowDescription) {
        this.newWorkflowDescription = newWorkflowDescription;
    }

    public void setNewWorkflowName(String newWorkflowName) {
        this.newWorkflowName = newWorkflowName;
    }

    public void setNewLabelName(String newLabelName) {
        this.newLabelName = newLabelName;
    }

    @Override
    public boolean requiresExistingState() {
        return false;
    }

    @Override
    public boolean requiresExistingTask() {
        return false;
    }

    public class PropertiesWorkflowResponse
    extends AbstractAdhocWorkflowCommand.WorkflowResponse {
        private String renderedDescription;

        public PropertiesWorkflowResponse(String renderedDescription) {
            this.renderedDescription = renderedDescription;
        }

        public String getRenderedDescription() {
            return this.renderedDescription;
        }
    }
}

