/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

var requirejs = require || requirejs;
requirejs(['cw', 'jquery'], function(CW, $) {
    CW.toInit(function () {
        // detect scroll versions installed
        var Scroll = window.Scroll || undefined,
            scrollVersions;

        if (Scroll && Scroll.Versions) {
            scrollVersions = true;
        }

        var qs = CW.queryString();
        // Workflows Dashboard v2
        var section = qs.section || 'space';
        var WorkflowsDashboardIframe = new CW.iframe({
            id: 'WorkflowsListIframe',
            url: '/admin/' + section + '/' + CW.getParam('spaceKey'),
            width: '100%',
            height: '100%',
            query: {
                workflowsVersion: CW.getParam('workflowVersion'),
                spaceName: CW.getParam('spaceName'),
                defaultEditMode: CW.getDarkFeature('comalatech.workflows.builder.defaultMarkup') ? 'markup' : 'builder',
                scrollVersions: scrollVersions
            }
        });
        $('#cw-admin-container').html(WorkflowsDashboardIframe.render());
        $('.cw-version').hide()

        CW.connect("reload", function () {
            WorkflowsDashboardIframe.send("reload");
        });

        // Workflow Picker
        var workflowPicker = new CW.Dialog({
            id: 'cw-addWorkflowDialog',
            width: 800,
            height: 550,
            path: '/workflow/' + CW.getParam('spaceKey') + '/add',
            query: {
                spaceName: CW.getParam('spaceName')
            }
        });
        if (qs.addSpaceWorkflow && qs.addSpaceWorkflow === 'true') {
            workflowPicker.show();
        }

        // Workflow Picker events
        CW.connect("workflowAdd", function () {
            this.show();
        }, workflowPicker);

        CW.connect("workflowAdded", function (data, i) {
            WorkflowsDashboardIframe.send('workflowAdded', data);
        }, workflowPicker);


        CW.connect("stateInitialize", function (workflowDataJSON) {
            var workflowData = JSON.parse(workflowDataJSON);
            // State Initialize
            var stateInitializer = new CW.Dialog({
                id: 'cw-stateInitializeDialog',
                width: 400,
                height: 375,
                path: '/admin/space/' + CW.getParam('spaceKey') + '/initstates',
                query: {
                    spaceName: CW.getParam('spaceName'),
                    workflowName: workflowData.workflowName,
                    states: workflowData.states.join(',')
                }
            });
            stateInitializer.show();
        });

        // Workflow Preview Modal
        CW.connect("workflowPreview", function (workflowDataJSON) {
            var type, workflowData = JSON.parse(workflowDataJSON);

            if (!workflowData.isPage) {
                type = 'space';
            } else {
                type = 'page';
            }

            // Workflow preview info
            var workflowPreview = new CW.Dialog({
                id: 'cw-workflowPreviewDialog',
                width: 800,
                height: 550,
                path: '/admin/' + type + '/' + CW.getParam('spaceKey') + '/preview',
                query: {
                    handle: workflowData.handle,
                    global: workflowData.global
                },
                customData: {
                    markup: workflowData.markup
                }
            });
            workflowPreview.show();
        });
        CW.Analytics.init(
            CW.getParam('comalaDocumentAnalyticsDomain'),
            CW.getParam('comalaDocumentAnalyticsKey'),
            CW.getParam('userLocale'),
            'space config'
        );
    });
});
