/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

// TODO: remove this code if not used anymore ( as commented by Naiara)

var AWP = AWP || {};

AWP.autocompleteFilteredUser = function(scope) {
    scope = scope || document.body;
    var $ = AJS.$;

     var makeRestMatrixFromData = function (restObj) {
        if (!restObj || !restObj.result){
            throw new Error("Invalid JSON format");
        }
        var matrix = [];
        matrix.push(restObj.result);
        return matrix;
    };

    $("input.autocomplete-filtered-user[data-autocomplete-filtered-user-bound!=\"true\"]", scope).each(function() {
        var $this = $(this)
                    .attr("data-autocomplete-filtered-user-bound", "true")
                    .attr("autocomplete", "off");
        var maxResults = $this.attr("data-max") || 10,
            alignment = $this.attr("data-alignment") || "left",
            dropDownTarget = $this.attr("data-dropdown-target"),
            dropDownPosition = null;

        if (dropDownTarget) {
            dropDownPosition = $(dropDownTarget);
        }
        else {
            dropDownPosition = $("<div></div>");
            $this.after(dropDownPosition);
        }

        if ($this.attr("data-resize-to-input")) {
            dropDownPosition.width($this.outerWidth());
            dropDownPosition.addClass("resize-to-input");
        } 
        dropDownPosition.addClass("aui-dd-parent autocomplete");

        var groups = $(this).attr("groups");
        var users = $(this).attr("users");
        groups = groups || "";
        users = users || "";

        $this.quicksearch("/rest/adhocworkflows/1/search/user.json?groups=" + groups + "&users=" + users,
            function() {
                $this.trigger("open.autocomplete-filtered-user");
            }, {
            makeParams : function(val) {
                return {
                    "max-results": maxResults,
                    query: val
                };
            },
            dropdownPlacement: function(dd) {
                dropDownPosition.append(dd);
            },
            makeRestMatrixFromData : makeRestMatrixFromData,
            addDropdownData : function (matrix) {
                if (!matrix.length) {
                    var noResults = $this.attr("data-none-message");
                    if (noResults) {
                        matrix.push([{
                            name: noResults,
                            className: "no-results",
                            href: "#"
                        }]);
                    }
                }

                return matrix;
            },
            ajsDropDownOptions : {
                alignment: alignment,
                displayHandler: function(obj) {
                    if (obj.restObj && obj.restObj.username) {
                        return obj.name + " (" + obj.restObj.username + ")";
                    }
                    return obj.name;
                },
                selectionHandler: function (e, selection) {

                    if (selection.find(".search-for").length) {
                        $this.trigger("selected.autocomplete-filtered-user", { searchFor: $this.val() });
                        return;
                    }
                    if (selection.find(".no-results").length) {
                        this.hide();
                        e.preventDefault();
                        return;
                    }

                    var contentProps = $("span:eq(0)", selection).data("properties"),
                        username = contentProps.restObj.username,
                        targetSelector = $this.attr("data-target"),
                        target = targetSelector && $(targetSelector),
                        template = $this.attr("data-template") || "{username}";

                    $this.val(AJS.template(template).fillHtml(contentProps.restObj));
                    target && target.val(username);
                    
                    $this.trigger("selected.autocomplete-filtered-user", { content: contentProps.restObj });
                    this.hide();
                    e.preventDefault();
                }
           }
        });
    });

};
