/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.facade;

import java.util.Map;
import java.util.WeakHashMap;
import org.randombits.facade.FacadeCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeakHashMapCache
implements FacadeCache {
    private Map<ClassLoader, Map<Object, Object>> loaderCache;

    @Override
    public <T> T get(Object sourceObject, Class<T> targetType) {
        Map<Object, Object> facadeCache;
        if (this.loaderCache != null && (facadeCache = this.loaderCache.get(targetType.getClassLoader())) != null) {
            return (T)facadeCache.get(sourceObject);
        }
        return null;
    }

    @Override
    public <T> void set(Object sourceObject, T facadeObject, Class<T> targetType) {
        Map<Object, Object> facadeCache = null;
        if (this.loaderCache != null) {
            facadeCache = this.loaderCache.get(targetType.getClassLoader());
        }
        if (facadeCache == null) {
            facadeCache = new WeakHashMap<Object, T>();
            if (this.loaderCache == null) {
                this.loaderCache = new WeakHashMap<ClassLoader, Map<Object, Object>>();
            }
            this.loaderCache.put(targetType.getClassLoader(), facadeCache);
        }
        facadeCache.put(sourceObject, facadeObject);
    }

    @Override
    public void remove(Object sourceObject, Class<?> targetType) {
        Map<Object, Object> facadeCache;
        if (this.loaderCache != null && (facadeCache = this.loaderCache.get(targetType.getClassLoader())) != null) {
            facadeCache.remove(sourceObject);
        }
    }

    @Override
    public void clear() {
        if (this.loaderCache != null) {
            for (Map<Object, Object> facadeCache : this.loaderCache.values()) {
                facadeCache.clear();
            }
            this.loaderCache.clear();
        }
        this.loaderCache = null;
    }
}

