/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.confluence.support;

import com.atlassian.spring.container.ContainerManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.log4j.Logger;
import org.randombits.confluence.support.Cache;

public final class CacheAssistant {
    private static final Logger LOG = Logger.getLogger(CacheAssistant.class);
    private static final CacheAssistant INSTANCE = new CacheAssistant();
    private Object transactionalCacheFactory = ContainerManager.getComponent((String)"transactionalCacheFactory");
    private Method getCacheMethod;
    private Method getReadThroughCacheForUpdateMethod;
    private Method getNameMethod;
    private Method getMethod;
    private Method putMethod;
    private Method removeMethod;
    private Method removeAllMethod;

    public static CacheAssistant getInstance() {
        return INSTANCE;
    }

    private CacheAssistant() {
        if (this.transactionalCacheFactory != null) {
            try {
                this.getCacheMethod = this.transactionalCacheFactory.getClass().getMethod("getCache", String.class);
                this.getReadThroughCacheForUpdateMethod = this.transactionalCacheFactory.getClass().getMethod("getReadThroughCacheForUpdate", String.class);
                if (this.getCacheMethod != null) {
                    Class<?> cacheClass = this.getCacheMethod.getReturnType();
                    this.getNameMethod = cacheClass.getMethod("getName", new Class[0]);
                    this.getMethod = cacheClass.getMethod("get", Object.class);
                    this.putMethod = cacheClass.getMethod("put", Object.class, Object.class);
                    this.removeMethod = cacheClass.getMethod("remove", Object.class);
                    this.removeAllMethod = cacheClass.getMethod("removeAll", new Class[0]);
                }
            }
            catch (SecurityException e) {
                LOG.error((Object)"Error while attempting to retrieve the cache", (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                LOG.error((Object)"Error while attempting to retrieve the cache", (Throwable)e);
            }
        }
    }

    public Cache getCache(String cacheName) {
        if (this.getCacheMethod != null) {
            try {
                return new CacheWrapper(this.getCacheMethod.invoke(this.transactionalCacheFactory, cacheName));
            }
            catch (IllegalArgumentException e) {
                LOG.error((Object)e);
            }
            catch (IllegalAccessException e) {
                LOG.error((Object)e);
            }
            catch (InvocationTargetException e) {
                LOG.error((Object)e);
            }
        }
        return null;
    }

    public Cache getReadThroughCacheForUpdate(String cacheName) {
        if (this.getReadThroughCacheForUpdateMethod != null) {
            try {
                return new CacheWrapper(this.getReadThroughCacheForUpdateMethod.invoke(this.transactionalCacheFactory, cacheName));
            }
            catch (IllegalArgumentException e) {
                LOG.error((Object)e);
            }
            catch (IllegalAccessException e) {
                LOG.error((Object)e);
            }
            catch (InvocationTargetException e) {
                LOG.error((Object)e);
            }
        }
        return null;
    }

    public class CacheWrapper
    implements Cache {
        private Object cache;

        public CacheWrapper(Object cache) {
            this.cache = cache;
        }

        public Object get(Object key) {
            try {
                return CacheAssistant.this.getMethod.invoke(this.cache, key);
            }
            catch (IllegalArgumentException e) {
                LOG.error((Object)e);
            }
            catch (IllegalAccessException e) {
                LOG.error((Object)e);
            }
            catch (InvocationTargetException e) {
                LOG.error((Object)e);
            }
            return null;
        }

        public void put(Object key, Object value) {
            try {
                CacheAssistant.this.putMethod.invoke(this.cache, key, value);
            }
            catch (IllegalArgumentException e) {
                LOG.error((Object)e);
            }
            catch (IllegalAccessException e) {
                LOG.error((Object)e);
            }
            catch (InvocationTargetException e) {
                LOG.error((Object)e);
            }
        }

        public void remove(Object key) {
            try {
                CacheAssistant.this.removeMethod.invoke(this.cache, key);
            }
            catch (IllegalArgumentException e) {
                LOG.error((Object)e);
            }
            catch (IllegalAccessException e) {
                LOG.error((Object)e);
            }
            catch (InvocationTargetException e) {
                LOG.error((Object)e);
            }
        }

        public void removeAll() {
            try {
                CacheAssistant.this.removeAllMethod.invoke(this.cache, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                LOG.error((Object)e);
            }
            catch (IllegalAccessException e) {
                LOG.error((Object)e);
            }
            catch (InvocationTargetException e) {
                LOG.error((Object)e);
            }
        }

        public String getName() {
            try {
                return (String)CacheAssistant.this.getNameMethod.invoke(this.cache, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                LOG.error((Object)e);
            }
            catch (IllegalAccessException e) {
                LOG.error((Object)e);
            }
            catch (InvocationTargetException e) {
                LOG.error((Object)e);
            }
            return null;
        }
    }
}

