/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.confluence.supplier;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.WikiStyleRenderer;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.spring.container.ContainerManager;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.lang.StringUtils;
import org.randombits.confluence.filtering.param.format.Separator;
import org.randombits.confluence.supplier.HierarchicalSupplier;
import org.randombits.confluence.supplier.KeyChainParser;
import org.randombits.confluence.supplier.LinkableSupplier;
import org.randombits.confluence.supplier.Supplier;
import org.randombits.confluence.supplier.SupplierException;
import org.randombits.confluence.supplier.SupplierFinder;
import org.randombits.confluence.supplier.UnsupportedContextException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SupplierAssistant {
    private static final String DEFAULT_SEPARATOR = ", ";
    private static final Pattern VALUE_PATTERN = Pattern.compile("\\%((?:[^\\%]|\\%\\%)+)\\%");
    private static final Pattern INJECTION_PATTERN = Pattern.compile("\\G((?:[^\\%]|\\%\\%)+|\\%(?:[^\\%]|\\%\\%)+\\%)");
    public static final char ESCAPE_DELIM = '%';
    public static final char PREFIX_DELIM = ':';
    private static final RenderMode RENDER_MODE = RenderMode.suppress((long)256L);
    private static final SupplierAssistant INSTANCE = new SupplierAssistant();
    private static final String SELF_KEY = "@self";
    private SupplierFinder supplierFinder = new SupplierFinder();
    private WikiStyleRenderer wikiStyleRenderer;

    private SupplierAssistant() {
    }

    public static SupplierAssistant getInstance() {
        return INSTANCE;
    }

    public Set<Supplier> getSuppliers() {
        return this.supplierFinder.getThings();
    }

    @Deprecated
    public String processValues(Object context, String text) throws SupplierException {
        try {
            Object result = this.injectValues(context, text);
            return result == null ? null : result.toString();
        }
        catch (UnsupportedContextException e) {
            throw new SupplierException("Invalid context.", e);
        }
    }

    public Object injectValues(Object context, String text) throws SupplierException, UnsupportedContextException {
        if (VALUE_PATTERN.matcher(text).matches()) {
            return this.findValue(context, this.unwrap(text));
        }
        Matcher matcher = INJECTION_PATTERN.matcher(text);
        StringBuilder out = new StringBuilder();
        int maxIndex = 0;
        while (matcher.find()) {
            maxIndex = matcher.end();
            String token = matcher.group();
            if (token.charAt(0) == '%') {
                token = this.unwrap(token);
                Object value = this.findValue(context, token);
                this.appendValue(out, value);
                continue;
            }
            out.append(this.unescape(token));
        }
        if (maxIndex != text.length()) {
            throw new SupplierException("Unexpected value at " + maxIndex + ": " + text.substring(maxIndex));
        }
        return out.toString();
    }

    private String unwrap(String token) {
        return this.unescape(token.substring(1, token.length() - 1));
    }

    private String unescape(String token) {
        return token.replaceAll("\\%\\%", "%");
    }

    public String htmlValue(Object context, String keyChain, Options options) throws SupplierException, UnsupportedContextException {
        String display;
        String url = null;
        Object value = this.findValue(context, keyChain);
        if (options.link) {
            url = this.findLink(context, keyChain);
        }
        if ((display = this.handleObject(value, url, options)) != null) {
            return display;
        }
        return this.handleDefaultValue(options);
    }

    private String handleDefaultValue(Options options) {
        String defaultValue = options.getDefaultValue();
        if (defaultValue != null) {
            return this.handleWiki(defaultValue, options);
        }
        return "";
    }

    private String handleObject(Object value, String url, Options options) throws SupplierException, UnsupportedContextException {
        if (value instanceof String) {
            return this.handleLink(this.handleString((String)value, options), url);
        }
        if (value instanceof Number) {
            return this.handleLink(this.handleNumber((Number)value, options), url);
        }
        if (value instanceof Date) {
            return this.handleLink(this.handleDate((Date)value, options), url);
        }
        if (value instanceof Boolean) {
            return this.handleLink(this.handleBoolean((Boolean)value, options), url);
        }
        if (value instanceof Collection) {
            return this.handleCollection((Collection)value, options);
        }
        if (value instanceof Iterator) {
            return this.handleIterator((Iterator)value, options);
        }
        if (value instanceof Enumeration) {
            return this.handleIterator(IteratorUtils.asIterator((Enumeration)value), options);
        }
        if (value != null) {
            if (value.getClass().isArray()) {
                return this.handleCollection(Arrays.asList((Object[])value), options);
            }
            Object newValue = SupplierAssistant.getInstance().findValue(value, null);
            if (options.link) {
                url = SupplierAssistant.getInstance().findLink(value, null);
            }
            return this.handleObject(newValue, url, options);
        }
        return null;
    }

    private String handleCollection(Collection<?> collection, Options options) throws SupplierException, UnsupportedContextException {
        if (collection.size() == 0) {
            return null;
        }
        Iterator<?> i = collection.iterator();
        return this.handleIterator(i, options);
    }

    private String handleIterator(Iterator<?> i, Options options) throws SupplierException, UnsupportedContextException {
        StringBuilder out = new StringBuilder();
        Separator separator = options.separator;
        if (separator != null) {
            out.append(separator.getPre());
        }
        while (i.hasNext()) {
            Object value = i.next();
            out.append(this.handleObject(value, null, options));
            if (!i.hasNext() || separator == null) continue;
            out.append(separator.getMid());
        }
        if (separator != null) {
            out.append(separator.getPost());
        }
        return out.toString();
    }

    private String handleLink(String display, String link) throws SupplierException, UnsupportedContextException {
        if (display != null && link != null) {
            StringBuilder out = new StringBuilder();
            out.append("<a href='").append(GeneralUtil.htmlEncode((String)link)).append("'>");
            out.append(display);
            out.append("</a>");
            return out.toString();
        }
        return display;
    }

    private String handleNumber(Number number, Options options) {
        if (number != null) {
            NumberFormat nf = options.getNumberFormat();
            String value = nf != null ? nf.format(number) : number.toString();
            return this.handleString(value, options);
        }
        return null;
    }

    private String handleDate(Date date, Options options) {
        if (date != null) {
            DateFormat df = options.getDateFormat();
            return this.handleString(df.format(date), options);
        }
        return null;
    }

    private String handleBoolean(Boolean value, Options options) {
        if (value != null) {
            this.handleString(value.toString(), options);
        }
        return null;
    }

    private String handleString(String string, Options options) {
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        switch (options.render) {
            case Wiki: {
                return this.handleWiki(string, options);
            }
        }
        return GeneralUtil.htmlEncode((String)string);
    }

    private String handleWiki(String markup, Options options) {
        PageContext ctx = options.context == null ? new PageContext() : options.context;
        return this.renderValue(markup, ctx);
    }

    private void appendValue(StringBuilder out, Object value) {
        if (value == null) {
            return;
        }
        if (value.getClass().isArray()) {
            Object[] values = (Object[])value;
            for (int i = 0; i < values.length; ++i) {
                if (i != 0) {
                    out.append(DEFAULT_SEPARATOR);
                }
                this.appendValue(out, values[i]);
            }
        } else if (value instanceof Collection) {
            this.appendCollection(out, (Collection)value);
        } else if (value instanceof Iterator) {
            this.appendIterator(out, (Iterator)value);
        } else {
            out.append(value);
        }
    }

    private void appendCollection(StringBuilder out, Collection<?> collection) {
        this.appendIterator(out, collection.iterator());
    }

    private void appendIterator(StringBuilder out, Iterator<?> iterator) {
        while (iterator.hasNext()) {
            Object value = iterator.next();
            this.appendValue(out, value);
            if (!iterator.hasNext()) continue;
            out.append(DEFAULT_SEPARATOR);
        }
    }

    public Object findValue(Object context, String keyChain) throws SupplierException, UnsupportedContextException {
        return this.findValue(context, keyChain, false);
    }

    public Object findValue(Object context, String keyChain, boolean renderWiki) throws UnsupportedContextException, SupplierException {
        return this.findSomething(context, keyChain, Type.VALUE, renderWiki);
    }

    private String renderValue(String value, ContentEntityObject content) {
        PageContext ctx = content != null ? content.toPageContext() : new PageContext();
        return this.renderValue(value, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String renderValue(String value, PageContext ctx) {
        ctx.pushRenderMode(RENDER_MODE);
        try {
            String string = this.getWikiStyleRenderer().convertWikiToXHtml((RenderContext)ctx, value);
            return string;
        }
        finally {
            ctx.popRenderMode();
        }
    }

    private WikiStyleRenderer getWikiStyleRenderer() {
        if (this.wikiStyleRenderer == null) {
            this.wikiStyleRenderer = (WikiStyleRenderer)ContainerManager.getComponent((String)"wikiStyleRenderer");
        }
        return this.wikiStyleRenderer;
    }

    private Object getValue(Supplier supplier, Object context, String key) throws SupplierException, UnsupportedContextException {
        return supplier.getValue(context, key);
    }

    public String findLink(Object context, String keyChain) throws SupplierException, UnsupportedContextException {
        return (String)this.findSomething(context, keyChain, Type.LINK);
    }

    public Object findParent(Object context, String keyChain) throws SupplierException, UnsupportedContextException {
        return this.findSomething(context, keyChain, Type.PARENT);
    }

    public Collection<?> findChildren(Object context, String keyChain) throws SupplierException, UnsupportedContextException {
        return (Collection)this.findSomething(context, keyChain, Type.CHILDREN);
    }

    private Object findSomething(Object context, String keyChain, Type type) throws SupplierException, UnsupportedContextException {
        return this.findSomething(context, keyChain, type, false);
    }

    private Object findSomething(Object context, String keyChain, Type type, boolean renderWiki) throws SupplierException, UnsupportedContextException {
        ContentEntityObject content = null;
        if (context instanceof ContentEntityObject) {
            content = (ContentEntityObject)context;
        }
        Object value = null;
        if (keyChain != null) {
            List<String> keys = KeyChainParser.parse(keyChain);
            Iterator<String> i = keys.iterator();
            while (context != null && i.hasNext()) {
                int prefixIndex;
                if (context instanceof ContentEntityObject) {
                    content = (ContentEntityObject)context;
                }
                String prefix = null;
                String key = i.next();
                if (key != null && (prefixIndex = key.indexOf(58)) > -1) {
                    prefix = prefixIndex > 0 ? key.substring(0, prefixIndex) : null;
                    key = key.substring(prefixIndex + 1);
                }
                if (i.hasNext()) {
                    context = value = this.getSomething(context, prefix, key, Type.VALUE);
                    continue;
                }
                value = this.getSomething(context, prefix, key, type);
            }
        } else {
            value = this.getSomething(context, null, null, type);
        }
        if (renderWiki && content != null && value instanceof String) {
            value = this.renderValue((String)value, content);
        }
        return value;
    }

    private Object getSomething(Object context, String prefix, String key, Type type) throws SupplierException, UnsupportedContextException {
        if (type == Type.VALUE && prefix == null && SELF_KEY.equals(key)) {
            return context;
        }
        if (this.supplierFinder != null) {
            for (Supplier supplier : this.supplierFinder.getThings()) {
                Object something;
                if (!supplier.supportsPrefix(prefix) || !supplier.supportsContext(context)) continue;
                switch (type) {
                    case LINK: {
                        something = this.getLink(supplier, context);
                        break;
                    }
                    case PARENT: {
                        something = this.getParent(supplier, context);
                        break;
                    }
                    case CHILDREN: {
                        something = this.getChildren(supplier, context);
                        break;
                    }
                    default: {
                        something = this.getValue(supplier, context, key);
                    }
                }
                if (something == null) continue;
                return something;
            }
        }
        return null;
    }

    private Object getChildren(Supplier supplier, Object context) throws SupplierException, UnsupportedContextException {
        if (supplier instanceof HierarchicalSupplier) {
            return ((HierarchicalSupplier)supplier).getChildren(context);
        }
        return null;
    }

    private String getLink(Supplier supplier, Object context) throws SupplierException, UnsupportedContextException {
        if (supplier instanceof LinkableSupplier) {
            return ((LinkableSupplier)supplier).getLink(context);
        }
        return null;
    }

    private Object getParent(Supplier supplier, Object context) throws SupplierException, UnsupportedContextException {
        if (supplier instanceof HierarchicalSupplier) {
            return ((HierarchicalSupplier)supplier).getParent(context);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Type {
        VALUE,
        LINK,
        PARENT,
        CHILDREN;

    }

    public static class Options {
        public static final String STANDARD_FORMAT = "standard";
        public static final String NUMBER_FORMAT = "number";
        public static final String INTEGER_FORMAT = "integer";
        public static final String PERCENT_FORMAT = "percent";
        public static final String CURRENCY_FORMAT = "currency";
        public static final String LONG_FORMAT = "long";
        public static final String MEDIUM_FORMAT = "medium";
        public static final String SHORT_FORMAT = "short";
        public static final String DEFAULT_FORMAT = "default";
        private String format = null;
        private boolean link = false;
        private String defaultValue = null;
        private DateFormat dateFormat = null;
        private NumberFormat numberFormat = null;
        private PageContext context;
        private Render render = Render.None;
        private Separator separator;

        public String getFormat() {
            return this.format;
        }

        public void setFormat(String format) {
            this.format = format;
        }

        public boolean isLink() {
            return this.link;
        }

        public void setLink(boolean link) {
            this.link = link;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public DateFormat getDateFormat() {
            if (this.dateFormat == null) {
                this.dateFormat = this.format == null || DEFAULT_FORMAT.equalsIgnoreCase(this.format) ? DateFormat.getInstance() : (MEDIUM_FORMAT.equalsIgnoreCase(this.format) ? DateFormat.getDateTimeInstance(2, 2) : (SHORT_FORMAT.equalsIgnoreCase(this.format) ? DateFormat.getDateTimeInstance(3, 3) : (LONG_FORMAT.equalsIgnoreCase(this.format) ? DateFormat.getDateTimeInstance(1, 1) : new SimpleDateFormat(this.format))));
            }
            return this.dateFormat;
        }

        public NumberFormat getNumberFormat() {
            if (this.numberFormat == null) {
                if (this.format != null) {
                    if (STANDARD_FORMAT.equals(this.format)) {
                        this.numberFormat = NumberFormat.getInstance();
                    } else if (CURRENCY_FORMAT.equals(this.format)) {
                        this.numberFormat = NumberFormat.getCurrencyInstance();
                    } else if (INTEGER_FORMAT.equals(this.format)) {
                        this.numberFormat = NumberFormat.getIntegerInstance();
                    } else if (PERCENT_FORMAT.equals(this.format)) {
                        this.numberFormat = NumberFormat.getPercentInstance();
                    } else if (NUMBER_FORMAT.equals(this.format)) {
                        this.numberFormat = NumberFormat.getNumberInstance();
                    } else if (this.format != null) {
                        this.numberFormat = new DecimalFormat(this.format);
                    }
                } else {
                    this.numberFormat = NumberFormat.getInstance();
                }
            }
            return this.numberFormat;
        }

        public PageContext getContext() {
            return this.context;
        }

        public void setContext(PageContext context) {
            this.context = context;
        }

        public Render getRender() {
            return this.render;
        }

        public void setRender(Render render) {
            this.render = render;
        }

        public Separator getSeparator() {
            return this.separator;
        }

        public void setSeparator(Separator separator) {
            this.separator = separator;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Render {
            None,
            Wiki;

        }
    }
}

