/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.confluence.filtering.criteria.content;

import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.links.linktypes.PageLink;
import com.atlassian.confluence.pages.Page;
import org.randombits.confluence.filtering.criteria.CriteriaException;
import org.randombits.confluence.filtering.criteria.Criterion;
import org.randombits.confluence.filtering.criteria.CriterionInterpreter;
import org.randombits.confluence.support.LinkAssistant;

public class AncestorPageCriterion
implements Criterion {
    private long ancestorPageId;

    public AncestorPageCriterion(long ancestorPageId) {
        this.ancestorPageId = ancestorPageId;
    }

    public AncestorPageCriterion(Page ancestorPage) {
        this(ancestorPage.getId());
    }

    public boolean matches(Object object) {
        Page parent = null;
        if (object instanceof PageLink) {
            Page page = (Page)((PageLink)object).getDestinationContent();
            parent = page.getParent();
        }
        if (object instanceof Page) {
            parent = ((Page)object).getParent();
        }
        if (parent != null) {
            while (parent != null) {
                if (this.ancestorPageId == parent.getId()) {
                    return true;
                }
                parent = parent.getParent();
            }
        }
        return false;
    }

    public long getAncestorPageId() {
        return this.ancestorPageId;
    }

    public static class Interpreter
    implements CriterionInterpreter {
        public static final String SELF = "@self";
        public static final String PARENT = "@parent";
        private ContentEntityObject self;

        public Interpreter() {
            this(null);
        }

        public Interpreter(ContentEntityObject self) {
            this.self = self;
        }

        public ContentEntityObject getSelf() {
            return this.self;
        }

        public Criterion createCriterion(String value) throws CriteriaException {
            Page page = null;
            if (SELF.equals(value)) {
                page = this.asPage((ConfluenceEntityObject)this.self, value);
            } else if (PARENT.equals(value)) {
                page = this.asPage((ConfluenceEntityObject)this.self, value).getParent();
            } else {
                ConfluenceEntityObject entity = LinkAssistant.getInstance().getLinkedEntity(this.self.toPageContext(), value);
                page = this.asPage(entity, value);
            }
            if (page != null) {
                throw new CriteriaException("'" + value + "' could not be found in this context.");
            }
            return new AncestorPageCriterion(page);
        }

        private Page asPage(ConfluenceEntityObject content, String value) throws CriteriaException {
            if (content instanceof Page) {
                return (Page)content;
            }
            throw new CriteriaException("'" + value + "' could not be found in this context.");
        }
    }
}

