/*
 * Decompiled with CFR 0.152.
 */
package net.customware.confluence.reporting;

import java.util.ArrayList;
import java.util.List;
import net.customware.confluence.reporting.ExecutionException;
import net.customware.confluence.reporting.ReportOutput;
import net.customware.confluence.reporting.ReportSetup;
import net.customware.confluence.reporting.query.Query;
import org.randombits.confluence.filtering.criteria.Criteria;
import org.randombits.confluence.filtering.criteria.Criterion;
import org.randombits.confluence.filtering.criteria.GroupCriteria;
import org.randombits.confluence.support.MacroInfo;
import org.randombits.storage.Storage;

public abstract class AbstractReportSetup<Output extends ReportOutput>
implements ReportSetup<Output> {
    public static final String DEPTH_PARAM = "depth";
    public static final String ALL_DEPTH = "all";
    private static final String MAX_RESULTS_PARAM = "maxResults";
    private static final String SORT_DESCENDENTS_PARAM = "sortDescendents";
    private static final String MATCH_ALL_PARAM = "matchAll";
    private static final String CLASS_PARAM = "class";
    private static final String INJECTED_PARAM = "injected";
    private static final String FIRST_RESULT_PARAM = "firstResult";
    private List<Output> outputs;
    private Criteria criteria;
    private boolean matchAll;
    private Query<? extends Object> query;
    private String empty;
    private String footer;
    private String header;
    private String cssClass;
    private int depth;
    private int maxResults;
    private boolean sortDescendents;
    private boolean injected;
    private int firstResult;

    public AbstractReportSetup(MacroInfo info) throws ExecutionException {
        this(info.getMacroParams());
    }

    public AbstractReportSetup(Storage params) throws ExecutionException {
        this.matchAll = params.getBoolean(MATCH_ALL_PARAM, true);
        this.cssClass = params.getString(CLASS_PARAM, null);
        this.maxResults = params.getInteger(MAX_RESULTS_PARAM, 0);
        this.firstResult = params.getInteger(FIRST_RESULT_PARAM, 1);
        this.sortDescendents = params.getBoolean(SORT_DESCENDENTS_PARAM, true);
        this.depth = this.findDepth(params, 0);
        this.injected = params.getBoolean(INJECTED_PARAM, false);
    }

    private int findDepth(Storage params, int depth) throws ExecutionException {
        String depthParam = params.getString(DEPTH_PARAM, null);
        if (depthParam != null) {
            try {
                depth = ALL_DEPTH.equalsIgnoreCase(depthParam) ? Integer.MAX_VALUE : Integer.parseInt(depthParam);
            }
            catch (NumberFormatException e) {
                throw new ExecutionException("Please supply a depth of 'all' or a whole number: " + depthParam);
            }
        }
        return depth;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public int getMaxResults() {
        return this.maxResults;
    }

    @Override
    public int getFirstResult() {
        return this.firstResult;
    }

    @Override
    public boolean isSortDescendents() {
        return this.sortDescendents;
    }

    @Override
    public abstract Class<Output> getOutputType();

    @Override
    public String getCssClass() {
        return this.cssClass;
    }

    @Override
    public void setCssClass(String cssClass) {
        this.cssClass = cssClass;
    }

    @Override
    public String getEmpty() {
        return this.empty;
    }

    @Override
    public void setEmpty(String empty) {
        this.empty = empty;
    }

    @Override
    public String getFooter() {
        return this.footer;
    }

    @Override
    public void setFooter(String footer) {
        this.footer = footer;
    }

    @Override
    public String getHeader() {
        return this.header;
    }

    @Override
    public void setHeader(String header) {
        this.header = header;
    }

    @Override
    public boolean isInjected() {
        return this.injected;
    }

    @Override
    public boolean isMatchAll() {
        return this.matchAll;
    }

    @Override
    public boolean addQuery(Query<? extends Object> query) {
        if (this.query == null) {
            this.query = query;
            return true;
        }
        return false;
    }

    @Override
    public boolean canAddQuery() {
        return this.query == null;
    }

    @Override
    public List<Output> getOutputs() {
        return this.outputs;
    }

    @Override
    public boolean addOutput(Output output) {
        Class<Output> outputType = this.getOutputType();
        if (outputType == null || !outputType.isInstance(output)) {
            return false;
        }
        if (this.outputs == null) {
            this.outputs = new ArrayList<Output>();
        }
        if (this.criteria != null) {
            output.setCriterion(this.criteria);
            this.criteria = null;
        }
        this.outputs.add(output);
        return true;
    }

    @Override
    public boolean addCriterion(Criterion criterion) {
        if (this.criteria == null) {
            this.criteria = new GroupCriteria(this.matchAll, new Criterion[0]);
        }
        this.criteria.addCriterion(criterion);
        return true;
    }

    @Override
    public Criteria getCriteria() {
        return this.criteria;
    }

    @Override
    public Query<? extends Object> getQuery() {
        return this.query;
    }

    @Override
    public Class<Object> getQueryValueType() {
        return Object.class;
    }
}

