/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.pageactivity;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.comalatech.confluence.states.model.Activity;
import com.comalatech.confluence.workflowreports.ReportDateFormatter;
import com.comalatech.confluence.workflowreports.model.ActivityEntry;
import com.comalatech.confluence.workflowreports.model.ActivityReportEntry;
import com.comalatech.confluence.workflowreports.model.ApprovalActivity;
import com.comalatech.confluence.workflowreports.model.ModificationActivity;
import com.comalatech.confluence.workflowreports.model.ReadAckActivity;
import com.comalatech.confluence.workflowreports.pageactivity.PageActivityEntryProcessor;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class PageActivityCsvEntryProcessorLegacy
implements PageActivityEntryProcessor {
    protected final PageManager pageManager;
    protected final ReportDateFormatter dateFormatter;

    public PageActivityCsvEntryProcessorLegacy(PageManager pageManager, ReportDateFormatter dateFormatter) {
        this.pageManager = pageManager;
        this.dateFormatter = dateFormatter;
    }

    @Override
    public <E> void processEntry(StringBuilder builder, AbstractPage page, E entry) {
        ActivityReportEntry activityReportEntry = (ActivityReportEntry)entry;
        List<ActivityEntry> activityEntries = activityReportEntry.getActivityEntries();
        for (ActivityEntry activityEntry : activityEntries) {
            List<Activity> activities = activityEntry.getActivities();
            Collections.reverse(activities);
            for (Activity activity : activities) {
                List<String> contributors;
                String formattedDate = StringEscapeUtils.escapeCsv((String)this.dateFormatter.formatServerDateTimePrecise(activity.getDate()));
                String username = activity.getPerformer();
                builder.append(formattedDate).append(",").append(username == null ? PageActivityCsvEntryProcessorLegacy.getTextStatic("com.comalatech.activity.report.csvexport.anonymous") : username).append(",");
                String contributorsCommaSeparated = "";
                if (activity instanceof ModificationActivity && (contributors = ((ModificationActivity)activity).getContributorsUsernames()) != null && !contributors.isEmpty()) {
                    contributorsCommaSeparated = StringUtils.join(contributors, (String)",");
                }
                builder.append(StringEscapeUtils.escapeCsv((String)this.removeCSVInjectionCharacters(contributorsCommaSeparated))).append(",");
                builder.append(activity.getActivityKey()).append(",").append(StringEscapeUtils.escapeCsv((String)this.removeCSVInjectionCharacters(this.getDescription(activity, activityEntry)))).append(",");
                Integer version = null;
                if (activity instanceof ModificationActivity) {
                    version = ((ModificationActivity)activity).getVersion();
                } else if (activity instanceof ApprovalActivity) {
                    version = activityEntry.getApprovalCheck().getVersion();
                } else if (activity instanceof ReadAckActivity) {
                    version = ((ReadAckActivity)activity).getVersion();
                } else if (activityEntry.getPageState() != null) {
                    version = activityEntry.getPageState().getContentVersion();
                } else if (activityEntry.getApprovalCheck() != null) {
                    version = activityEntry.getApprovalCheck().getVersion();
                }
                if (version != null) {
                    builder.append("v").append(version);
                    builder.append(",");
                    ContentEntityObject oldPage = this.pageManager.getOtherVersion((ContentEntityObject)page, version.intValue());
                    if (oldPage != null) {
                        builder.append(oldPage.getId());
                    }
                } else {
                    builder.append(",");
                }
                builder.append(",");
                if (activity.getComment() != null && activity.getComment().trim().length() > 0) {
                    builder.append(StringEscapeUtils.escapeCsv((String)this.removeCSVInjectionCharacters(activity.getComment())));
                }
                builder.append(LINE_SEPARATOR);
            }
        }
    }

    private String removeCSVInjectionCharacters(String content) {
        if (content != null) {
            content = content.replaceFirst("^[\\+\\-\\@\\=]", "");
        }
        return content;
    }

    private String getDescription(Activity activity, ActivityEntry activityEntry) {
        Map context = MacroUtils.defaultVelocityContext();
        context.put("activityEntry", activityEntry);
        context.put("activity", activity);
        context.put("dateFormatter", this.dateFormatter);
        String templatePath = "/templates/reports/activity/description/" + activity.getActivityKey() + "-description.vm";
        String description = VelocityUtils.getRenderedTemplate((String)templatePath, (Map)context);
        description = PageActivityEntryProcessor.removeHtmlTags(description);
        return description;
    }

    private static String getTextStatic(String key) {
        ConfluenceActionSupport dummy = GeneralUtil.newWiredConfluenceActionSupport();
        return dummy.getText(key);
    }
}

