/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.model.presenter.stats;

import com.comalatech.confluence.workflowreports.model.presenter.MacroParametersPresenter;
import com.comalatech.confluence.workflowreports.model.presenter.cql.CqlGroup;
import com.comalatech.confluence.workflowreports.model.presenter.cql.CqlOperators;
import com.comalatech.confluence.workflowreports.model.presenter.cql.CqlParam;
import com.comalatech.confluence.workflowreports.model.presenter.cql.CqlPrintable;
import com.comalatech.confluence.workflowreports.model.stats.DocumentStatsReportOptions;
import com.opensymphony.util.TextUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentStatsReportOptionsCqlPresenter
implements MacroParametersPresenter {
    private static final Logger log = LoggerFactory.getLogger(DocumentStatsReportOptionsCqlPresenter.class);
    private final DocumentStatsReportOptions options;
    private static final String SPACE_NAME = "space";
    private static final String PARENT_NAME = "parent";
    private static final String LABEL_NAME = "label";
    private static final String CURRENT_STATE_NAME = "content.property[comalaworkflows].currentState";
    private static final String WORKFLOW_NAMES = "content.property[comalaworkflows].workflowName";
    public static final String CQL_KEY = "cqlQuery";

    public DocumentStatsReportOptionsCqlPresenter(DocumentStatsReportOptions options) {
        this.options = options;
    }

    @Override
    public Map<String, Object> present() {
        return new HashMap<String, Object>(this.propertiesForCql());
    }

    private Map<? extends String, ?> propertiesForCql() {
        CqlGroup cqlGroup = new CqlGroup().joinOperator(CqlOperators.LogicalOperators.AND).addCqlElement(this.buildSimpleCqlParam(SPACE_NAME, this.options.getSpaceKey())).addCqlElement(this.buildSimpleCqlParam(PARENT_NAME, this.options.getParentPageId())).addCqlElement(this.buildSimpleCqlParam(CURRENT_STATE_NAME, Collections.singletonList(this.options.getStateName()))).addCqlElement(this.buildSimpleCqlParam(WORKFLOW_NAMES, this.options.getWorkflows())).addCqlElement(this.buildLabelsCqlParam());
        log.info("Stats report macro cql query: " + cqlGroup.toCqlString());
        return Collections.singletonMap(CQL_KEY, cqlGroup.toCqlString());
    }

    private CqlPrintable buildLabelsCqlParam() {
        CqlPrintable labelsCql;
        if (this.options.isAllLabelsMandatory()) {
            CqlGroup labelsGroup = new CqlGroup();
            for (String label : this.options.getLabels()) {
                labelsGroup.addCqlElement(this.buildSimpleCqlParam(LABEL_NAME, label));
            }
            labelsCql = labelsGroup;
        } else {
            labelsCql = this.buildSimpleCqlParam(LABEL_NAME, this.options.getLabels());
        }
        return labelsCql;
    }

    private CqlPrintable buildSimpleCqlParam(String name, String value) {
        if (TextUtils.stringSet((String)name) && TextUtils.stringSet((String)value)) {
            return new CqlParam(name, value);
        }
        return null;
    }

    private CqlPrintable buildSimpleCqlParam(String name, List<String> values) {
        List notEmptyValues = values.stream().filter(TextUtils::stringSet).collect(Collectors.toList());
        if (TextUtils.stringSet((String)name) && !notEmptyValues.isEmpty()) {
            return new CqlParam(name, values);
        }
        return null;
    }
}

