/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.model;

import com.comalatech.confluence.workflowreports.model.WorkflowReportEntry;
import java.util.Comparator;

class WorkflorReportEntryDashboardComparator
implements Comparator<WorkflowReportEntry> {
    WorkflorReportEntryDashboardComparator() {
    }

    @Override
    public int compare(WorkflowReportEntry entryOne, WorkflowReportEntry entryTwo) {
        long entryOneDueDate = this.getDueDateTime(entryOne);
        long entryTwoDueDate = this.getDueDateTime(entryTwo);
        long entryOneAssignmentDate = this.getAssignmentTime(entryOne);
        long entryTwoAssignmentDate = this.getAssignmentTime(entryTwo);
        if (entryOneDueDate > entryTwoDueDate) {
            return 1;
        }
        if (entryOneDueDate < entryTwoDueDate) {
            return -1;
        }
        if (entryOneAssignmentDate > entryTwoAssignmentDate) {
            return 1;
        }
        if (entryOneAssignmentDate < entryTwoAssignmentDate) {
            return -1;
        }
        return 0;
    }

    private long getDueDateTime(WorkflowReportEntry entry) {
        long dueDateTime = Long.MAX_VALUE;
        if (entry.getTask() != null) {
            if (entry.getTask().getDueDate() != null) {
                dueDateTime = entry.getTask().getDueDate().getTime();
            }
        } else if (entry.getApproval() != null && entry.getApproval().getDueDate() != null) {
            dueDateTime = entry.getApproval().getDueDate().getTime();
        }
        return dueDateTime;
    }

    private long getAssignmentTime(WorkflowReportEntry entry) {
        long assignmentTime = Long.MAX_VALUE;
        if (entry.getAssignment() != null) {
            assignmentTime = entry.getDate().getTime();
        }
        return assignmentTime;
    }
}

