/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.macro.parameter;

import java.util.Objects;

public abstract class ReportParameterValue<T> {
    protected T value;
    protected final T defaultValue;
    protected final Class clazz;

    public ReportParameterValue(T value) {
        this(value, null);
    }

    public ReportParameterValue(T value, T defaultValue) {
        this.value = value;
        this.defaultValue = defaultValue;
        this.clazz = value != null ? value.getClass() : (defaultValue != null ? defaultValue.getClass() : null);
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public Class getClazz() {
        return this.clazz;
    }

    public T getValueOrDefault() {
        return Objects.nonNull(this.value) ? this.value : this.defaultValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReportParameterValue that = (ReportParameterValue)o;
        return Objects.equals(this.value, that.value) && Objects.equals(this.defaultValue, that.defaultValue) && Objects.equals(this.clazz, that.clazz);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.defaultValue, this.clazz);
    }

    public String toString() {
        return "ReportParameterValue{value=" + this.value + ", defaultValue=" + this.defaultValue + ", clazz=" + this.clazz + '}';
    }
}

