/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowcontainer.model;

import com.comalatech.workflow.model.WorkflowVisibility;

public enum WorkflowVisibilityInternal {
    DEFAULT(WorkflowVisibility.DEFAULT, "default"),
    CONTRIBUTORS(WorkflowVisibility.CONTRIBUTORS, "contributors"),
    ANY(WorkflowVisibility.ANY, "any");

    private static final String VISIBILITY_SPACEADMINS = "spaceadmins";
    private String bandanaKey;
    public WorkflowVisibility apiVisibility;

    public static WorkflowVisibilityInternal parse(String bandanaKey) {
        for (WorkflowVisibilityInternal visibility : WorkflowVisibilityInternal.values()) {
            if (!visibility.bandanaKey.equals(bandanaKey)) continue;
            return visibility;
        }
        if (VISIBILITY_SPACEADMINS.equals(bandanaKey)) {
            return CONTRIBUTORS;
        }
        return null;
    }

    public static WorkflowVisibilityInternal publicToInternal(WorkflowVisibility apiVisibility) {
        if (apiVisibility.toString().equalsIgnoreCase(CONTRIBUTORS.toString())) {
            return CONTRIBUTORS;
        }
        if (apiVisibility.toString().equalsIgnoreCase(ANY.toString())) {
            return ANY;
        }
        return DEFAULT;
    }

    public static WorkflowVisibility internalToPublic(WorkflowVisibilityInternal visibilityInternal) {
        if (visibilityInternal.toString().equalsIgnoreCase(WorkflowVisibility.CONTRIBUTORS.toString())) {
            return WorkflowVisibility.CONTRIBUTORS;
        }
        if (visibilityInternal.toString().equalsIgnoreCase(WorkflowVisibility.ANY.toString())) {
            return WorkflowVisibility.ANY;
        }
        return WorkflowVisibility.DEFAULT;
    }

    private WorkflowVisibilityInternal(WorkflowVisibility apiEnumValue, String bandanaKey) {
        this.bandanaKey = bandanaKey;
        this.apiVisibility = apiEnumValue;
    }

    public String toString() {
        return this.bandanaKey;
    }

    public String getI18nKey() {
        return "approvalsworkflow.configuration." + this.bandanaKey;
    }
}

